package com.adobe.xfa.text;

/**
 * Package-local stuff.
 *
 * @exclude from published api.
 */
class Pkg {
	static final int EMBED_OBJ_CHAR				= 0xFFFC;

// Internal attribute codes.
	final static int ATTR_STATE_NORMAL			= 0;
	final static int ATTR_STATE_OPEN			= 1;
	final static int ATTR_STATE_CLOSE			= 2;

// Attribute mask codes.
	final static long AM_FONT					= (1L << 0);
	final static long AM_TYPEFACE				= (1L << 1);
	final static long AM_SIZE					= (1L << 2);
	final static long AM_WEIGHT					= (1L << 3);
	final static long AM_ITALIC					= (1L << 4);
	final static long AM_HORIZONTAL_SCALE		= (1L << 5);
	final static long AM_VERTICAL_SCALE			= (1L << 6);
	final static long AM_FONT_PARMS				= (	AM_TYPEFACE
												  | AM_SIZE
												  | AM_WEIGHT
												  | AM_ITALIC
												  );	// TODO: doesn't include vertical/horizontal scales
	final static long AM_ALL_FONT				= (AM_FONT | AM_FONT_PARMS | AM_HORIZONTAL_SCALE | AM_VERTICAL_SCALE);

	final static long AM_UNDERLINE				= (1L << 7);
	final static long AM_COLOUR					= (1L << 8);
	final static long AM_COLOURBG				= (1L << 9);
	final static long AM_STYLE					= (1L << 10);
	final static long AM_SHADE					= (1L << 11);
	final static long AM_SHADESCALE				= (1L << 12);
	final static long AM_OVERLINE				= (1L << 13);
	final static long AM_LINE_THROUGH			= (1L << 14);
	final static long AM_ALL_GFX				= (	AM_UNDERLINE
												  | AM_COLOUR
												  | AM_COLOURBG
												  | AM_STYLE
												  | AM_SHADE
												  | AM_SHADESCALE
												  | AM_OVERLINE
												  | AM_LINE_THROUGH
												  );

	final static long AM_GRAPHIC_CONTEXT		= (1L << 15);
	final static long AM_TEXT_CONTEXT			= (1L << 16);

	final static long AM_JUSTIFYV				= (1L << 17);
	final static long AM_JUSTIFYH				= (1L << 18);
	final static long AM_RADIXOFFSET			= (1L << 19);
	final static long AM_RADIXPOS				= (1L << 20);

	final static long AM_SPACING				= (1L << 21);
	final static long AM_SPACEBEFORE			= (1L << 22);
	final static long AM_SPACEAFTER				= (1L << 23);

	final static long AM_MARGINL				= (1L << 24);
	final static long AM_MARGINR				= (1L << 25);
	final static long AM_SPECIAL				= (1L << 26);

	final static long AM_TABS					= (1L << 27);

	final static long AM_TRANSPARENT			= (1L << 28);
	final static long AM_INVISIBLE				= (1L << 29);
	final static long AM_INVISCHAR				= (1L << 30);

	final static long AM_LOCALE					= (1L << 31);
	final static long AM_DIGITS					= (1L << 32);
	final static long AM_DIRECTION				= (1L << 33);
	final static long AM_PARA_DIRECTION			= (1L << 34);
	final static long AM_LAYOUT_ORIENTATION		= (1L << 35);
	final static long AM_LIGATURE				= (1L << 36);

	final static long AM_BASELINESHIFT			= (1L << 37);

	final static long AM_CHAR_SPACING			= (1L << 38);
	final static long AM_WORD_SPACING			= (1L << 39);
	final static long AM_KERNING				= (1L << 40);

	final static long AM_HYPH_LEVEL				= (1L << 41);
	final static long AM_HYPH_MIN_WORD			= (1L << 42);
	final static long AM_HYPH_MIN_PREFIX		= (1L << 43);
	final static long AM_HYPH_MIN_SUFFIX		= (1L << 44);
	final static long AM_HYPH_MAX_LINES			= (1L << 45);
	final static long AM_HYPH_SUPPRESS_NAMES	= (1L << 46);
	final static long AM_HYPH_SUPPRESS_ACRONYMS	= (1L << 47);

	final static long AM_LEADER_PATTERN 		= (1L << 48);
	final static long AM_LEADER_PATTERN_WIDTH	= (1L << 49);
	final static long AM_LEADER_ALIGN			= (1L << 50);
	final static long AM_LEADER_CONTENT 		= (1L << 51);
	final static long AM_RULE_STYLE 			= (1L << 52);
	final static long AM_RULE_THICKNESS 		= (1L << 53);

	final static String doIndent (int indent) {
		StringBuilder result = new StringBuilder();
		for (int i = 0; i < indent; i++) {
			result.append (' ');
		}
		return result.toString();
	}

}
