//----------------------------------------------------------------------
//
// File: mktext.h
//
// Description
//	Public header file for class MkText
//
//		This is a class that helps obtain all text from a stream
//		(ignoring attributes and embedded objects).  It uses the
//		markup translation framework, saving only the text
//		encountered.
//
// Change history
//	Project 	Release Date	Who 	Review	What
//	HawaiiRd	5.0 	951006	RD				Created.
//
//----------------------------------------------------------------------

package com.adobe.xfa.text.markup;



/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public class MarkupText extends MarkupOut {
	private final StringBuilder mpoTextOut = new StringBuilder();

	public MarkupText () {
	}

	public String getText () {
		return mpoTextOut.toString();
	}

	// Inherited from class TextMkOut.
	public void text (String sText) {
		mpoTextOut.append (sText);
	}

// We used to write out paragraphs as two carriage returns, but I couldn't
// see any good reason for that, so changed to one which makes much more
// sense for outputting plain text.
	public void para () {
		mpoTextOut.append ('\n');
	}

	public boolean suppressAttributes () {
		return true;
	}
}
