// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.rules.Vocable.Type;


/**
 * The rule covers the XMP types "open choice".
 * An arbitrary number of vocabulary can be added.
 * Additionally, this rule allows for arbitrary values,
 * while the vocabulary is rather a guidance for the UI.
 * 
 * 
 * @author Stefan Makswit
 */
public class OpenChoice extends ClosedChoice
{
	/**
	 * Constructor gets the type information of the Vocabulary.
	 */
	public OpenChoice(Type vocablularyType)
	{
		super(vocablularyType);
	}

	private static final long serialVersionUID = 1L;
	/** an optional rule for the open values */
	private TypeRule rule;

	
	/**
	 * @return Returns the rule which constrains the values for the open values.
	 */
	public TypeRule getRule()
	{
		return this.rule;
	}

	/**
	 * @param rule Sets the rule for the open values. 
	 * 			   This rule has to be type-compatible with
	 *			   the vocabulary of the rule 
	 */
	public void setRule(TypeRule rule)
	{
		this.rule = rule;
	}
}
