/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.Asset;
import com.day.image.Layer;

import javax.jcr.RepositoryException;
import java.awt.image.BufferedImage;
import java.awt.Color;
import java.io.InputStream;
import java.io.IOException;
import java.io.File;
import java.io.OutputStream;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.sling.commons.mime.MimeTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The <code>WebEnabledImageCreator</code> class provides all functionality in
 * order to create a web enabled image.
 *
 * @deprecated since 6.0, use {@link com.day.cq.dam.api.renditions.RenditionMaker} service instead
 */
@Deprecated
public class WebEnabledImageCreator {
    /**
     * Logger instance for this class.
     */
    private static final Logger log = LoggerFactory.getLogger(WebEnabledImageCreator.class);

    private static final String WEB_SPECIFIER = "web";

    /** the asset */
    private Asset asset;

    /** the mimetype service used for lookup */
    private MimeTypeService mimeTypeService;

    /**
     * @deprecated since 6.0, use {@link com.day.cq.dam.api.renditions.RenditionMaker} service instead
     */
    @Deprecated
    public WebEnabledImageCreator(Asset asset, MimeTypeService mimeTypeService) {
        this.asset = asset;
        this.mimeTypeService = mimeTypeService;
    }

    /**
     * This method creates the web enabled rendition. if the <code>force</code>
     * param is set to <code>false</code> than following check is executed:
     * check if layer has to persisted. in case the layer is still equal
     * than the ori file can be taken (save space).
     *
     * @param image buffered image used to create web enabled image
     * @param defaultMimetype default output mimetype
     * @param dimensions comma separated string containing max. with, max. height
     * @param keepFormat contains all mimetypes that should be kept (instead of using the default mimetype)
     * @param qualityStr image quality in percent
     * @param force if <code>true</code> than the webenabled image is always created
     * nevertheless the ori image is smaller than the requested image dimensions
     *
     * @throws RepositoryException in case the web rendition could not be persisted
     * @throws IOException while processing the image
     *
     * @deprecated since 6.0, use {@link com.day.cq.dam.api.renditions.RenditionMaker} service instead
     */
    @Deprecated
    public void create(BufferedImage image, String defaultMimetype, String dimensions,
                       String keepFormat, String qualityStr, boolean force)
            throws RepositoryException, IOException {
        throw new UnsupportedOperationException("No longer supported. Use com.day.cq.dam.api.renditions.RenditionMaker service instead");
    }

    //-------------< helper >---------------------------------------------------
    protected void saveImage(Asset asset, Layer layer, String mimetype,
                           double quality, String renditionName) throws IOException {
        File tmpFile = File.createTempFile(WEB_SPECIFIER, "." + getExtension(mimetype));
        OutputStream out = FileUtils.openOutputStream(tmpFile);
        InputStream is = null;
        try {
            layer.write(mimetype, quality, out);
            is = FileUtils.openInputStream(tmpFile);
            asset.addRendition(renditionName, is, mimetype);
        } finally {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(is);
            FileUtils.deleteQuietly(tmpFile);
        }
    }

    /**
     * A image with the given <code>maxWith</code> and <code>maxHeight</code>
     * is generated out if the <code>image</code> source.
     *
     * @param image     image source
     * @param maxWidth  max. thumbnail width
     * @param maxHeight max. thumbnail height
     * @return the resized image layer
     */
    protected Layer createImage(BufferedImage image, int maxWidth, int maxHeight) {
        long startTime = System.currentTimeMillis();
        Layer layer = new Layer(image);

        int height = layer.getHeight();
        int width = layer.getWidth();

        if (height > maxHeight || width > maxWidth) {
            // resize image
            int newWidth, newHeight;
            if (height > width) {
                newHeight = maxHeight;
                newWidth = Math.round(((float) width * (float) maxHeight / (float) height));
                if (newWidth > maxWidth) {
                    newWidth = maxWidth;
                    newHeight = Math.round(((float) height * (float) maxWidth / (float) width));
                }
            } else {
                newWidth = maxWidth;
                newHeight = Math.round(((float) height * (float) maxWidth / (float) width));
                if (newHeight > maxHeight) {
                    newHeight = maxHeight;
                    newWidth = Math.round(((float) width * (float) maxHeight / (float) height));
                }
            }
            layer.resize(newWidth, newHeight);
        }

        // ensure "transparency" (for gif images)
        if (asset.getName().endsWith(".gif")) {
            layer.setTransparency(new Color(0xFFF0E0D0));
        }
        log.debug("createImage took " + (System.currentTimeMillis() - startTime) + "ms");
        return layer;
    }

    protected String getExtension(String mimetype) {
        return mimeTypeService.getExtension(mimetype);
    }

    protected String getMimeType(Asset asset) {
        String name = asset.getName().toLowerCase();
        return mimeTypeService.getMimeType(name);
    }

    protected Integer[] getDimension(String dimensions) {
        if (dimensions != null) {
            String splits[] = dimensions.split(":");
            Integer d[] = new Integer[2];
            d[0] = Integer.valueOf(splits[0]);
            d[1] = Integer.valueOf(splits[1]);
            return d;
        }
        // default value(s)
        return new Integer[]{1000, 1000};
    }

    protected double getQuality(double base, String qualityStr) {
        int q = Integer.valueOf(qualityStr);
        double res = base * q / 100;
        return res;
    }
}
