/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.mailer.commons;

import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;


/**
 * Extents the {@link org.apache.commons.lang.text.StrSubstitutor StrSubstitutor}
 * to clean up variables that have not been replaced.
 * 
 * @since 5.4
 * @see StrSubstitutor
 */
public class ProfileVariableSubstitutor extends StrSubstitutor {
    public ProfileVariableSubstitutor(StrLookup lookup) {
        super(lookup);
    }

    /**
     * Replaces all the occurrences of variables with their matching values from the resolver using the given source string as a template.
     * if <code>doCleanup</code> non replaced variables are removed (i.e. replaced by "").
     * @param source - the string to replace in, null returns null
     * @param doCleanup - True to do the clean up
     * @return the result of the replace operation
     */
    public String replace(String source, boolean doCleanup) {
        String ret = this.replace(source);
        if( !doCleanup || ret == null) {
            return ret;
        }

        //StrMatcher prefixMatcher = getVariablePrefixMatcher();
        //StrMatcher suffixMatcher = getVariableSuffixMatcher();
        //TODO support non default prefix and suffix matchers.  StrMatcher has no toString method...
        char escape = getEscapeChar();

        String reg = "(?<!\\"+escape+")\\$\\{[a-zA-Z1-9\\.:]*\\}";
        try {
            ret = ret.replaceAll(reg,"");
        } catch (Exception e) {}

        return ret;
    }
}