package com.day.cq.wcm.designimporter.api;

/**
 * The factory that rolls out TagHandler instances
 */
public interface TagHandlerFactory{

    /**
     * The name of the OSGi property that defines the tag pattern this factory would come into action for.
     * The value of this property is expected to be a regex which is matched against an HTML tag. The
     * TagHandlerFactory that matches the HTML tag is chosen for creating a TagHandler instance. In case
     * of conflicts, the TagHandlerFactory with a higher service ranking wins.
     *
     */
    static public final String PN_TAGPATTERN = "tagpattern";

    /**
     * Creates a new TagHandler implementation instance.
     *
     * @return A new TagHandler instance
     */
    TagHandler create();
}
