/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="Expression Security Configuration", description="Configuration for EL expression security validation")
public @interface ExpressionSecurityConfig {
    public static final String PID = "com.adobe.granite.ui.components.ExpressionSecurityValidator";

    @AttributeDefinition(name="Blocked Patterns", description="Keywords that are blocked in EL expressions even if they would normally be allowed. Use this to blacklist malicious use cases that are being allowed by the security validator. This list has highest precendence. Eg. {\"load\"}")
    public String[] blockedPatterns() default {};

    @AttributeDefinition(name="Allowed Keywords", description="Keywords that are allowed in EL expressions even if they would normally be blocked. Use this to whitelist legitimate use cases that are being blocked by the security validator.")
    public String[] allowedKeywords() default {};

    @AttributeDefinition(name="Allowed Patterns", description="Regular expression patterns that are allowed in EL expressions even if they would normally be blocked. Use this to whitelist legitimate expression patterns. Be careful with regex patterns to avoid security vulnerabilities.")
    public String[] allowedPatterns() default {};

    @AttributeDefinition(name="Enable Validation", description="If disabled, all expression security validation will be bypassed. WARNING: This completely disables security validation - use only for debugging.")
    public boolean enableValidation() default true;

    @AttributeDefinition(name="Enable Unknown Expressions", description="If disabled, all expression that do not pass the allowlist or denylist check will be disabled.")
    public boolean enableUnknownExpressions() default true;
}

