/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.metadata;

import com.day.cq.dam.commons.metadata.XmpFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Adobe CQ DAM XmpFilter", description="Filtering Xmp Properties by block-/allow-listing names and namespaces")
@Service
public class XmpFilterBlackWhite
implements XmpFilter {
    private static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String LN_ALT = "Alt";
    private static final String LN_BAG = "Bag";
    private static final String LN_DESCRIPTION = "Description";
    private static final String LN_LI = "li";
    private static final String LN_RDF = "RDF";
    private static final String LN_SEQ = "Seq";
    private static final QName N_ALT = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Alt");
    private static final QName N_BAG = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Bag");
    private static final QName N_DESCRIPTION = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
    private static final QName N_LI = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li");
    private static final QName N_RDF = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
    private static final QName N_SEQ = new QName("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Seq");
    private static final Set<QName> RdfContainerNames;
    private static final Set<QName> IgnoredPropertyAttributeNames;
    private static final Set<String> IgnoredPropertyAttributeNamespaces;
    private static final boolean DEFAULT_APPLY_ALLOW_LIST = false;
    private static final boolean DEFAULT_APPLY_BLOCKLIST = true;
    private static final XMLResolver DEFAULT_XML_RESOLVER;
    @Property(boolValue={false}, label="Apply AllowList to XMP Properties", description="Only let the allowed xmp properties through, applied before any blocklist")
    public static final String APPLY_ALLOWLIST = "xmp.filter.apply_allowlist";
    public static final String ApplyWhiteList = "xmp.filter.apply_whitelist";
    @Property(value={""}, label="Allowed XML Names for XMP filtering", description="XML Names, such as '{namespace-uri}name', '{namespace-uri}*', 'prefix:name' and 'prefix:*', passed on during XMP filtering. Use '[>n]' or '[<n]' to limit the values accepted for multi-valued XMP properties. Example: 'history[<100]' will only let the first 99 values through", cardinality=0x7FFFFFFF)
    public static final String ALLOWLIST = "xmp.filter.allowlist";
    public static final String WhiteList = "xmp.filter.whitelist";
    @Property(boolValue={true}, label="Apply Blocklist to XMP Properties", description="Filter out the blocked xmp properties, applied after any allowlisting")
    public static final String APPLY_BLOCKLIST = "xmp.filter.apply_blocklist";
    public static final String ApplyBlackList = "xmp.filter.apply_blacklist";
    @Property(value={"{http://ns.adobe.com/photoshop/1.0/}DocumentAncestors[>100]", "xmpMM:Pantry", "xmpMM:History"}, label="Blocklisted XML Names for XMP filtering", description="XML Names, such as '{namespace-uri}name', '{namespace-uri}*', 'prefix:name' and 'prefix:*', filtered out during XMP processing. Use '[>n]' or '[<n]' to limit the values removed for multi-valued XMP properties. Example: 'history[>100]' discards the 101st and following values.", cardinality=0x7FFFFFFF)
    public static final String BLOCKLIST = "xmp.filter.blocklist";
    public static final String BlackList = "xmp.filter.blacklist";
    private static final Logger log;
    private EventConditionProvider filterConditions;
    private EventConditionProvider sieveConditions;

    private static NameConditionProvider parseNameList(Object list, boolean exclude, XmpFilterMode mode) {
        HashSet<String> namespaces = new HashSet<String>();
        HashMap<String, Set<String>> names = new HashMap<String, Set<String>>();
        HashSet<String> prefixes = new HashSet<String>();
        HashMap<String, Set<String>> prefixedNames = new HashMap<String, Set<String>>();
        HashMap<Object, EventCondition> conditions = new HashMap<Object, EventCondition>();
        NameDef n = new NameDef();
        for (String s : PropertiesUtil.toStringArray(list, new String[0])) {
            if (s.length() <= 0) continue;
            n.init(s);
            if (n.uri != null) {
                if ("*".equals(n.localName)) {
                    namespaces.add(n.uri);
                } else {
                    if (!names.containsKey(n.uri)) {
                        names.put(n.uri, new HashSet());
                    }
                    ((Set)names.get(n.uri)).add(n.localName);
                }
            } else if ("*".equals(n.localName)) {
                prefixes.add(n.prefix);
            } else {
                if (!prefixedNames.containsKey(n.prefix)) {
                    prefixedNames.put(n.prefix, new HashSet());
                }
                ((Set)prefixedNames.get(n.prefix)).add(n.localName);
            }
            if (n.condition == null) continue;
            conditions.put(n.condToken, n.condition);
        }
        return new NameConditionProvider(namespaces, names, prefixes, prefixedNames, conditions, exclude, mode);
    }

    public XmpFilterBlackWhite() {
        log.trace("instantiated");
    }

    public void setConfig(Dictionary cfg) {
        NameConditionProvider allow = null;
        NameConditionProvider block = null;
        NameConditionProvider oldAllow = XmpFilterBlackWhite.parseNameList(cfg.get(WhiteList), false, XmpFilterMode.FILTER);
        NameConditionProvider oldBlock = XmpFilterBlackWhite.parseNameList(cfg.get(BlackList), true, XmpFilterMode.FILTER);
        boolean applyAllowlist = false;
        boolean applyBlocklist = true;
        if (XmpFilterBlackWhite.parseNameList(cfg.get(ALLOWLIST), false, XmpFilterMode.FILTER) != null) {
            allow = XmpFilterBlackWhite.parseNameList(cfg.get(ALLOWLIST), false, XmpFilterMode.FILTER);
        } else if (oldAllow != null) {
            allow = oldAllow;
        }
        if (XmpFilterBlackWhite.parseNameList(cfg.get(BLOCKLIST), true, XmpFilterMode.FILTER) != null) {
            block = XmpFilterBlackWhite.parseNameList(cfg.get(BLOCKLIST), true, XmpFilterMode.FILTER);
        } else if (oldBlock != null) {
            block = oldBlock;
        }
        if (PropertiesUtil.toBoolean(cfg.get(APPLY_ALLOWLIST), false)) {
            applyAllowlist = PropertiesUtil.toBoolean(cfg.get(APPLY_ALLOWLIST), false);
        } else if (PropertiesUtil.toBoolean(cfg.get(ApplyWhiteList), false)) {
            applyAllowlist = PropertiesUtil.toBoolean(cfg.get(ApplyWhiteList), false);
        }
        if (!PropertiesUtil.toBoolean(cfg.get(APPLY_BLOCKLIST), true) && !block.isEmpty()) {
            applyBlocklist = PropertiesUtil.toBoolean(cfg.get(APPLY_BLOCKLIST), true);
        } else if (!PropertiesUtil.toBoolean(cfg.get(ApplyBlackList), true) && !oldBlock.isEmpty()) {
            applyBlocklist = PropertiesUtil.toBoolean(cfg.get(ApplyBlackList), true);
        }
        if (applyAllowlist && applyBlocklist) {
            this.filterConditions = new AndConditionProvider(allow, block, XmpFilterMode.FILTER);
            this.sieveConditions = new OrConditionProvider(block.newInstance(XmpFilterMode.SIEVE), allow.newInstance(XmpFilterMode.SIEVE), XmpFilterMode.SIEVE);
        } else if (applyAllowlist) {
            this.filterConditions = allow;
            this.sieveConditions = allow.newInstance(XmpFilterMode.SIEVE);
        } else if (applyBlocklist) {
            this.filterConditions = block;
            this.sieveConditions = block.newInstance(XmpFilterMode.SIEVE);
        } else {
            this.filterConditions = null;
            this.sieveConditions = null;
        }
    }

    @Activate
    protected void activate(ComponentContext ctx) {
        log.trace("activate");
        this.setConfig(ctx.getProperties());
    }

    @Override
    public boolean isActive() {
        return this.filterConditions != null;
    }

    @Override
    public InputStream filter(InputStream xmpIS) throws IOException {
        log.debug("filter");
        if (!this.isActive()) {
            return xmpIS;
        }
        XMLInputFactory xmlif = this.getInputFactory();
        try {
            XMLEventFilter filter = new XMLReaderEventFilter(xmlif.createXMLEventReader(xmpIS));
            if (this.filterConditions != null) {
                filter = new XmpPropFilter(filter, this.filterConditions.newInstance(XmpFilterMode.FILTER));
            }
            return new XMLEventReaderInputStream(filter, this.getOutputFactory());
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public InputStream sieve(InputStream xmpIS) throws IOException {
        log.debug("sieve");
        XMLInputFactory xmlif = this.getInputFactory();
        try {
            XMLEventFilter filter = new XMLReaderEventFilter(xmlif.createXMLEventReader(xmpIS));
            if (this.sieveConditions == null) {
                this.sieveConditions = XmpFilterBlackWhite.parseNameList("", false, XmpFilterMode.SIEVE);
            }
            filter = new XmpPropFilter(filter, this.sieveConditions.newInstance(XmpFilterMode.SIEVE));
            return new XMLEventReaderInputStream(filter, this.getOutputFactory());
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private XMLInputFactory getInputFactory() {
        XMLInputFactory xmlif = XMLInputFactory.newFactory();
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        xmlif.setXMLResolver(DEFAULT_XML_RESOLVER);
        return xmlif;
    }

    private XMLOutputFactory getOutputFactory() {
        XMLOutputFactory xmlof = XMLOutputFactory.newFactory();
        xmlof.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        return xmlof;
    }

    static {
        HashSet<QName> names = new HashSet<QName>();
        names.add(N_ALT);
        names.add(N_BAG);
        names.add(N_SEQ);
        RdfContainerNames = Collections.unmodifiableSet(names);
        names = new HashSet();
        IgnoredPropertyAttributeNames = Collections.unmodifiableSet(names);
        HashSet<String> namespaces = new HashSet<String>();
        namespaces.add(RDF_NS);
        IgnoredPropertyAttributeNamespaces = Collections.unmodifiableSet(namespaces);
        DEFAULT_XML_RESOLVER = new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                log.debug("Resolution of external entities in XML payload not supported - publicId: " + publicID + ", systemId: " + systemID);
                throw new XMLStreamException("This parser does not support resolution of external entities (publicId: " + publicID + ", systemId: " + systemID + ")");
            }
        };
        log = LoggerFactory.getLogger(XmpFilterBlackWhite.class);
    }

    private static final class StartElementWrapper
    implements StartElement {
        private final StartElement se;
        private final Map<QName, Attribute> attributes;

        StartElementWrapper(StartElement se, Set<QName> removeAttributes) {
            this.se = se;
            this.attributes = new HashMap<QName, Attribute>();
            Iterator<Attribute> attrIter = se.getAttributes();
            while (attrIter.hasNext()) {
                Attribute attr = attrIter.next();
                if (removeAttributes.contains(attr.getName())) continue;
                this.attributes.put(attr.getName(), attr);
            }
        }

        @Override
        public QName getName() {
            return this.se.getName();
        }

        public Iterator getAttributes() {
            return this.attributes.values().iterator();
        }

        public Iterator getNamespaces() {
            return this.se.getNamespaces();
        }

        @Override
        public Attribute getAttributeByName(QName name) {
            return this.attributes.get(name);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.se.getNamespaceContext();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.se.getNamespaceURI(prefix);
        }

        @Override
        public int getEventType() {
            return this.se.getEventType();
        }

        @Override
        public Location getLocation() {
            return this.se.getLocation();
        }

        @Override
        public boolean isStartElement() {
            return this.se.isStartElement();
        }

        @Override
        public boolean isAttribute() {
            return this.se.isAttribute();
        }

        @Override
        public boolean isNamespace() {
            return this.se.isNamespace();
        }

        @Override
        public boolean isEndElement() {
            return this.se.isEndElement();
        }

        @Override
        public boolean isEntityReference() {
            return this.se.isEntityReference();
        }

        @Override
        public boolean isProcessingInstruction() {
            return this.se.isProcessingInstruction();
        }

        @Override
        public boolean isCharacters() {
            return this.se.isCharacters();
        }

        @Override
        public boolean isStartDocument() {
            return this.se.isStartDocument();
        }

        @Override
        public boolean isEndDocument() {
            return this.se.isEndDocument();
        }

        @Override
        public StartElement asStartElement() {
            return this;
        }

        @Override
        public EndElement asEndElement() {
            return this.se.asEndElement();
        }

        @Override
        public Characters asCharacters() {
            return this.se.asCharacters();
        }

        @Override
        public QName getSchemaType() {
            return this.se.getSchemaType();
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            this.se.writeAsEncodedUnicode(writer);
        }
    }

    private final class ReadableByteArrayOutputStream
    extends ByteArrayOutputStream {
        ReadableByteArrayOutputStream(int size) {
            super(size);
        }

        int read(byte[] b, int off, int len) throws IOException {
            if (len > this.count) {
                len = this.count;
            }
            if (len > 0) {
                int remain = this.count - len;
                System.arraycopy(this.buf, 0, b, off, len);
                if (remain > 0) {
                    System.arraycopy(this.buf, len, this.buf, 0, remain);
                }
                this.count -= len;
            }
            return len;
        }
    }

    private final class XMLEventReaderInputStream
    extends InputStream {
        final XMLEventWriter writer;
        final XMLEventFilter filter;
        final ReadableByteArrayOutputStream output;
        boolean closed;

        XMLEventReaderInputStream(XMLEventFilter filter, XMLOutputFactory xmlof) throws XMLStreamException {
            this.filter = filter;
            this.output = new ReadableByteArrayOutputStream(4096);
            this.writer = xmlof.createXMLEventWriter(this.output, "utf-8");
            this.closed = false;
        }

        @Override
        public int available() throws IOException {
            return this.output.size();
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (!this.closed) {
                try {
                    this.filter.close();
                }
                catch (XMLStreamException ex2) {
                    log.debug("closing filter", ex2);
                }
                try {
                    this.writer.close();
                }
                catch (XMLStreamException ex2) {
                    log.debug("closing writer", ex2);
                }
                this.closed = true;
            }
        }

        @Override
        public int read() throws IOException {
            this.prefill(1);
            byte[] x = new byte[1];
            int len = this.output.read(x, 0, 1);
            return len > 0 ? x[0] : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.prefill(len);
            len = this.output.read(b, off, len);
            return len > 0 || !this.closed ? len : -1;
        }

        private void prefill(int length) throws IOException {
            try {
                while (!this.closed && this.output.size() < length) {
                    if (!this.filter.hasNext()) {
                        this.close();
                        break;
                    }
                    this.writer.add(this.filter.nextEvent());
                }
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
    }

    private class XmpPropFilter
    implements XMLEventFilter {
        private final EventConditionProvider conditions;
        private final XMLEventFilter filter;
        private final List<XMLEvent> nextEvents;
        private XmpFilterState state;
        private EventCondition eventCondition;
        private Stack<EventCondition> conditionStack;
        private Set<QName> scratchNames;
        private boolean accepted;
        private int level;
        private int ignoreLevel;

        XmpPropFilter(XMLEventFilter filter, EventConditionProvider conditions) {
            this.filter = filter;
            this.conditions = conditions;
            this.nextEvents = new ArrayList<XMLEvent>();
            this.eventCondition = EventCondition.ACCEPT;
            this.scratchNames = new HashSet<QName>();
            this.conditionStack = new Stack();
            this.conditionStack.push(EventCondition.DENY);
            this.accepted = true;
            this.ignoreLevel = Integer.MAX_VALUE;
            this.state = XmpFilterState.LOOKING_FOR_RDF;
            this.level = 0;
        }

        @Override
        public XMLEvent nextEvent() throws XMLStreamException {
            if (this.hasNext()) {
                return this.nextEvents.remove(0);
            }
            throw new XMLStreamException("no more events available");
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            while (this.nextEvents.isEmpty() && this.filter.hasNext()) {
                this.process(this.filter.nextEvent());
            }
            return !this.nextEvents.isEmpty();
        }

        private void process(XMLEvent event) {
            switch (event.getEventType()) {
                case 1: {
                    QName name = event.asStartElement().getName();
                    switch (this.state) {
                        case LOOKING_FOR_RDF: {
                            if (!N_RDF.equals(name)) break;
                            this.state = XmpFilterState.INSIDE_RDF;
                            this.eventCondition = EventCondition.ACCEPT;
                            ++this.level;
                            break;
                        }
                        case INSIDE_RDF: {
                            if (this.level <= this.ignoreLevel) {
                                this.eventCondition = RdfContainerNames.contains(name) || N_LI.equals(name) ? this.conditionStack.peek() : this.conditions.getCondition(name);
                            }
                            ++this.level;
                        }
                    }
                    int n = this.nextEvents.size();
                    if (this.level <= this.ignoreLevel) {
                        this.conditionStack.push(this.eventCondition);
                        this.accepted = this.eventCondition.accepts(event, this.nextEvents);
                        if (!this.accepted) {
                            this.ignoreLevel = this.level;
                        }
                    }
                    if (!this.accepted) {
                        if (!log.isDebugEnabled()) break;
                        log.debug("excluded: {}", (Object)name);
                        break;
                    }
                    if (this.state != XmpFilterState.INSIDE_RDF) break;
                    this.filterPropertyAttributesAt(n);
                    break;
                }
                case 2: {
                    QName name = event.asEndElement().getName();
                    if (XmpFilterState.INSIDE_RDF == this.state && N_RDF.equals(name)) {
                        this.state = XmpFilterState.LOOKING_FOR_RDF;
                        this.eventCondition = EventCondition.ACCEPT;
                    }
                    if (this.level <= this.ignoreLevel) {
                        this.eventCondition = this.conditionStack.pop();
                        this.accepted = this.eventCondition.accepts(event, this.nextEvents);
                    }
                    if (this.level == this.ignoreLevel) {
                        this.ignoreLevel = Integer.MAX_VALUE;
                    }
                    --this.level;
                    break;
                }
                default: {
                    if (this.level >= this.ignoreLevel) break;
                    EventCondition.ACCEPT.accepts(event, this.nextEvents);
                }
            }
        }

        private void filterPropertyAttributesAt(int index) {
            XMLEvent event = this.nextEvents.get(index);
            if (event.getEventType() == 1) {
                StartElement se = event.asStartElement();
                this.scratchNames.clear();
                Iterator<Attribute> attrIter = se.getAttributes();
                while (attrIter.hasNext()) {
                    EventCondition cond;
                    Attribute attr = attrIter.next();
                    QName aname = attr.getName();
                    if (IgnoredPropertyAttributeNamespaces.contains(aname.getNamespaceURI()) || IgnoredPropertyAttributeNames.contains(aname) || (cond = this.conditions.getCondition(aname)).acceptsValue(attr.getValue())) continue;
                    this.scratchNames.add(aname);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("excluded: {}", (Object)aname);
                }
                if (!this.scratchNames.isEmpty()) {
                    event = new StartElementWrapper(se, this.scratchNames);
                    this.scratchNames.clear();
                    this.nextEvents.remove(index);
                    this.nextEvents.add(index, event);
                }
            }
        }

        @Override
        public void close() throws XMLStreamException {
            this.filter.close();
        }
    }

    private static class XMLReaderEventFilter
    implements XMLEventFilter {
        private final XMLEventReader reader;
        private XMLEvent nextEvent;

        XMLReaderEventFilter(XMLEventReader reader) {
            this.reader = reader;
        }

        @Override
        public XMLEvent nextEvent() throws XMLStreamException {
            if (this.hasNext()) {
                XMLEvent ev = this.nextEvent;
                this.nextEvent = null;
                return ev;
            }
            throw new XMLStreamException("no more events available");
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            while (this.nextEvent == null && this.reader.hasNext()) {
                this.nextEvent = this.reader.nextEvent();
            }
            return this.nextEvent != null;
        }

        @Override
        public void close() throws XMLStreamException {
            this.reader.close();
        }
    }

    static interface XMLEventFilter {
        public XMLEvent nextEvent() throws XMLStreamException;

        public boolean hasNext() throws XMLStreamException;

        public void close() throws XMLStreamException;
    }

    private static enum XmpFilterState {
        LOOKING_FOR_RDF,
        INSIDE_RDF;

    }

    private static class OrConditionProvider
    implements EventConditionProvider {
        final EventConditionProvider cond1;
        final EventConditionProvider cond2;
        final Map<QName, EventCondition> env;

        OrConditionProvider(EventConditionProvider white, EventConditionProvider black, XmpFilterMode mode) {
            this.cond1 = white.newInstance(mode);
            this.cond2 = black.newInstance(mode);
            this.env = new HashMap<QName, EventCondition>();
        }

        @Override
        public EventCondition getCondition(QName name) {
            EventCondition cond = this.env.get(name);
            if (cond == null) {
                EventCondition cw = this.cond1.getCondition(name);
                if (cw == EventCondition.DENY) {
                    return this.cond2.getCondition(name);
                }
                EventCondition cb = this.cond2.getCondition(name);
                if (cb == EventCondition.DENY) {
                    return cw;
                }
                cond = new OrCondition(cw, cb);
                this.env.put(name, cond);
            }
            return cond;
        }

        @Override
        public boolean isEmpty() {
            return this.cond1.isEmpty() && this.cond2.isEmpty();
        }

        @Override
        public EventConditionProvider newInstance(XmpFilterMode mode) {
            return new OrConditionProvider(this.cond1, this.cond2, mode);
        }
    }

    private static class AndConditionProvider
    implements EventConditionProvider {
        final EventConditionProvider cond1;
        final EventConditionProvider cond2;
        final Map<QName, EventCondition> env;

        AndConditionProvider(EventConditionProvider white, EventConditionProvider black, XmpFilterMode mode) {
            this.cond1 = white.newInstance(mode);
            this.cond2 = black.newInstance(mode);
            this.env = new HashMap<QName, EventCondition>();
        }

        @Override
        public EventCondition getCondition(QName name) {
            EventCondition cond = this.env.get(name);
            if (cond == null) {
                EventCondition cw = this.cond1.getCondition(name);
                if (cw == EventCondition.ACCEPT) {
                    return this.cond2.getCondition(name);
                }
                EventCondition cb = this.cond2.getCondition(name);
                if (cb == EventCondition.ACCEPT) {
                    return cw;
                }
                cond = new AndCondition(cw, cb);
                this.env.put(name, cond);
            }
            return cond;
        }

        @Override
        public boolean isEmpty() {
            return this.cond1.isEmpty() && this.cond2.isEmpty();
        }

        @Override
        public EventConditionProvider newInstance(XmpFilterMode mode) {
            return new AndConditionProvider(this.cond1, this.cond2, mode);
        }
    }

    private static class NameConditionProvider
    implements EventConditionProvider {
        private final Set<String> namespaces;
        private final Map<String, Set<String>> names;
        private final Set<String> prefixes;
        private final Map<String, Set<String>> prefixedNames;
        private final Map<Object, EventCondition> conditions;
        private final boolean exclude;
        private final XmpFilterMode mode;
        Map<Object, EventCondition> env;

        NameConditionProvider(Set<String> namespaces, Map<String, Set<String>> names, Set<String> prefixes, Map<String, Set<String>> prefixedNames, Map<Object, EventCondition> conditions, boolean exclude, XmpFilterMode mode) {
            this.namespaces = namespaces;
            this.names = names;
            this.prefixes = prefixes;
            this.prefixedNames = prefixedNames;
            this.conditions = conditions;
            this.exclude = exclude;
            this.mode = mode;
            this.env = Collections.emptyMap();
        }

        NameConditionProvider(NameConditionProvider base, boolean exclude, XmpFilterMode mode) {
            this.namespaces = base.namespaces;
            this.names = base.names;
            this.prefixes = base.prefixes;
            this.prefixedNames = base.prefixedNames;
            this.conditions = base.conditions;
            this.exclude = exclude;
            this.mode = mode;
            this.env = new HashMap<Object, EventCondition>();
        }

        @Override
        public EventCondition getCondition(QName name) {
            Object token = this.getConditionToken(name);
            if (token == null) {
                return this.exclude ? EventCondition.ACCEPT : EventCondition.DENY;
            }
            EventCondition cond = this.env.get(token);
            if (cond == null) {
                cond = this.getDefinedCondition(token, name).newInstance(this.exclude, this.mode);
                this.env.put(token, cond);
            }
            return cond;
        }

        @Override
        public boolean isEmpty() {
            return this.conditions.isEmpty() && this.namespaces.isEmpty() && this.names.isEmpty() && this.prefixes.isEmpty() && this.prefixedNames.isEmpty();
        }

        @Override
        public EventConditionProvider newInstance(XmpFilterMode mode) {
            if (this.mode == mode) {
                return new NameConditionProvider(this, this.exclude, mode);
            }
            return new NameConditionProvider(this, !this.exclude, mode);
        }

        private Object getConditionToken(QName qname) {
            String uri = qname.getNamespaceURI();
            String localName = qname.getLocalPart();
            if (this.namespaces.contains(uri) || this.names.containsKey(uri) && this.names.get(uri).contains(localName)) {
                return qname;
            }
            String prefix = qname.getPrefix();
            if (this.prefixes.contains(prefix) || this.prefixedNames.containsKey(prefix) && this.prefixedNames.get(prefix).contains(localName)) {
                return prefix + ":" + localName;
            }
            if (this.namespaces.contains("*") || this.names.containsKey("*") && this.names.get("*").contains(localName)) {
                return new QName("*", localName);
            }
            if (this.prefixes.contains("*") || this.prefixedNames.containsKey("*") && this.prefixedNames.get("*").contains(localName)) {
                return "*:" + localName;
            }
            return null;
        }

        private EventCondition getDefinedCondition(Object token, QName name) {
            EventCondition cond = this.conditions.get(token);
            if (cond == null) {
                cond = this.conditions.get(name.getNamespaceURI());
            }
            if (cond == null) {
                cond = this.conditions.get(name.getPrefix() + ":*");
            }
            if (cond == null) {
                cond = this.conditions.get(new QName("*", name.getLocalPart()));
            }
            if (cond == null) {
                cond = this.conditions.get("*:" + name.getLocalPart());
            }
            if (cond == null) {
                cond = this.conditions.get("*:*");
            }
            if (cond == null) {
                cond = this.conditions.get("*");
            }
            if (cond == null) {
                cond = EventCondition.ACCEPT;
            }
            return cond;
        }
    }

    static interface EventConditionProvider {
        public EventCondition getCondition(QName var1);

        public boolean isEmpty();

        public EventConditionProvider newInstance(XmpFilterMode var1);
    }

    private static class MinIndexCondition
    extends AbstractIndexCondition {
        MinIndexCondition(int minIndex) {
            super(minIndex);
        }

        @Override
        protected boolean shouldAccept() {
            return this.getItemCount() >= this.getIndex();
        }

        @Override
        public EventCondition newInstance(boolean inverse, XmpFilterMode mode) {
            if (mode == XmpFilterMode.SIEVE) {
                return ACCEPT.newInstance(inverse, mode);
            }
            return inverse ? new MinIndexCondition(this.getIndex()) : new MaxIndexCondition(this.getIndex() - 1);
        }
    }

    private static class MaxIndexCondition
    extends AbstractIndexCondition {
        MaxIndexCondition(int maxIndex) {
            super(maxIndex);
        }

        @Override
        protected boolean shouldAccept() {
            return this.getItemCount() <= this.getIndex();
        }

        @Override
        public EventCondition newInstance(boolean inverse, XmpFilterMode mode) {
            if (mode == XmpFilterMode.SIEVE) {
                return ACCEPT.newInstance(inverse, mode);
            }
            return inverse ? new MaxIndexCondition(this.getIndex()) : new MinIndexCondition(this.getIndex() + 1);
        }
    }

    private static abstract class AbstractIndexCondition
    implements EventCondition {
        private final int index;
        private int level;
        private int itemCount = 0;
        private boolean ignore = false;
        private boolean insideContainer = false;

        AbstractIndexCondition(int index) {
            this.index = index;
        }

        protected int getIndex() {
            return this.index;
        }

        protected int getItemCount() {
            return this.itemCount;
        }

        protected abstract boolean shouldAccept();

        @Override
        public boolean acceptsValue(String value) {
            return this.shouldAccept();
        }

        @Override
        public boolean accepts(XMLEvent event, List<XMLEvent> queue) {
            boolean accept = true;
            if (event.getEventType() == 1) {
                QName name = event.asStartElement().getName();
                ++this.level;
                if (this.level == 1) {
                    accept = true;
                } else if (this.level == 2) {
                    if (!RdfContainerNames.contains(name)) {
                        log.warn("Bad condition, expected XMP container but found: {}", (Object)name);
                        this.insideContainer = false;
                    } else {
                        this.insideContainer = true;
                    }
                    accept = true;
                } else if (this.level == 3) {
                    accept = true;
                    if (this.insideContainer && N_LI.equals(name)) {
                        ++this.itemCount;
                        if (!this.shouldAccept()) {
                            accept = false;
                            this.ignore = true;
                        }
                    } else if (this.insideContainer) {
                        log.warn("Bad XMP, expected Array Element but found: {}", (Object)name);
                    }
                }
                if (this.level > 3) {
                    accept = !this.ignore;
                }
            } else if (event.getEventType() == 2) {
                QName name = event.asEndElement().getName();
                if (this.level == 1) {
                    accept = true;
                } else if (this.level == 2) {
                    accept = true;
                } else if (this.level == 3) {
                    accept = !this.ignore;
                    this.ignore = false;
                }
                if (this.level > 3) {
                    accept = !this.ignore;
                }
                --this.level;
            } else if (this.ignore) {
                accept = false;
            }
            if (accept) {
                queue.add(event);
            }
            return accept;
        }
    }

    private static class OrCondition
    implements EventCondition {
        private final EventCondition cond1;
        private final EventCondition cond2;

        OrCondition(EventCondition cond1, EventCondition cond2) {
            this.cond1 = cond1;
            this.cond2 = cond2;
        }

        @Override
        public boolean acceptsValue(String value) {
            return this.cond1.acceptsValue(value) || this.cond2.acceptsValue(value);
        }

        @Override
        public boolean accepts(XMLEvent event, List<XMLEvent> queue) {
            return this.cond1.accepts(event, queue) || this.cond2.accepts(event, queue);
        }

        @Override
        public EventCondition newInstance(boolean exclude, XmpFilterMode mode) {
            return exclude ? new AndCondition(this.cond1.newInstance(true, mode), this.cond2.newInstance(true, mode)) : new OrCondition(this.cond1.newInstance(false, mode), this.cond2.newInstance(false, mode));
        }
    }

    private static class AndCondition
    implements EventCondition {
        private final EventCondition cond1;
        private final EventCondition cond2;

        AndCondition(EventCondition cond1, EventCondition cond2) {
            this.cond1 = cond1;
            this.cond2 = cond2;
        }

        @Override
        public boolean acceptsValue(String value) {
            return this.cond1.acceptsValue(value) && this.cond2.acceptsValue(value);
        }

        @Override
        public boolean accepts(XMLEvent event, List<XMLEvent> queue) {
            int n = queue.size();
            if (!this.cond1.accepts(event, queue)) {
                return false;
            }
            while (queue.size() > n) {
                queue.remove(queue.size() - 1);
            }
            return this.cond2.accepts(event, queue);
        }

        @Override
        public EventCondition newInstance(boolean inverse, XmpFilterMode mode) {
            return inverse ? new OrCondition(this.cond1.newInstance(true, mode), this.cond2.newInstance(true, mode)) : new AndCondition(this.cond1.newInstance(false, mode), this.cond2.newInstance(false, mode));
        }
    }

    private static class DenyCondition
    implements EventCondition {
        private DenyCondition() {
        }

        @Override
        public boolean accepts(XMLEvent event, List<XMLEvent> queue) {
            return false;
        }

        @Override
        public boolean acceptsValue(String value) {
            return false;
        }

        @Override
        public EventCondition newInstance(boolean exclude, XmpFilterMode mode) {
            return exclude ? ACCEPT : DENY;
        }
    }

    private static class AcceptCondition
    implements EventCondition {
        private AcceptCondition() {
        }

        @Override
        public boolean accepts(XMLEvent event, List<XMLEvent> queue) {
            queue.add(event);
            return true;
        }

        @Override
        public boolean acceptsValue(String value) {
            return true;
        }

        @Override
        public EventCondition newInstance(boolean exclude, XmpFilterMode mode) {
            return exclude ? DENY : ACCEPT;
        }
    }

    static interface EventCondition {
        public static final EventCondition ACCEPT = new AcceptCondition();
        public static final EventCondition DENY = new DenyCondition();

        public boolean acceptsValue(String var1);

        public boolean accepts(XMLEvent var1, List<XMLEvent> var2);

        public EventCondition newInstance(boolean var1, XmpFilterMode var2);
    }

    private static enum XmpFilterMode {
        FILTER,
        SIEVE;

    }

    private static class NameDef {
        private static final Pattern RE_LIMIT_MAX = Pattern.compile("(.*)\\[([><]?)(\\d+)\\]");
        String orig;
        String uri;
        String localName;
        String prefix;
        EventCondition condition;
        Object condToken;

        private NameDef() {
        }

        void init(String s) {
            int idx;
            this.orig = s;
            this.uri = null;
            this.localName = null;
            this.prefix = null;
            this.condition = null;
            this.condToken = null;
            if (s.charAt(0) == '{') {
                idx = s.lastIndexOf(125);
                if (idx <= 0) {
                    throw new IllegalArgumentException("'}' missing in allowlist name: " + s);
                }
                this.uri = s.substring(1, idx);
                this.localName = idx < s.length() - 1 ? s.substring(idx + 1) : "*";
            } else {
                idx = s.indexOf(58);
                String string = this.prefix = idx > 0 ? s.substring(0, idx) : "";
                String string2 = idx >= 0 ? (idx < s.length() - 1 ? s.substring(idx + 1) : "*") : (this.localName = s);
                if (this.localName.length() == 0) {
                    throw new IllegalArgumentException("'}' empty allowlist name: " + s);
                }
            }
            Matcher m = RE_LIMIT_MAX.matcher(this.localName);
            if (m.matches()) {
                try {
                    String op = m.group(2);
                    int n = Integer.parseInt(m.group(3));
                    this.localName = m.group(1);
                    if ("".equals(this.localName)) {
                        this.localName = "*";
                    }
                    EventCondition eventCondition = this.condition = "<".equals(op) ? new MinIndexCondition(n) : new MaxIndexCondition(n);
                    this.condToken = this.uri != null ? ("*".equals(this.localName) ? this.uri : new QName(this.uri, this.localName)) : this.prefix + ":" + this.localName;
                }
                catch (NumberFormatException ex) {
                    log.debug("error pasing max confition from {}", (Object)this.orig, (Object)ex);
                }
            }
            if ("*".equals(this.localName) && "".equals(this.prefix) && this.uri == null && this.orig.indexOf(58) < 0) {
                this.prefix = null;
                this.uri = "*";
                if (this.condition != null) {
                    this.condToken = this.uri;
                }
            }
        }
    }
}

