/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.polling.importer;

import aQute.bnd.annotation.ConsumerType;
import com.day.cq.polling.importer.ImportException;
import com.day.cq.polling.importer.Importer;
import java.io.IOException;
import java.io.InputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.ComponentContext;

@Component(metatype=false, componentAbstract=true)
@Service(value={Importer.class})
@Properties(value={@Property(name="service.description", value={"Abstract HTTP based Importer"})})
@ConsumerType
public abstract class HCImporter
implements Importer {
    private HttpClient httpClient;

    protected abstract void importData(String var1, InputStream var2, String var3, Resource var4) throws IOException;

    @Override
    public void importData(String scheme, String dataSource, Resource target) {
        this.importData(scheme, dataSource, target, null, null);
    }

    @Override
    public void importData(String scheme, String dataSource, Resource target, String login, String password) {
        HttpRequestBase method = this.newHttpMethod(dataSource);
        InputStream ins = null;
        try {
            HttpResponse httpResp;
            if (login != null && login.length() > 0 && password != null && password.length() > 0) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(login, password);
                credsProvider.setCredentials(AuthScope.ANY, defaultcreds);
                this.httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider(credsProvider).build();
            }
            if ((httpResp = this.getHttpClient().execute(method)) != null) {
                int statusCode = httpResp.getStatusLine().getStatusCode();
                switch (statusCode) {
                    case 200: {
                        break;
                    }
                    case 304: {
                        return;
                    }
                    default: {
                        throw new ImportException("Failed retreiving data" + httpResp.getStatusLine());
                    }
                }
            }
            if (httpResp.getEntity() != null) {
                ins = httpResp.getEntity().getContent();
            }
            String charset = null;
            if (null != ContentType.getOrDefault(httpResp.getEntity()).getCharset()) {
                charset = ContentType.getOrDefault(httpResp.getEntity()).getCharset().toString();
            }
            this.importData(scheme, ins, charset, target);
        }
        catch (IOException e) {
            throw new ImportException("Fatal transport error", e);
        }
        catch (IllegalStateException ise) {
            throw new ImportException("HttpImporter has not been initialized yet", ise);
        }
        catch (Exception e) {
            throw new ImportException("Unexpected problem while importing data", e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
            method.releaseConnection();
        }
    }

    protected final HttpClient getHttpClient() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        if (this.httpClient == null) {
            this.httpClient = HttpClients.custom().setConnectionManager(cm).build();
        }
        return this.httpClient;
    }

    protected HttpRequestBase newHttpMethod(String source) {
        return new HttpGet(source);
    }

    protected final void init() {
    }

    protected final void destroy() {
        if (this.httpClient != null) {
            HttpClientUtils.closeQuietly(this.httpClient);
        }
        this.httpClient = null;
    }

    protected void activate(ComponentContext context) {
        this.init();
    }

    protected void deactivate(ComponentContext context) {
        this.destroy();
    }
}

