/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resource.collection.ResourceCollection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceVendor(value="Adobe Systems Incorporated")
@Component(factory="com.day.cq.search.eval.PredicateEvaluator/memberOf")
public class CollectionPredicateEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionPredicateEvaluator.class);
    public static final String COLLECTION = "memberOf";
    private static final String COLLECTION_PATH_SET_KEY = "collectionPathSet";
    private static final String COLLECTION_ID_SET_KEY = "collectionIdSet";
    private static final String COLLECTION_ID_SET_FAILED_KEY = "collectionIdSetFailed";
    private static final String COLLECTION_FOLDER_SET_KEY = "collectionFolderSet";
    static final String TOGGLE_USE_QUERY = "CT_ASSETS-32899";
    @Reference
    private ToggleRouter toggleRouter;

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        if (!p.hasNonEmptyValue(COLLECTION)) {
            return true;
        }
        Set collectionPathSet = (Set)context.get(COLLECTION_PATH_SET_KEY);
        Set<String> collectionFolderSet = (Set<String>)context.get(COLLECTION_FOLDER_SET_KEY);
        if (collectionPathSet == null) {
            collectionPathSet = Collections.emptySet();
            collectionFolderSet = Collections.emptySet();
            ResourceCollection collection = this.getCollection(p, context);
            if (collection != null) {
                Iterator<Resource> collectionItr = collection.getResources();
                collectionPathSet = new HashSet();
                collectionFolderSet = new HashSet<String>();
                while (collectionItr.hasNext()) {
                    Resource collectionMember = collectionItr.next();
                    collectionPathSet.add(collectionMember.getPath());
                    if (!this.isFolder(collectionMember)) continue;
                    collectionFolderSet.add(collectionMember.getPath() + "/");
                }
            }
            context.put(COLLECTION_PATH_SET_KEY, collectionPathSet);
            context.put(COLLECTION_FOLDER_SET_KEY, collectionFolderSet);
        }
        return collectionPathSet.contains(context.getPath(row)) || this.isFolderMember(collectionFolderSet, context.getPath(row));
    }

    @Override
    public String getXPathExpression(Predicate predicate, EvaluationContext context) {
        if (!this.canXpath(predicate, context)) {
            return null;
        }
        StringBuffer answer = new StringBuffer("(");
        Set<String> itemIds = this.getCollectionItemIds(this.getCollection(predicate, context), context);
        if (itemIds.isEmpty()) {
            answer.append("false");
        } else {
            Iterator<String> idIter = itemIds.iterator();
            while (idIter.hasNext()) {
                answer.append("jcr:uuid").append("='").append(idIter.next()).append("'");
                if (!idIter.hasNext()) continue;
                answer.append(" or ");
            }
        }
        answer.append(")");
        LOG.debug("getXPathExpression: returning expression '{}'", (Object)answer.toString());
        return answer.toString();
    }

    private ResourceCollection getCollection(Predicate p, EvaluationContext context) {
        Resource colRes = context.getResourceResolver().getResource(p.get(COLLECTION));
        if (colRes != null) {
            return colRes.adaptTo(ResourceCollection.class);
        }
        return null;
    }

    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        ResourceCollection collection;
        boolean answer = false;
        if (this.useIndexedQuery() && (collection = this.getCollection(predicate, context)) != null) {
            Set<String> itemIds = this.getCollectionItemIds(collection, context);
            answer = itemIds != null;
        }
        LOG.trace("canXpath: returning {}", (Object)answer);
        return answer;
    }

    private Set<String> getCollectionItemIds(ResourceCollection collection, EvaluationContext context) {
        HashSet<String> itemIds = (HashSet<String>)context.get(COLLECTION_ID_SET_KEY);
        if (itemIds != null) {
            return itemIds;
        }
        if (context.get(COLLECTION_ID_SET_FAILED_KEY) != null) {
            return null;
        }
        itemIds = new HashSet<String>();
        Iterator<Resource> collectionItr = collection.getResources();
        LOG.debug("getCollectionItemIds: reading item ids for collection '{}' ({})", (Object)collection.getName(), (Object)collection.getPath());
        if (this.readItemIds(collectionItr, itemIds, context)) {
            context.put(COLLECTION_ID_SET_KEY, itemIds);
            LOG.debug("getCollectionItemIds: identified {} item ids for collection", (Object)itemIds.size());
            return itemIds;
        }
        context.put(COLLECTION_ID_SET_FAILED_KEY, Boolean.TRUE);
        return null;
    }

    private boolean readItemIds(Iterator<Resource> items, Set<String> itemIds, EvaluationContext context) {
        try {
            while (items.hasNext()) {
                if (itemIds.size() > 1000) {
                    LOG.warn("readItemIds: Collection has >1000 members - unable to include in query");
                    return false;
                }
                Resource itemResource = items.next();
                if (itemResource.isResourceType("dam:Asset")) {
                    String uuid = this.getUUID(itemResource);
                    if (uuid != null) {
                        itemIds.add(uuid);
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("readItemIds: Seen asset member without uuid at '{}'", (Object)itemResource.getPath());
                    }
                    LOG.warn("readItemIds: Collection contains asset member without uuid - unable to include in query");
                    return false;
                }
                Iterator<Resource> nestedItems = null;
                ResourceCollection nestedCollection = itemResource.adaptTo(ResourceCollection.class);
                if (nestedCollection != null) {
                    nestedItems = nestedCollection.getResources();
                } else if (this.isFolder(itemResource)) {
                    nestedItems = itemResource.listChildren();
                }
                if (nestedItems == null || this.readItemIds(nestedItems, itemIds, context)) continue;
                return false;
            }
        }
        catch (Exception e) {
            LOG.warn("readItemIds: unable to read item ids - " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }

    private boolean isFolder(Resource resource) {
        if ("jcr:content".equals(resource.getName())) {
            return false;
        }
        Node n = resource.adaptTo(Node.class);
        try {
            return n.isNodeType("nt:folder");
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private boolean isFolderMember(Set<String> collectionFolderSet, String path) {
        for (String folderPath : collectionFolderSet) {
            if (path.indexOf(folderPath) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean useIndexedQuery() {
        return this.toggleRouter != null && this.toggleRouter.isEnabled(TOGGLE_USE_QUERY);
    }

    private String getUUID(Resource assetResource) {
        ValueMap vm = assetResource.adaptTo(ValueMap.class);
        if (vm.containsKey("jcr:uuid")) {
            return (String)((Object)vm.get("jcr:uuid", String.class));
        }
        return null;
    }
}

