/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers.factory;

import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerFactory;
import com.day.cq.wcm.designimporter.parser.taghandlers.TextComponentTagHandler;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;

@Service
@Component(metatype=true)
@Properties(value={@Property(name="service.ranking", intValue={5000}, propertyPrivate=false), @Property(name="tagpattern", value={"<(p|span|div)\\s+.*data-cq-component=\"(?i)text\".*?>"}), @Property(name="component.resourceType", value={"foundation/components/text"})})
public class TextComponentTagHandlerFactory
implements TagHandlerFactory {
    protected static final String RESOURCE_TYPE_TEXT = "foundation/components/text";
    @Deprecated
    @Reference
    Externalizer externalizer;
    public static final String TAG_PATTERN = "<(p|span|div)\\s+.*data-cq-component=\"(?i)text\".*?>";
    private String resourceType;

    @Override
    public TagHandler create() {
        TextComponentTagHandler textComponentTagHandler = new TextComponentTagHandler();
        textComponentTagHandler.setResourceType(this.resourceType);
        return textComponentTagHandler;
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.resourceType = OsgiUtil.toString(context.getProperties().get("component.resourceType"), RESOURCE_TYPE_TEXT);
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }
}

