/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.exec.util.DebugUtils;

public class StreamPumper
implements Runnable {
    private static final int DEFAULT_SIZE = 1024;
    private final InputStream is;
    private final OutputStream os;
    private final int size;
    private boolean finished;
    private final boolean closeWhenExhausted;

    public StreamPumper(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        this.is = is;
        this.os = os;
        this.size = 1024;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted, int size) {
        this.is = is;
        this.os = os;
        this.size = size > 0 ? size : 1024;
        this.closeWhenExhausted = closeWhenExhausted;
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.finished = false;
        }
        byte[] buf = new byte[this.size];
        try {
            int length;
            while ((length = this.is.read(buf)) > 0) {
                this.os.write(buf, 0, length);
            }
        }
        catch (Exception e) {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e2) {
                    String msg = "Got exception while closing exhausted output stream";
                    DebugUtils.handleException((String)"Got exception while closing exhausted output stream", (Exception)e2);
                }
            }
            StreamPumper streamPumper2 = this;
            synchronized (streamPumper2) {
                this.finished = true;
                this.notifyAll();
            }
        }
        finally {
            if (this.closeWhenExhausted) {
                try {
                    this.os.close();
                }
                catch (IOException e) {
                    String msg = "Got exception while closing exhausted output stream";
                    DebugUtils.handleException((String)"Got exception while closing exhausted output stream", (Exception)e);
                }
            }
            StreamPumper e = this;
            synchronized (e) {
                this.finished = true;
                this.notifyAll();
            }
        }
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }
}

