/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.DefaultBrandingPlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.NavigationRenderer;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.servlet.RequestVariableResolver;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Deprecated
public abstract class AbstractWebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String ATTR_FILEUPLOAD = "org.apache.felix.webconsole.fileupload";
    @Deprecated
    public static final String ATTR_FILEUPLOAD_REPO = "org.apache.felix.webconsole.fileupload.repo";
    public static final String GET_RESOURCE_METHOD_NAME = "getResource";
    private Method getResourceMethod;
    private boolean getResourceMethodChecked;
    private BundleContext bundleContext;
    private static volatile BrandingPlugin BRANDING_PLUGIN = DefaultBrandingPlugin.getInstance();

    @Override
    public String getServletName() {
        return this.getTitle();
    }

    public String getCategory() {
        return null;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.spoolResource(request, response)) {
            if (this.isHtmlRequest(request)) {
                PrintWriter pw = this.startResponse(request, response);
                this.renderTopNavigation(request, pw);
                pw.println("<div id='content'>");
                this.renderContent(request, response);
                pw.println("</div>");
                this.endResponse(pw);
            } else {
                this.renderContent(request, response);
            }
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        return true;
    }

    public void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void deactivate() {
        this.bundleContext = null;
    }

    protected abstract void renderContent(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    public abstract String getLabel();

    public abstract String getTitle();

    protected String[] getCssReferences() {
        return null;
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public final Bundle getBundle() {
        BundleContext bundleContext = this.getBundleContext();
        return bundleContext != null ? bundleContext.getBundle() : null;
    }

    protected Object getResourceProvider() {
        return this;
    }

    private final Method getGetResourceMethod() {
        if (this.getResourceMethodChecked) {
            return this.getResourceMethod;
        }
        Method tmpGetResourceMethod = null;
        Object resourceProvider = this.getResourceProvider();
        if (resourceProvider != null) {
            try {
                block2: for (Class<?> cl = resourceProvider.getClass(); tmpGetResourceMethod == null && cl != Object.class; cl = cl.getSuperclass()) {
                    Method[] methods = cl.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        int mod;
                        Method m = methods[i];
                        if (!GET_RESOURCE_METHOD_NAME.equals(m.getName()) || m.getParameterTypes().length != 1 || m.getParameterTypes()[0] != String.class || m.getReturnType() != URL.class || !Modifier.isProtected(mod = m.getModifiers()) && !Modifier.isPublic(mod) && (!Modifier.isPrivate(mod) || cl != resourceProvider.getClass())) continue;
                        m.setAccessible(true);
                        tmpGetResourceMethod = m;
                        continue block2;
                    }
                }
            }
            catch (Throwable t) {
                tmpGetResourceMethod = null;
            }
        }
        this.getResourceMethod = tmpGetResourceMethod;
        this.getResourceMethodChecked = true;
        return this.getResourceMethod;
    }

    public void log(int level, String message) {
        this.log(level, message, null);
    }

    public void log(int level, String message, Throwable t) {
        String text = "[".concat(this.getTitle()).concat("] ").concat(message);
        switch (level) {
            case 4: {
                Util.LOGGER.debug(text, t);
                break;
            }
            case 3: {
                Util.LOGGER.info(text, t);
                break;
            }
            case 2: {
                Util.LOGGER.warn(text, t);
                break;
            }
            case 1: {
                Util.LOGGER.error(text, t);
                break;
            }
            default: {
                Util.LOGGER.debug(message, t);
            }
        }
    }

    private final boolean spoolResource(final HttpServletRequest request, final HttpServletResponse response) throws IOException {
        try {
            Boolean ret = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    return AbstractWebConsolePlugin.this.spoolResource0(request, response) ? Boolean.TRUE : Boolean.FALSE;
                }
            });
            return ret;
        }
        catch (PrivilegedActionException e) {
            Exception x = e.getException();
            throw x instanceof IOException ? (IOException)x : new IOException(x.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean spoolResource0(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Method getResourceMethod = this.getGetResourceMethod();
        if (getResourceMethod == null) {
            return false;
        }
        String pi = request.getPathInfo();
        try {
            URL url = (URL)getResourceMethod.invoke(this.getResourceProvider(), pi);
            if (url == null) {
                return false;
            }
            URLConnection connection = url.openConnection();
            try (InputStream ins = connection.getInputStream();){
                int rd;
                String contentType;
                if (ins == null) {
                    boolean bl = false;
                    return bl;
                }
                long lastModified = connection.getLastModified();
                if (lastModified > 0L) {
                    long ifModifiedSince = request.getDateHeader("If-Modified-Since");
                    if (ifModifiedSince >= lastModified / 1000L * 1000L) {
                        response.setStatus(304);
                        boolean bl = true;
                        return bl;
                    }
                    response.setDateHeader("Last-Modified", lastModified);
                }
                if ((contentType = this.getServletContext().getMimeType(pi)) != null) {
                    response.setContentType(contentType);
                }
                if (connection.getContentLength() != -1) {
                    response.setContentLength(connection.getContentLength());
                }
                ServletOutputStream out = response.getOutputStream();
                byte[] buf = new byte[2048];
                while ((rd = ins.read(buf)) >= 0) {
                    out.write(buf, 0, rd);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    protected PrintWriter startResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Object title = this.getTitle();
        if (((String)title).startsWith("%")) {
            title = "${" + ((String)title).substring(1) + "}";
        }
        RequestVariableResolver r = this.getVariableResolver(request);
        r.put((Object)"head.title", title);
        r.put((Object)"head.label", (Object)this.getLabel());
        r.put((Object)"head.cssLinks", (Object)this.getCssLinks(appRoot));
        r.put((Object)"brand.name", (Object)BRANDING_PLUGIN.getBrandName());
        r.put((Object)"brand.product.url", (Object)BRANDING_PLUGIN.getProductURL());
        r.put((Object)"brand.product.name", (Object)BRANDING_PLUGIN.getProductName());
        r.put((Object)"brand.product.img", (Object)AbstractWebConsolePlugin.toUrl(BRANDING_PLUGIN.getProductImage(), appRoot));
        r.put((Object)"brand.favicon", (Object)AbstractWebConsolePlugin.toUrl(BRANDING_PLUGIN.getFavIcon(), appRoot));
        r.put((Object)"brand.css", (Object)AbstractWebConsolePlugin.toUrl(BRANDING_PLUGIN.getMainStyleSheet(), appRoot));
        pw.println(NavigationRenderer.HEADER);
        return pw;
    }

    protected void renderTopNavigation(HttpServletRequest request, PrintWriter pw) {
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Map menuMap = (Map)request.getAttribute("felix.webconsole.labelMap.categorized");
        Map langMap = (Map)request.getAttribute("felix.webconsole.langMap");
        NavigationRenderer.renderTopNavigation((PrintWriter)pw, (String)appRoot, (Map)menuMap, (Map)langMap, (Locale)request.getLocale());
    }

    protected void renderMenu(Map menuMap, String appRoot, PrintWriter pw) {
        throw new UnsupportedOperationException();
    }

    protected void endResponse(PrintWriter pw) {
        pw.println(NavigationRenderer.FOOTER);
    }

    @Deprecated
    public static final String getParameter(HttpServletRequest request, String name) {
        return WebConsoleUtil.getParameter(request, name);
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String redirectUrl) throws IOException {
        WebConsoleUtil.sendRedirect(request, response, redirectUrl);
    }

    @Deprecated
    public static BrandingPlugin getBrandingPlugin() {
        return BRANDING_PLUGIN;
    }

    @Deprecated
    public static final void setBrandingPlugin(BrandingPlugin brandingPlugin) {
        BRANDING_PLUGIN = brandingPlugin == null ? DefaultBrandingPlugin.getInstance() : brandingPlugin;
    }

    public static final void setLogLevel(int logLevel) {
    }

    protected final String readTemplateFile(String templateFile) {
        try {
            return Util.readTemplateFile(this.getClass(), (String)templateFile);
        }
        catch (IOException e) {
            Util.LOGGER.error("readTemplateFile: File '{}' not found through class {}", (Object)templateFile, (Object)this.getClass());
            return "";
        }
    }

    private final String getCssLinks(String appRoot) {
        String[] cssRefs = this.getCssReferences();
        if (cssRefs == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < cssRefs.length; ++i) {
            buf.append("<link href='");
            buf.append(AbstractWebConsolePlugin.toUrl(cssRefs[i], appRoot));
            buf.append("' rel='stylesheet' type='text/css' />");
        }
        return buf.toString();
    }

    private static final String toUrl(String url, String appRoot) {
        if (url.startsWith("/")) {
            return appRoot + url;
        }
        return url;
    }

    public RequestVariableResolver getVariableResolver(ServletRequest request) {
        return (RequestVariableResolver)request.getAttribute("felix.webconsole.variable.resolver");
    }
}

