/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsonObject;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNodeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JsonNodeBuilder.class);

    public static void addOrReplace(NodeStore nodeStore, String targetPath, String nodeType, String jsonString) throws CommitFailedException, IOException {
        NodeBuilder root;
        LOG.info("Storing {}: {}", (Object)targetPath, (Object)jsonString);
        JsonObject json = JsonObject.fromJson(jsonString, true);
        NodeBuilder builder = root = nodeStore.getRoot().builder();
        for (String name : PathUtils.elements(targetPath)) {
            NodeBuilder child = builder.child(name);
            if (!child.hasProperty("jcr:primaryType")) {
                if (nodeType.indexOf("/") >= 0) {
                    throw new IllegalStateException("Illegal node type: " + nodeType);
                }
                child.setProperty("jcr:primaryType", nodeType, Type.NAME);
            }
            builder = child;
        }
        JsonNodeBuilder.storeConfigNode(nodeStore, builder, nodeType, json);
        nodeStore.merge(root, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    private static void storeConfigNode(NodeStore nodeStore, NodeBuilder builder, String nodeType, JsonObject json) throws IOException {
        Object v;
        String k;
        for (Map.Entry<String, JsonObject> entry : json.getChildren().entrySet()) {
            k = entry.getKey();
            v = entry.getValue();
            JsonNodeBuilder.storeConfigNode(nodeStore, builder.child(k), nodeType, (JsonObject)v);
        }
        for (String string : builder.getChildNodeNames()) {
            if (json.getChildren().containsKey(string)) continue;
            builder.child(string).remove();
        }
        for (Map.Entry entry : json.getProperties().entrySet()) {
            k = (String)entry.getKey();
            v = (String)entry.getValue();
            JsonNodeBuilder.storeConfigProperty(nodeStore, builder, k, (String)v);
        }
        if (!json.getProperties().containsKey("jcr:primaryType")) {
            builder.setProperty("jcr:primaryType", nodeType, Type.NAME);
        }
        for (PropertyState propertyState : builder.getProperties()) {
            if ("jcr:primaryType".equals(propertyState.getName()) || json.getProperties().containsKey(propertyState.getName())) continue;
            builder.removeProperty(propertyState.getName());
        }
        if ("nt:resource".equals(JsonNodeBuilder.oakStringValue(json, "jcr:primaryType")) && !json.getProperties().containsKey("jcr:uuid")) {
            String uuid = UUID.randomUUID().toString();
            builder.setProperty("jcr:uuid", uuid);
        }
    }

    private static void storeConfigProperty(NodeStore nodeStore, NodeBuilder builder, String propertyName, String value) throws IOException {
        if (value.startsWith("\"")) {
            if ((value = JsopTokenizer.decodeQuoted(value)).startsWith(":blobId:")) {
                String base64 = value.substring(":blobId:".length());
                byte[] bytes = Base64.getDecoder().decode(base64.getBytes(StandardCharsets.UTF_8));
                Blob blob = nodeStore.createBlob(new ByteArrayInputStream(bytes));
                builder.setProperty(propertyName, blob);
            } else if ("jcr:primaryType".equals(propertyName)) {
                builder.setProperty(propertyName, value, Type.NAME);
            } else {
                builder.setProperty(propertyName, value);
            }
        } else {
            if (value.equals("null")) {
                throw new IllegalArgumentException("Removing entries is not supported");
            }
            if (value.equals("true")) {
                builder.setProperty(propertyName, true);
            } else if (value.equals("false")) {
                builder.setProperty(propertyName, false);
            } else if (value.startsWith("[")) {
                JsopTokenizer tokenizer = new JsopTokenizer(value);
                ArrayList<String> result = new ArrayList<String>();
                tokenizer.matches(91);
                if (!tokenizer.matches(93)) {
                    do {
                        if (!tokenizer.matches(1)) {
                            throw new IllegalArgumentException("Could not process string array " + value);
                        }
                        result.add(tokenizer.getEscapedToken());
                    } while (tokenizer.matches(44));
                    tokenizer.read(93);
                }
                tokenizer.read(0);
                builder.setProperty(propertyName, result, Type.STRINGS);
            } else if (value.indexOf(46) >= 0 || value.toLowerCase().indexOf("e") >= 0) {
                try {
                    Double d = Double.parseDouble(value);
                    builder.setProperty(propertyName, d);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse double " + value);
                }
            } else if (value.startsWith("-") || !value.isEmpty() && Character.isDigit(value.charAt(0))) {
                try {
                    Long x = Long.parseLong(value);
                    builder.setProperty(propertyName, x);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse long " + value);
                }
            } else {
                throw new IllegalArgumentException("Unsupported value " + value);
            }
        }
    }

    static String oakStringValue(JsonObject json, String propertyName) {
        String value = json.getProperties().get(propertyName);
        if (value == null) {
            return null;
        }
        return JsonNodeBuilder.oakStringValue(value);
    }

    static String oakStringValue(String value) {
        if (!value.startsWith("\"")) {
            return value;
        }
        if ((value = JsopTokenizer.decodeQuoted(value)).startsWith(":blobId:")) {
            value = value.substring(":blobId:".length());
            value = new String(Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        } else if (value.startsWith("str:") || value.startsWith("nam:") || value.startsWith("dat:")) {
            value = value.substring("str:".length());
        }
        return value;
    }
}

