/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.document.spi.JournalPropertyService;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.plugins.index.fulltext.PreExtractedTextProvider;
import org.apache.jackrabbit.oak.plugins.index.importer.IndexImporterProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.ActiveDeletedBlobCollectorMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.ActiveDeletedBlobCollectorMBeanImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.AsyncIndexesSizeStatsUpdate;
import org.apache.jackrabbit.oak.plugins.index.lucene.AsyncIndexesSizeStatsUpdateImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.CopyOnReadStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LoggingInfoStream;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexInfoProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBeanImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakCodec;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.ActiveDeletedBlobCollectorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.BufferedOakDirectory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LuceneIndexFileSystemStatistics;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.LuceneIndexImporter;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.DocumentQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.ExternalObserverBuilder;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexingQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LocalIndexObserver;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneJournalPropertyService;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndexFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.property.PropertyIndexCleaner;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.DefaultIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.search.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.TextExtractionStatsMBean;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Configuration.class)
public class LuceneIndexProviderService {
    private static final boolean PROP_DISABLED_DEFAULT = false;
    private static final boolean PROP_DEBUG_DEFAULT = false;
    private static final boolean PROP_OPEN_INDEX_ASYNC_DEFAULT = true;
    private static final int PROP_THREAD_POOL_SIZE_DEFAULT = 5;
    private static final boolean PROP_PREFETCH_INDEX_FILES_DEFAULT = true;
    private static final int PROP_EXTRACTED_TEXT_CACHE_EXPIRY_IN_SECS_DEFAULT = 300;
    private static final int PROP_EXTRACTED_TEXT_CACHE_SIZE_IN_MB_DEFAULT = 20;
    private static final boolean PROP_ALWAYS_USE_PRE_EXTRACTED_TEXT_DEFAULT = false;
    private static final int PROP_BOOLEAN_CLAUSE_LIMIT_DEFAULT = 1024;
    private static final boolean PROP_ENABLE_HYBRID_INDEXING_DEFAULT = true;
    private static final int PROP_HYBRID_QUEUE_SIZE_DEFAULT = 10000;
    public static final long PROP_HYBRID_QUEUE_TIMEOUT_DEFAULT = 100L;
    private static final boolean PROP_DISABLE_STORED_INDEX_DEFINITION_DEFAULT = false;
    private static final boolean PROP_DELETED_BLOBS_COLLECTION_ENABLED_DEFAULT = true;
    private static final int PROP_LUCENE_INDEX_STATS_UPDATE_INTERVAL_DEFAULT = 300;
    private static final int PROP_INDEX_CLEANER_INTERVAL_IN_SECS_DEFAULT = 600;
    private static final boolean PROP_ENABLE_SINGLE_BLOB_INDEX_FILES_DEFAULT = true;
    private static final long PROP_INDEX_FS_STATS_INTERVAL_IN_SECS_DEFAULT = 300L;
    public static final String REPOSITORY_HOME = "repository.home";
    private LuceneIndexProvider indexProvider;
    private final List<ServiceRegistration> regs = new ArrayList<ServiceRegistration>();
    private final List<Registration> oakRegs = new ArrayList<Registration>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC, bind="bindNodeAggregator", unbind="unbindNodeAggregator")
    private volatile QueryIndex.NodeAggregator nodeAggregator;
    private final Clock clock = Clock.SIMPLE;
    private Whiteboard whiteboard;
    private BackgroundObserver backgroundObserver;
    private BackgroundObserver externalIndexObserver;
    @Reference
    private IndexAugmentorFactory augmentorFactory;
    @Reference
    private StatisticsProvider statisticsProvider;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    private volatile PreExtractedTextProvider extractedTextProvider;
    @Reference
    private MountInfoProvider mountInfoProvider;
    @Reference
    private NodeStore nodeStore;
    @Reference
    private IndexPathService indexPathService;
    @Reference
    private AsyncIndexInfoService asyncIndexInfoService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private GarbageCollectableBlobStore blobStore;
    @Reference
    private CheckpointMBean checkpointMBean;
    private IndexCopier indexCopier;
    private ActiveDeletedBlobCollectorFactory.ActiveDeletedBlobCollector activeDeletedBlobCollector;
    private File indexDir;
    private ExecutorService executorService;
    private int threadPoolSize;
    private ExtractedTextCache extractedTextCache;
    private boolean hybridIndex;
    private NRTIndexFactory nrtIndexFactory;
    private DocumentQueue documentQueue;
    private LuceneIndexEditorProvider editorProvider;
    private IndexTracker tracker;
    private PropertyIndexCleaner cleaner;
    private AsyncIndexesSizeStatsUpdate asyncIndexesSizeStatsUpdate;

    @Activate
    private void activate(BundleContext bundleContext, Configuration config) throws IOException {
        this.asyncIndexesSizeStatsUpdate = new AsyncIndexesSizeStatsUpdateImpl((long)config.luceneIndexStatsUpdateInterval() * 1000L);
        boolean disabled = config.disabled();
        this.hybridIndex = config.enableHybridIndexing();
        if (disabled) {
            this.log.info("Component disabled by configuration");
            return;
        }
        this.configureIndexDefinitionStorage(config);
        this.configureBooleanClauseLimit(config);
        this.initializeFactoryClassLoaders(this.getClass().getClassLoader());
        if (System.getProperty("oak.lucene.enableSingleBlobIndexFiles") == null) {
            BufferedOakDirectory.setEnableWritingSingleBlobIndexFile((boolean)config.enableSingleBlobIndexFiles());
        } else {
            this.log.info("Not setting config for single blob for an index file as it's set by command line!");
        }
        this.whiteboard = new OsgiWhiteboard(bundleContext);
        this.threadPoolSize = config.threadPoolSize();
        this.initializeIndexDir(bundleContext, config);
        this.initializeExtractedTextCache(bundleContext, config, this.statisticsProvider);
        this.tracker = this.createTracker(bundleContext, config);
        this.indexProvider = new LuceneIndexProvider(this.tracker, this.augmentorFactory);
        this.initializeActiveBlobCollector(this.whiteboard, config);
        this.initializeLogging(config);
        this.initialize();
        this.regs.add(bundleContext.registerService(QueryIndexProvider.class.getName(), (Object)this.indexProvider, null));
        this.registerObserver(bundleContext, config);
        this.registerLocalIndexObserver(bundleContext, this.tracker, config);
        this.registerIndexInfoProvider(bundleContext);
        this.registerIndexImporterProvider(bundleContext);
        this.registerPropertyIndexCleaner(config, bundleContext);
        LuceneIndexMBeanImpl mBean = new LuceneIndexMBeanImpl(this.tracker, this.nodeStore, this.indexPathService, this.getIndexCheckDir(), this.cleaner);
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, LuceneIndexMBean.class, mBean, "LuceneIndex", "Lucene Index statistics"));
        this.registerGCMonitor(this.whiteboard, this.tracker);
        this.registerIndexEditor(bundleContext, this.tracker, mBean, config);
        LuceneIndexFileSystemStatistics luceneIndexFSStats = new LuceneIndexFileSystemStatistics(this.statisticsProvider, this.indexCopier);
        this.registerLuceneFileSystemStats(luceneIndexFSStats, config.propIndexFSStatsIntervalInSecs());
    }

    private File getIndexCheckDir() {
        return new File(Objects.requireNonNull(this.indexDir), "indexCheckDir");
    }

    @Deactivate
    private void deactivate() throws InterruptedException, IOException {
        for (ServiceRegistration serviceRegistration : this.regs) {
            serviceRegistration.unregister();
        }
        for (Registration registration : this.oakRegs) {
            registration.unregister();
        }
        if (this.backgroundObserver != null) {
            this.backgroundObserver.close();
        }
        if (this.externalIndexObserver != null) {
            this.externalIndexObserver.close();
        }
        if (this.indexProvider != null) {
            this.indexProvider.close();
            this.indexProvider = null;
        }
        if (this.documentQueue != null) {
            this.documentQueue.close();
        }
        if (this.nrtIndexFactory != null) {
            this.nrtIndexFactory.close();
        }
        if (this.indexCopier != null) {
            this.indexCopier.close();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        if (this.extractedTextCache != null) {
            this.extractedTextCache.close();
        }
        InfoStream.setDefault(InfoStream.NO_OUTPUT);
    }

    void initializeIndexDir(BundleContext bundleContext, Configuration config) {
        String repoHome;
        String indexDirPath = config.localIndexDir();
        if (StringUtils.isEmpty(indexDirPath) && (repoHome = bundleContext.getProperty(REPOSITORY_HOME)) != null) {
            indexDirPath = FilenameUtils.concat(repoHome, "index");
        }
        Objects.requireNonNull(indexDirPath, String.format("Index directory cannot be determined as neither index directory path [%s] nor repository home [%s] defined", "localIndexDir", REPOSITORY_HOME));
        this.indexDir = new File(indexDirPath);
    }

    IndexCopier getIndexCopier() {
        return this.indexCopier;
    }

    ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }

    private void initialize() {
        if (this.indexProvider == null) {
            return;
        }
        if (this.nodeAggregator != null) {
            this.log.debug("Using NodeAggregator {}", (Object)this.nodeAggregator.getClass());
        }
        this.indexProvider.setAggregator(this.nodeAggregator);
    }

    private void initializeLogging(Configuration config) {
        boolean debug = config.debug();
        if (debug) {
            InfoStream.setDefault(LoggingInfoStream.INSTANCE);
            this.log.info("Registered LoggingInfoStream with Lucene. Lucene logs can be enabled now via category [{}]", (Object)"oak.lucene");
        }
    }

    private void registerIndexEditor(BundleContext bundleContext, IndexTracker tracker, LuceneIndexMBean mBean, Configuration config) throws IOException {
        if (config.enableCopyOnWriteSupport()) {
            this.initializeIndexCopier(bundleContext, config);
            this.editorProvider = new LuceneIndexEditorProvider(this.indexCopier, tracker, this.extractedTextCache, this.augmentorFactory, this.mountInfoProvider, this.activeDeletedBlobCollector, mBean, this.statisticsProvider);
            this.log.info("Enabling CopyOnWrite support. Index files would be copied under {}", (Object)this.indexDir.getAbsolutePath());
        } else {
            this.editorProvider = new LuceneIndexEditorProvider(null, tracker, this.extractedTextCache, this.augmentorFactory, this.mountInfoProvider, this.activeDeletedBlobCollector, mBean, this.statisticsProvider);
        }
        this.editorProvider.setBlobStore(this.blobStore);
        this.editorProvider.withAsyncIndexesSizeStatsUpdate(this.asyncIndexesSizeStatsUpdate);
        if (this.hybridIndex) {
            this.editorProvider.setIndexingQueue((IndexingQueue)Objects.requireNonNull(this.documentQueue));
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("type", "lucene");
        this.regs.add(bundleContext.registerService(IndexEditorProvider.class.getName(), (Object)this.editorProvider, props));
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, TextExtractionStatsMBean.class, this.editorProvider.getExtractedTextCache().getStatsMBean(), "TextExtractionStats", "TextExtraction statistics"));
    }

    private IndexTracker createTracker(BundleContext bundleContext, Configuration config) throws IOException {
        IndexTracker tracker;
        if (config.enableCopyOnReadSupport()) {
            this.initializeIndexCopier(bundleContext, config);
            this.log.info("Enabling CopyOnRead support. Index files would be copied under {}", (Object)this.indexDir.getAbsolutePath());
            if (this.hybridIndex) {
                this.nrtIndexFactory = new NRTIndexFactory(this.indexCopier, this.statisticsProvider);
            }
            tracker = new IndexTracker((LuceneIndexReaderFactory)new DefaultIndexReaderFactory(this.mountInfoProvider, this.indexCopier), this.nrtIndexFactory);
        } else {
            tracker = new IndexTracker((LuceneIndexReaderFactory)new DefaultIndexReaderFactory(this.mountInfoProvider, null));
        }
        tracker.setAsyncIndexInfoService(this.asyncIndexInfoService);
        return tracker;
    }

    private void initializeIndexCopier(BundleContext bundleContext, Configuration config) throws IOException {
        if (this.indexCopier != null) {
            return;
        }
        boolean prefetchEnabled = config.prefetchIndexFiles();
        if (prefetchEnabled) {
            this.log.info("Prefetching of index files enabled. Index would be opened after copying all new files locally");
        }
        this.indexCopier = new IndexCopier(this.getExecutorService(), this.indexDir, prefetchEnabled);
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, CopyOnReadStatsMBean.class, this.indexCopier, "IndexCopierStats", "IndexCopier support statistics"));
    }

    ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = this.createExecutor();
        }
        return this.executorService;
    }

    private ExecutorService createExecutor() {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(5, 5, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();
            private final Thread.UncaughtExceptionHandler handler = (t, e) -> LuceneIndexProviderService.this.log.warn("Error occurred in asynchronous processing ", e);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = new Thread(r, this.createName());
                thread.setDaemon(true);
                thread.setPriority(1);
                thread.setUncaughtExceptionHandler(this.handler);
                return thread;
            }

            private String createName() {
                return "oak-lucene-" + this.counter.getAndIncrement();
            }
        });
        executor.setKeepAliveTime(1L, TimeUnit.MINUTES);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    private void registerObserver(BundleContext bundleContext, Configuration config) {
        boolean enableAsyncIndexOpen = config.enableOpenIndexAsync();
        Closeable observer = this.indexProvider;
        if (enableAsyncIndexOpen) {
            this.backgroundObserver = new BackgroundObserver(this.indexProvider, this.getExecutorService(), 5);
            observer = this.backgroundObserver;
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, BackgroundObserverMBean.class, this.backgroundObserver.getMBean(), "BackgroundObserverStats", "LuceneIndexConfigObserver queue stats"));
            this.log.info("Registering the LuceneIndexProvider as a BackgroundObserver");
        }
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)observer, null));
    }

    private void registerLocalIndexObserver(BundleContext bundleContext, IndexTracker tracker, Configuration config) {
        if (!this.hybridIndex) {
            this.log.info("Hybrid indexing feature disabled");
            return;
        }
        int queueSize = config.hybridQueueSize();
        long queueOfferTimeoutMillis = config.hybridQueueTimeout();
        this.documentQueue = new DocumentQueue(queueSize, queueOfferTimeoutMillis, tracker, (Executor)this.getExecutorService(), this.statisticsProvider);
        LocalIndexObserver localIndexObserver = new LocalIndexObserver(this.documentQueue, this.statisticsProvider);
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)localIndexObserver, null));
        int observerQueueSize = 1000;
        int builderMaxSize = 5000;
        this.regs.add(bundleContext.registerService(JournalPropertyService.class.getName(), (Object)new LuceneJournalPropertyService(builderMaxSize), null));
        ExternalObserverBuilder builder = new ExternalObserverBuilder((IndexingQueue)this.documentQueue, tracker, this.statisticsProvider, (Executor)this.getExecutorService(), observerQueueSize);
        this.log.info("Configured JournalPropertyBuilder with max size {} and backed by BackgroundObserver with queue size {}", (Object)builderMaxSize, (Object)observerQueueSize);
        Observer observer = builder.build();
        this.externalIndexObserver = builder.getBackgroundObserver();
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)observer, null));
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, BackgroundObserverMBean.class, this.externalIndexObserver.getMBean(), "BackgroundObserverStats", "LuceneExternalIndexObserver queue stats"));
        this.log.info("Hybrid indexing enabled for configured indexes with queue size of {}", (Object)queueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFactoryClassLoaders(ClassLoader classLoader) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            this.initializeFactoryClassLoaders0(classLoader);
            this.initializeClasses();
        }
        catch (Throwable t) {
            this.log.warn("Error occurred while initializing the Lucene Factories", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void initializeFactoryClassLoaders0(ClassLoader classLoader) {
        TokenizerFactory.reloadTokenizers(classLoader);
        CharFilterFactory.reloadCharFilters(classLoader);
        TokenFilterFactory.reloadTokenFilters(classLoader);
    }

    private void initializeClasses() {
        OakCodec ensureLucene46CodecLoaded = new OakCodec();
        this.log.debug("Lucene46Codec is loaded: {}", (Object)ensureLucene46CodecLoaded);
    }

    private void initializeExtractedTextCache(BundleContext bundleContext, Configuration config, StatisticsProvider statisticsProvider) {
        CacheStats stats;
        int cacheSizeInMB = config.extractedTextCacheSizeInMB();
        int cacheExpiryInSecs = config.extractedTextCacheExpiryInSecs();
        boolean alwaysUsePreExtractedCache = config.alwaysUsePreExtractedCache();
        this.extractedTextCache = new ExtractedTextCache((long)cacheSizeInMB * 0x100000L, (long)cacheExpiryInSecs, alwaysUsePreExtractedCache, this.indexDir, statisticsProvider);
        if (this.extractedTextProvider != null) {
            this.registerExtractedTextProvider(this.extractedTextProvider);
        }
        if ((stats = this.extractedTextCache.getCacheStats()) != null) {
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, CacheStatsMBean.class, stats, "CacheStats", stats.getName()));
            this.log.info("Extracted text caching enabled with maxSize {} MB, expiry time {} secs", (Object)cacheSizeInMB, (Object)cacheExpiryInSecs);
        }
    }

    private void registerExtractedTextProvider(PreExtractedTextProvider provider) {
        if (this.extractedTextCache != null) {
            if (provider != null) {
                String usage = this.extractedTextCache.isAlwaysUsePreExtractedCache() ? "always" : "only during reindexing phase";
                this.log.info("Registering PreExtractedTextProvider {} with extracted text cache. It would be used {}", (Object)provider, (Object)usage);
            } else {
                this.log.info("Unregistering PreExtractedTextProvider with extracted text cache");
            }
            this.extractedTextCache.setExtractedTextProvider(provider);
        }
    }

    private void configureBooleanClauseLimit(Configuration config) {
        int booleanClauseLimit = config.booleanClauseLimit();
        if (booleanClauseLimit != BooleanQuery.getMaxClauseCount()) {
            BooleanQuery.setMaxClauseCount(booleanClauseLimit);
            this.log.info("Changed the Max boolean clause limit to {}", (Object)booleanClauseLimit);
        }
    }

    private void configureIndexDefinitionStorage(Configuration config) {
        boolean disableStorage = config.disableStoredIndexDefinition();
        if (disableStorage) {
            this.log.info("Feature to ensure that index definition matches the index state is disabled. Change in index definition would now affect query plans and might lead to inconsistent results.");
            IndexDefinition.setDisableStoredIndexDefinition((boolean)disableStorage);
        }
    }

    private void registerGCMonitor(Whiteboard whiteboard, final IndexTracker tracker) {
        GCMonitor.Empty gcMonitor = new GCMonitor.Empty(){

            @Override
            public void compacted() {
                tracker.refresh();
            }
        };
        this.oakRegs.add(whiteboard.register(GCMonitor.class, gcMonitor, Collections.emptyMap()));
    }

    private void registerIndexInfoProvider(BundleContext bundleContext) {
        LuceneIndexInfoProvider infoProvider = new LuceneIndexInfoProvider(this.nodeStore, this.asyncIndexInfoService, this.getIndexCheckDir());
        this.regs.add(bundleContext.registerService(IndexInfoProvider.class.getName(), (Object)infoProvider, null));
    }

    private void registerIndexImporterProvider(BundleContext bundleContext) {
        LuceneIndexImporter importer = new LuceneIndexImporter(this.blobStore);
        this.regs.add(bundleContext.registerService(IndexImporterProvider.class.getName(), (Object)importer, null));
    }

    private void initializeActiveBlobCollector(Whiteboard whiteboard, Configuration config) {
        boolean activeDeletionEnabled = config.deletedBlobsCollectionEnabled();
        if (activeDeletionEnabled && this.blobStore != null) {
            File blobCollectorWorkingDir = new File(this.indexDir, "deleted-blobs");
            this.activeDeletedBlobCollector = ActiveDeletedBlobCollectorFactory.newInstance((File)blobCollectorWorkingDir, (ExecutorService)this.getExecutorService());
            ActiveDeletedBlobCollectorMBeanImpl bean = new ActiveDeletedBlobCollectorMBeanImpl(this.activeDeletedBlobCollector, whiteboard, this.nodeStore, this.indexPathService, this.asyncIndexInfoService, this.blobStore, this.getExecutorService());
            this.oakRegs.add(WhiteboardUtils.registerMBean(whiteboard, ActiveDeletedBlobCollectorMBean.class, bean, "ActiveDeletedBlobCollector", "Active lucene files collection"));
            this.log.info("Active blob collector initialized at working dir: {}", (Object)blobCollectorWorkingDir);
        } else {
            this.activeDeletedBlobCollector = ActiveDeletedBlobCollectorFactory.NOOP;
            this.log.info("Active blob collector set to NOOP. enabled: {} seconds; blobStore: {}", (Object)activeDeletionEnabled, (Object)this.blobStore);
        }
    }

    private void registerPropertyIndexCleaner(Configuration config, BundleContext bundleContext) {
        int cleanerInterval = config.propIndexCleanerIntervalInSecs();
        if (cleanerInterval <= 0) {
            this.log.info("Property index cleaner would not be registered");
            return;
        }
        this.cleaner = new PropertyIndexCleaner(this.nodeStore, this.indexPathService, this.asyncIndexInfoService, this.statisticsProvider);
        if (this.nodeStore instanceof Clusterable) {
            this.cleaner.setRecursiveDelete(true);
            this.log.info("PropertyIndexCleaner configured to perform recursive delete");
        }
        this.oakRegs.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, (Runnable)this.cleaner, Map.of("scheduler.name", PropertyIndexCleaner.class.getName()), (long)cleanerInterval, true, true));
        this.log.info("Property index cleaner configured to run every [{}] seconds", (Object)cleanerInterval);
    }

    private void registerLuceneFileSystemStats(LuceneIndexFileSystemStatistics luceneIndexFSStats, long delayInSeconds) {
        Map<String, Object> config = Map.of("scheduler.name", LuceneIndexFileSystemStatistics.class.getName());
        this.oakRegs.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, (Runnable)luceneIndexFSStats, config, delayInSeconds, false, true));
        this.log.info("Lucene FileSystem Statistics calculator configured to run every [{}] seconds", (Object)delayInSeconds);
    }

    protected void bindNodeAggregator(QueryIndex.NodeAggregator aggregator) {
        this.nodeAggregator = aggregator;
        this.initialize();
    }

    protected void unbindNodeAggregator(QueryIndex.NodeAggregator aggregator) {
        this.nodeAggregator = null;
        this.initialize();
    }

    protected void bindExtractedTextProvider(PreExtractedTextProvider preExtractedTextProvider) {
        this.extractedTextProvider = preExtractedTextProvider;
        this.registerExtractedTextProvider(preExtractedTextProvider);
    }

    protected void unbindExtractedTextProvider(PreExtractedTextProvider preExtractedTextProvider) {
        this.extractedTextProvider = null;
        this.registerExtractedTextProvider(null);
    }

    @ObjectClassDefinition(id="org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProviderService", name="Apache Jackrabbit Oak LuceneIndexProvider")
    static @interface Configuration {
        @AttributeDefinition(name="Disable this component", description="If true, this component is disabled.")
        public boolean disabled() default false;

        @AttributeDefinition(name="Enable Debug Logging", description="Enables debug logging in Lucene. After enabling this actual logging can be controlled via changing log level for category 'oak.lucene' to debug")
        public boolean debug() default false;

        @AttributeDefinition(name="Local index storage path", description="Local file system path where Lucene indexes would be copied when CopyOnRead is enabled. If not specified then indexes would be stored under 'index' dir under Repository Home")
        public String localIndexDir();

        @AttributeDefinition(name="Open index asynchronously", description="Enable opening of indexes in asynchronous mode")
        public boolean enableOpenIndexAsync() default true;

        @AttributeDefinition(name="Thread pool size", description="Thread pool size used to perform various asynchronous task in Oak Lucene")
        public int threadPoolSize() default 5;

        @AttributeDefinition(name="Prefetch Index Files", description="Prefetch the index files when CopyOnRead is enabled. When enabled all new Lucene index files would be copied locally before the index is made available to QueryEngine")
        public boolean prefetchIndexFiles() default true;

        @AttributeDefinition(name="Extracted text cache size (MB)", description="Cache size in MB for caching extracted text for some time. When set to 0 then cache would be disabled")
        public int extractedTextCacheSizeInMB() default 20;

        @AttributeDefinition(name="Extracted text cache expiry (secs)", description="Time in seconds for which the extracted text would be cached in memory")
        public int extractedTextCacheExpiryInSecs() default 300;

        @AttributeDefinition(name="Always use pre-extracted text cache", description="By default pre extracted text cache would only be used for reindex case. If this setting is enabled then it would also be used in normal incremental indexing")
        public boolean alwaysUsePreExtractedCache() default false;

        @AttributeDefinition(name="Boolean Clause Limit", description="Limit for number of boolean clauses generated for handling of OR query")
        public int booleanClauseLimit() default 1024;

        @AttributeDefinition(name="Hybrid Indexing", description="When enabled Lucene NRT Indexing mode would be enabled")
        public boolean enableHybridIndexing() default true;

        @AttributeDefinition(name="Queue size", description="Size of in memory queue used for storing Lucene Documents which need to be added to local index")
        public int hybridQueueSize() default 10000;

        @AttributeDefinition(name="Queue timeout", description="Maximum time to wait for adding entries to the queue used for storing Lucene Documents which need to be added to local index")
        public long hybridQueueTimeout() default 100L;

        @AttributeDefinition(name="Disable index definition storage", description="By default index definitions would be stored at time of reindexing to ensure that future modifications to it are not effective untill index is reindex. Set this to true would disable this feature")
        public boolean disableStoredIndexDefinition() default false;

        @AttributeDefinition(name="Enable actively removing deleted index blobs from blob store", description="Index blobs are explicitly unique and don't require mark-sweep type collection.This is used to enable the feature. Cleanup implies purging index blobs marked as deleted earlier during some indexing cycle.")
        public boolean deletedBlobsCollectionEnabled() default true;

        @AttributeDefinition(name="Lucene index stats update interval (seconds)", description="Delay in seconds after which Lucene stats are updated in async index update cycle.")
        public int luceneIndexStatsUpdateInterval() default 300;

        @AttributeDefinition(name="Property Index Cleaner Interval (seconds)", description="Cleaner interval time (in seconds) for synchronous property indexes configured as part of lucene indexes")
        public int propIndexCleanerIntervalInSecs() default 600;

        @AttributeDefinition(name="With CoW enabled, should index files by written as single blobs", description="Index files can be written as single blobs as chunked into smaller blobs. Enable this to write single blob per index file. This would reduce number of blobs in the data store.")
        public boolean enableSingleBlobIndexFiles() default true;

        @AttributeDefinition(name="Lucene Index File System Stats Interval (seconds)", description="Interval (in seconds) for calculation of File System metrics for Lucene Index such as Local Index Directory Size")
        public long propIndexFSStatsIntervalInSecs() default 300L;

        public boolean enableCopyOnReadSupport() default true;

        public boolean enableCopyOnWriteSupport() default true;
    }
}

