/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.value.jcr;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.blob.BlobAccessProvider;
import org.apache.jackrabbit.oak.api.blob.BlobDownloadOptions;
import org.apache.jackrabbit.oak.api.blob.BlobUpload;
import org.apache.jackrabbit.oak.api.blob.BlobUploadOptions;
import org.apache.jackrabbit.oak.commons.UUIDUtils;
import org.apache.jackrabbit.oak.namepath.JcrNameParser;
import org.apache.jackrabbit.oak.namepath.JcrPathParser;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueImpl;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartialValueFactory {
    @NotNull
    public static final BlobAccessProvider DEFAULT_BLOB_ACCESS_PROVIDER = new DefaultBlobAccessProvider();
    @NotNull
    private final NamePathMapper namePathMapper;
    @NotNull
    private final BlobAccessProvider blobAccessProvider;

    public PartialValueFactory(@NotNull NamePathMapper namePathMapper) {
        this(namePathMapper, DEFAULT_BLOB_ACCESS_PROVIDER);
    }

    public PartialValueFactory(@NotNull NamePathMapper namePathMapper, @NotNull BlobAccessProvider blobAccessProvider) {
        this.namePathMapper = Objects.requireNonNull(namePathMapper);
        this.blobAccessProvider = Objects.requireNonNull(blobAccessProvider);
    }

    @NotNull
    BlobAccessProvider getBlobAccessProvider() {
        return this.blobAccessProvider;
    }

    @NotNull
    public NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @NotNull
    public Value createValue(@NotNull PropertyState property) {
        return ValueImpl.newValue(property, this.namePathMapper, this.blobAccessProvider);
    }

    @NotNull
    public List<Value> createValues(@NotNull PropertyState property) {
        ArrayList<Value> values = new ArrayList<Value>();
        for (int i = 0; i < property.count(); ++i) {
            values.add(ValueImpl.newValue(property, i, this.namePathMapper, this.getBlobAccessProvider()));
        }
        return values;
    }

    @NotNull
    public Value createValue(@NotNull String value) {
        return ValueImpl.newValue(StringPropertyState.stringProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
    }

    @NotNull
    public Value createValue(long value) {
        return ValueImpl.newValue(LongPropertyState.createLongProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
    }

    @NotNull
    public Value createValue(double value) {
        return ValueImpl.newValue(DoublePropertyState.doubleProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
    }

    @NotNull
    public Value createValue(@NotNull Calendar value) {
        return ValueImpl.newValue(PropertyStates.createProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
    }

    @NotNull
    public Value createValue(boolean value) {
        return ValueImpl.newValue(BooleanPropertyState.booleanProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
    }

    @NotNull
    public Value createValue(@NotNull Node value) throws RepositoryException {
        return this.createValue(value, false);
    }

    @NotNull
    public Value createValue(@NotNull Node value, boolean weak) throws RepositoryException {
        if (!value.isNodeType("{http://www.jcp.org/jcr/mix/1.0}referenceable")) {
            throw new ValueFormatException("Node is not referenceable: " + value.getPath());
        }
        return weak ? ValueImpl.newValue(GenericPropertyState.weakreferenceProperty("", value.getUUID()), this.namePathMapper, this.getBlobAccessProvider()) : ValueImpl.newValue(GenericPropertyState.referenceProperty("", value.getUUID()), this.namePathMapper, this.getBlobAccessProvider());
    }

    @NotNull
    public Value createValue(@NotNull BigDecimal value) {
        return ValueImpl.newValue(DecimalPropertyState.decimalProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
    }

    @NotNull
    public Value createValue(String value, int type) throws ValueFormatException {
        if (value == null) {
            throw new ValueFormatException("null");
        }
        try {
            switch (type) {
                case 1: {
                    return this.createValue(value);
                }
                case 2: {
                    return ValueImpl.newValue(BinaryPropertyState.binaryProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
                }
                case 3: {
                    return this.createValue(Conversions.convert(value).toLong());
                }
                case 4: {
                    return this.createValue(Conversions.convert(value).toDouble());
                }
                case 5: {
                    if (ISO8601.parse(value) == null) {
                        throw new ValueFormatException("Invalid date " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.dateProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
                }
                case 6: {
                    return this.createValue(Conversions.convert(value).toBoolean());
                }
                case 7: {
                    String oakName = this.namePathMapper.getOakNameOrNull(value);
                    if (oakName == null || !JcrNameParser.validate(oakName)) {
                        throw new ValueFormatException("Invalid name: " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.nameProperty("", oakName), this.namePathMapper, this.getBlobAccessProvider());
                }
                case 8: {
                    String oakValue = value;
                    if (!(value.startsWith("[") && value.endsWith("]") || (oakValue = this.namePathMapper.getOakPath(value)) != null && JcrPathParser.validate(oakValue))) {
                        throw new ValueFormatException("Invalid path: " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.pathProperty("", oakValue), this.namePathMapper, this.getBlobAccessProvider());
                }
                case 9: {
                    if (!UUIDUtils.isValidUUID(value)) {
                        throw new ValueFormatException("Invalid reference value " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.referenceProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
                }
                case 10: {
                    if (!UUIDUtils.isValidUUID(value)) {
                        throw new ValueFormatException("Invalid weak reference value " + value);
                    }
                    return ValueImpl.newValue(GenericPropertyState.weakreferenceProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
                }
                case 11: {
                    new URI(value);
                    return ValueImpl.newValue(GenericPropertyState.uriProperty("", value), this.namePathMapper, this.getBlobAccessProvider());
                }
                case 12: {
                    return this.createValue(Conversions.convert(value).toDecimal());
                }
            }
            throw new ValueFormatException("Invalid type: " + type);
        }
        catch (NumberFormatException | URISyntaxException e) {
            throw new ValueFormatException("Invalid value " + value + " for type " + PropertyType.nameFromValue(type), e);
        }
    }

    private static class DefaultBlobAccessProvider
    implements BlobAccessProvider {
        private DefaultBlobAccessProvider() {
        }

        @Nullable
        public BlobUpload initiateBlobUpload(long maxUploadSizeInBytes, int maxNumberOfURIs) {
            return this.initiateBlobUpload(maxUploadSizeInBytes, maxNumberOfURIs, BlobUploadOptions.DEFAULT);
        }

        @Nullable
        public BlobUpload initiateBlobUpload(long maxUploadSizeInBytes, int maxNumberOfURIs, @NotNull BlobUploadOptions options) {
            return null;
        }

        @Nullable
        public Blob completeBlobUpload(@NotNull String uploadToken) {
            return null;
        }

        @Nullable
        public URI getDownloadURI(@NotNull Blob blob, @NotNull BlobDownloadOptions downloadOptions) {
            return null;
        }
    }
}

