/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.OutlineConsumer2;

public class OutlineConsumerAdapter
implements OutlineConsumer {
    final OutlineConsumer2 dest;
    protected boolean contourStarted;
    double startX;
    double startY;
    double currentX;
    double currentY;
    protected Matrix toEmMatrix = Matrix.IDENTITY_MATRIX;
    protected Matrix emToDeviceMatrix = Matrix.IDENTITY_MATRIX;
    protected Matrix compositeMatrix = Matrix.IDENTITY_MATRIX;

    public OutlineConsumerAdapter(OutlineConsumer2 dest) {
        this.dest = dest;
    }

    public void startOutline() {
        this.dest.startOutline();
        this.contourStarted = false;
    }

    @Override
    public void setMatrix(Matrix m) {
        this.setMatrices(m, this.emToDeviceMatrix);
    }

    public void setEmToPixelMatrix(Matrix m) {
        this.setMatrices(this.toEmMatrix, m);
    }

    protected void setMatrices(Matrix toEmMatrix, Matrix emToDeviceMatrix) {
        this.toEmMatrix = toEmMatrix;
        this.emToDeviceMatrix = emToDeviceMatrix;
        this.compositeMatrix = toEmMatrix.isIdentity() ? emToDeviceMatrix : (emToDeviceMatrix.isIdentity() ? toEmMatrix : toEmMatrix.multiply(emToDeviceMatrix));
    }

    @Override
    public void moveto(double x, double y) {
        if (this.contourStarted) {
            this.dest.line(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(this.startX, this.startY), this.compositeMatrix.applyToXYGetY(this.startX, this.startY));
            this.dest.endContour();
            this.contourStarted = false;
        }
        this.currentX = x;
        this.currentY = y;
    }

    @Override
    public void lineto(double x2, double y2) {
        if (!this.contourStarted) {
            this.dest.startContour();
            this.contourStarted = true;
            this.startX = this.currentX;
            this.startY = this.currentY;
        }
        this.dest.line(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(x2, y2), this.compositeMatrix.applyToXYGetY(x2, y2));
        this.currentX = x2;
        this.currentY = y2;
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3) {
        if (!this.contourStarted) {
            this.dest.startContour();
            this.contourStarted = true;
            this.startX = this.currentX;
            this.startY = this.currentY;
        }
        this.dest.quadraticCurve(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(x2, y2), this.compositeMatrix.applyToXYGetY(x2, y2), this.compositeMatrix.applyToXYGetX(x3, y3), this.compositeMatrix.applyToXYGetY(x3, y3));
        this.currentX = x3;
        this.currentY = y3;
    }

    @Override
    public void curveto(double x2, double y2, double x3, double y3, double x4, double y4) {
        if (!this.contourStarted) {
            this.dest.startContour();
            this.contourStarted = true;
            this.startX = this.currentX;
            this.startY = this.currentY;
        }
        this.dest.cubicCurve(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(x2, y2), this.compositeMatrix.applyToXYGetY(x2, y2), this.compositeMatrix.applyToXYGetX(x3, y3), this.compositeMatrix.applyToXYGetY(x3, y3), this.compositeMatrix.applyToXYGetX(x4, y4), this.compositeMatrix.applyToXYGetY(x4, y4));
        this.currentX = x4;
        this.currentY = y4;
    }

    public void endOutline() {
        if (this.contourStarted) {
            if (this.currentX != this.startX || this.currentY != this.startY) {
                this.dest.line(this.compositeMatrix.applyToXYGetX(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetY(this.currentX, this.currentY), this.compositeMatrix.applyToXYGetX(this.startX, this.startY), this.compositeMatrix.applyToXYGetY(this.startX, this.startY));
            }
            this.dest.endContour();
        }
        this.dest.endOutline();
    }

    @Override
    public void endchar() {
    }
}

