/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.agl.lang.UCharacter;
import com.adobe.agl.text.CanonicalIterator;
import com.adobe.agl.text.Normalizer;
import com.adobe.agl.text.UCharacterIterator;
import com.adobe.fontengine.Properties;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.UnsupportedFontException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SWFFont4Description {
    private static final boolean DEBUG = false;

    protected SWFFont4Description() {
    }

    public abstract boolean canDisplay(int var1) throws UnsupportedFontException, InvalidFontException;

    public abstract int getFirstChar() throws InvalidFontException, UnsupportedFontException;

    public abstract int getLastChar() throws InvalidFontException, UnsupportedFontException;

    public abstract Permission getPermissions() throws InvalidFontException, UnsupportedFontException;

    public abstract String getFamily() throws InvalidFontException, UnsupportedFontException;

    public abstract String getSubFamily() throws InvalidFontException, UnsupportedFontException;

    public abstract boolean isBold() throws InvalidFontException, UnsupportedFontException;

    public abstract boolean isItalic() throws InvalidFontException, UnsupportedFontException;

    public abstract void streamFontData(Iterator<Integer> var1, OutputStream var2) throws InvalidFontException, UnsupportedFontException, IOException;

    public abstract void streamFontData(OutputStream var1) throws InvalidFontException, UnsupportedFontException, IOException;

    public static final class TLFSubsetCompletionIterator
    implements Iterator<Integer> {
        private static int[] additionsArray = new int[]{9, 8232, 8233};
        private Iterator<Integer> mIter1;
        private Iterator<Integer> mIter2;

        public TLFSubsetCompletionIterator(Iterator<Integer> cpIter) {
            this.mIter1 = cpIter;
            HashSet<Integer> addedCodes = new HashSet<Integer>();
            for (int addedCode : additionsArray) {
                addedCodes.add(addedCode);
            }
            this.mIter2 = addedCodes.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.mIter1 != null) {
                if (this.mIter1.hasNext()) {
                    return true;
                }
                this.mIter1 = null;
            }
            return this.mIter2.hasNext();
        }

        @Override
        public Integer next() {
            if (this.mIter1 != null) {
                return this.mIter1.next();
            }
            return this.mIter2.next();
        }

        @Override
        public void remove() {
            if (this.mIter1 != null) {
                this.mIter1.remove();
            } else {
                this.mIter2.remove();
            }
        }
    }

    public static final class FTESubsetCompletionIterator
    implements Iterator<Integer> {
        private static final int[] additionsArray = new int[]{32};
        private static final Map<Integer, List<Integer>> REPLACEMENT_MAP;
        private static final int CROSSOVER_FOR_DECOMPOSITION = 900;
        private Iterator<Integer> completionIter;

        public FTESubsetCompletionIterator(Iterator<Integer> cpIter) {
            HashSet<Integer> total = new HashSet<Integer>();
            HashSet<Integer> combining = new HashSet<Integer>();
            this.fillInternalSet(cpIter, total, combining);
            Set cases = this.caseCompletions(total);
            total.addAll(cases);
            combining.addAll(cases);
            Set combinedSet = null;
            combinedSet = total.size() < 900 ? this.expandCombiningSequences(total, combining) : this.decomposeUnicode(total);
            total.addAll(combinedSet);
            this.completionIter = total.iterator();
        }

        private void fillInternalSet(Iterator<Integer> iter, Set<Integer> total, Set<Integer> combining) {
            for (int cp : additionsArray) {
                total.add(cp);
                combining.add(cp);
            }
            LinkedList<Integer> replacementBuffer = new LinkedList<Integer>();
            while (iter.hasNext() || !replacementBuffer.isEmpty()) {
                Integer cp = 0;
                if (!replacementBuffer.isEmpty()) {
                    cp = (Integer)replacementBuffer.remove();
                } else {
                    List<Integer> replacementList;
                    cp = iter.next();
                    int mirror = UCharacter.getMirror(cp);
                    if (mirror != cp) {
                        replacementList = REPLACEMENT_MAP.get(mirror);
                        if (replacementList != null) {
                            replacementBuffer.addAll(replacementList);
                        } else {
                            replacementBuffer.add(mirror);
                        }
                    }
                    if ((replacementList = REPLACEMENT_MAP.get(cp)) != null) {
                        replacementBuffer.addAll(replacementList);
                        cp = (Integer)replacementBuffer.remove();
                    }
                }
                total.add(cp);
                combining.add(cp);
            }
        }

        private Set expandCombiningSequences(Set<Integer> baseSet, Set<Integer> combiningSet) {
            HashSet<Integer> resultSet = new HashSet<Integer>(baseSet.size());
            Set<Integer> previousPassCodes = baseSet;
            while (!previousPassCodes.isEmpty()) {
                HashSet<Integer> newCodes = new HashSet<Integer>();
                for (Integer base : previousPassCodes) {
                    for (Integer combining : combiningSet) {
                        StringBuffer sequence = new StringBuffer();
                        sequence.appendCodePoint(base);
                        sequence.appendCodePoint(combining);
                        UCharacterIterator sequenceIter = UCharacterIterator.getInstance(sequence);
                        Normalizer nfc = new Normalizer(sequenceIter, Normalizer.NFC, 0);
                        int composed = 0;
                        while ((composed = nfc.next()) != -1) {
                            if (baseSet.contains(composed) || resultSet.contains(composed) || combiningSet.contains(composed)) continue;
                            resultSet.add(composed);
                            newCodes.add(composed);
                        }
                    }
                }
                previousPassCodes = newCodes;
            }
            return resultSet;
        }

        private Set decomposeUnicode(Set<Integer> completeSet) {
            HashSet<Integer> resultSet = new HashSet<Integer>();
            block0: for (int originalCodepoint = 0; originalCodepoint < 0x10FFFF; ++originalCodepoint) {
                int dt = UCharacter.getIntPropertyValue(originalCodepoint, 4099);
                if (dt != 1) continue;
                StringBuffer sequence = new StringBuffer();
                sequence.appendCodePoint(originalCodepoint);
                CanonicalIterator canonIter = new CanonicalIterator(sequence.toString());
                String decomposed = canonIter.next();
                while (decomposed != null) {
                    boolean insert = true;
                    UCharacterIterator sequenceIter = UCharacterIterator.getInstance(decomposed);
                    int decomposedCodepoint = sequenceIter.nextCodePoint();
                    while (decomposedCodepoint != -1) {
                        if (!completeSet.contains(decomposedCodepoint)) {
                            insert = false;
                            break;
                        }
                        decomposedCodepoint = sequenceIter.nextCodePoint();
                    }
                    if (insert) {
                        resultSet.add(originalCodepoint);
                        continue block0;
                    }
                    decomposed = canonIter.next();
                }
            }
            return resultSet;
        }

        private Set caseCompletions(Set<Integer> completeSet) {
            int[] tailorings = new int[]{4, 5};
            int[] mappings = new int[3];
            HashSet<Integer> resultSet = new HashSet<Integer>();
            for (int tailoring : tailorings) {
                for (int code : completeSet) {
                    int i;
                    int count = Properties.getFullUpperCase(code, tailoring, mappings);
                    if (count > 0 && (count > 1 || code != mappings[0])) {
                        for (i = 0; i < count; ++i) {
                            resultSet.add(mappings[i]);
                        }
                    }
                    if ((count = Properties.getFullLowerCase(code, tailoring, mappings)) <= 0 || count <= 1 && code == mappings[0]) continue;
                    for (i = 0; i < count; ++i) {
                        resultSet.add(mappings[i]);
                    }
                }
            }
            return resultSet;
        }

        @Override
        public boolean hasNext() {
            return this.completionIter.hasNext();
        }

        @Override
        public Integer next() {
            return this.completionIter.next();
        }

        @Override
        public void remove() {
            this.completionIter.remove();
        }

        static {
            int[][] replacementsArray = new int[][]{{9}, {32}, {10}, {32}, {13}, {32}, {133}, {32}, {173}, {32}, {847}, {32}, {4447}, {32}, {4448}, {32}, {6068}, {32}, {6069}, {32}, {8203}, {32}, {8204}, {32}, {8205}, {32}, {8206}, {32}, {8207}, {32}, {8232}, {32}, {8233}, {32}, {8234}, {32}, {8235}, {32}, {8236}, {32}, {8237}, {32}, {8238}, {32}, {8288}, {32}, {8289}, {32}, {8290}, {32}, {8291}, {32}, {8292}, {32}, {8293}, {32}, {8294}, {32}, {8295}, {32}, {8296}, {32}, {8297}, {32}, {8298}, {32}, {8299}, {32}, {8300}, {32}, {8301}, {32}, {8302}, {32}, {8303}, {32}, {12644}, {32}, {65279}, {32}, {65440}, {32}, {65520}, {32}, {65521}, {32}, {65522}, {32}, {65523}, {32}, {65524}, {32}, {65525}, {32}, {65526}, {32}, {65527}, {32}, {65528}, {32}, {119155}, {32}, {119156}, {32}, {119157}, {32}, {119158}, {32}, {119159}, {32}, {119160}, {32}, {119161}, {32}, {119162}, {32}, {2507}, {2503, 2494}, {2508}, {2503, 2519}, {2888}, {2887, 2902}, {2891}, {2887, 2878}, {2892}, {2887, 2903}, {3018}, {3014, 3006}, {3019}, {3015, 3006}, {3020}, {3014, 3031}, {3144}, {3142, 3158}, {3264}, {3263, 3285}, {3271}, {3270, 3285}, {3272}, {3270, 3286}, {3274}, {3270, 3266}, {3275}, {3270, 3266, 3285}, {3402}, {3398, 3390}, {3403}, {3399, 3390}, {3404}, {3398, 3415}, {3546}, {3545, 3530}, {3548}, {3545, 3535}, {3549}, {3545, 3535, 3530}, {3550}, {3545, 3551}, {3597}, {3597, 63247}, {3600}, {3600, 63232}, {3633}, {3633, 63248}, {3635}, {3661, 3634, 63249}, {3636}, {3636, 63233}, {3637}, {3637, 63234}, {3638}, {3638, 63235}, {3639}, {3639, 63236}, {3640}, {3640, 63256}, {3641}, {3641, 63257}, {3642}, {3642, 63258}, {3655}, {3655, 63250}, {3656}, {3656, 63251, 63242, 63237}, {3657}, {3657, 63252, 63243, 63238}, {3658}, {3658, 63253, 63244, 63239}, {3659}, {3659, 63254, 63245, 63240}, {3660}, {3660, 63255, 63246, 63241}, {3661}, {3661, 63249}, {3763}, {3789, 3762}, {3955}, {3953, 3954}, {3957}, {3953, 3956}, {3958}, {4018, 3968}, {3959}, {4018, 3953, 3968}, {3960}, {4019, 3968}, {3961}, {4019, 3953, 3968}, {3969}, {3953, 3968}, {6078}, {6081, 6078}, {6079}, {6081, 6079}, {6080}, {6081, 6080}, {6084}, {6081, 6084}, {6085}, {6081, 6085}, {160}, {160, 32}, {8192}, {8192, 32}, {8193}, {8193, 32}, {8194}, {8194, 32}, {8195}, {8195, 32}, {8196}, {8196, 32}, {8197}, {8197, 32}, {8198}, {8198, 32}, {8199}, {8199, 32, 48}, {8200}, {8200, 32, 46}, {8201}, {8201, 32}, {8202}, {8202, 32}, {8203}, {8203, 32}, {8239}, {8239, 32}, {8287}, {8287, 32}, {12288}, {12288, 32}};
            HashMap temporaryReplacementMap = new HashMap();
            for (int i = 0; i < replacementsArray.length; i += 2) {
                ArrayList<Integer> replacementsList = new ArrayList<Integer>(replacementsArray[i].length);
                int[] arr$ = replacementsArray[i + 1];
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Integer replacement = arr$[i$];
                    replacementsList.add(replacement);
                }
                temporaryReplacementMap.put(replacementsArray[i][0], replacementsList);
            }
            REPLACEMENT_MAP = Collections.unmodifiableMap(temporaryReplacementMap);
        }
    }
}

