/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.font.FontByteArray;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OTByteArray;
import com.adobe.fontengine.font.opentype.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Kern
extends Table {
    private final KernInterpretter interpretter;
    private static final MSKernTable msKernTable = new MSKernTable();
    private static final AppleKernTable appleKernTable = new AppleKernTable();

    protected Kern(FontByteArray buffer) throws IOException, InvalidFontException, UnsupportedFontException {
        super(buffer);
        int majorVersion = this.getTableMajorVersion();
        switch (majorVersion) {
            case 0: {
                this.interpretter = msKernTable;
                break;
            }
            case 1: {
                if (this.data.getuint16(2) != 0) {
                    throw new UnsupportedFontException("'kern' table version 1.x not supported yet");
                }
                this.interpretter = appleKernTable;
                break;
            }
            default: {
                throw new UnsupportedFontException("'kern' table major version = " + majorVersion + " not supported");
            }
        }
    }

    public int getTableMajorVersion() throws InvalidFontException {
        return this.data.getuint16(0);
    }

    public int[] getKernVector(int leftGid, int rightGid) throws InvalidFontException, UnsupportedFontException {
        int[] kernVector = new int[2];
        kernVector[1] = 0;
        kernVector[0] = 0;
        boolean crossStream = false;
        int nTables = this.interpretter.getNumTables(this.data);
        int offset = this.interpretter.getOffsetOfFirstSubtable();
        for (int t = 0; t < nTables; ++t) {
            crossStream = this.applyKernSubtable(kernVector, offset, crossStream, leftGid, rightGid);
            offset += this.interpretter.getLength(this.data, offset);
        }
        return kernVector;
    }

    private boolean applyKernSubtable(int[] kernVector, int offset, boolean crossStream, int leftGid, int rightGid) throws InvalidFontException, UnsupportedFontException {
        int coverage = this.interpretter.getCoverage(this.data, offset);
        int format = this.interpretter.subtableFormat(coverage);
        if (this.interpretter.verticalSubtable(coverage)) {
            return crossStream;
        }
        switch (format) {
            case 0: {
                crossStream = this.applyKernSubtableFormat0(kernVector, offset, crossStream, leftGid, rightGid);
                break;
            }
            case 2: {
                crossStream = this.applyKernSubtableFormat2(kernVector, offset, crossStream, leftGid, rightGid);
                break;
            }
            default: {
                throw new InvalidFontException("invalid kern subtable format (" + format + ")");
            }
        }
        return crossStream;
    }

    private boolean applyKernSubtableFormat2(int[] kernVector, int offset, boolean crossStream, int leftGid, int rightGid) throws InvalidFontException {
        int rightClass;
        int leftClassOffset = this.data.getOffset(offset, this.interpretter.getSubtableHeaderSize() + 2);
        int rightClassOffset = this.data.getOffset(offset, this.interpretter.getSubtableHeaderSize() + 4);
        int firstLeftGlyph = this.data.getuint16(leftClassOffset);
        int numLeftGlyph = this.data.getuint16(leftClassOffset + 2);
        if (leftGid < firstLeftGlyph || leftGid >= firstLeftGlyph + numLeftGlyph) {
            return crossStream;
        }
        int firstRightGlyph = this.data.getuint16(rightClassOffset);
        int numRightGlyph = this.data.getuint16(rightClassOffset + 2);
        if (rightGid < firstRightGlyph || rightGid >= firstRightGlyph + numRightGlyph) {
            return crossStream;
        }
        int leftClass = this.data.getuint16(leftClassOffset + (leftGid - firstLeftGlyph) * 2 + 4);
        int value = this.data.getint16(offset + leftClass + (rightClass = this.data.getuint16(rightClassOffset + (rightGid - firstRightGlyph) * 2 + 4)));
        if ((value & 0xFFFF) == 32768) {
            crossStream = false;
        } else {
            int vectorIndex = crossStream ? 1 : 0;
            int coverage = this.interpretter.getCoverage(this.data, offset);
            if (this.interpretter.minimumSubtable(coverage)) {
                kernVector[vectorIndex] = Math.max(kernVector[vectorIndex], value);
            } else if (this.interpretter.overrideSubtable(coverage)) {
                kernVector[vectorIndex] = value;
            } else {
                int n = vectorIndex;
                kernVector[n] = kernVector[n] + value;
            }
        }
        return crossStream;
    }

    private boolean applyKernSubtableFormat0(int[] kernVector, int offset, boolean crossStream, int leftGid, int rightGid) throws InvalidFontException {
        int nPairs = this.data.getuint16(offset + this.interpretter.getSubtableHeaderSize());
        int min = 0;
        int max = nPairs;
        while (min < max) {
            int mid = (min + max) / 2;
            int l = this.data.getuint16(offset + this.interpretter.getSubtableHeaderSize() + 8 + 6 * mid);
            int r = this.data.getuint16(offset + this.interpretter.getSubtableHeaderSize() + 8 + 6 * mid + 2);
            if (l < leftGid || l == leftGid && r < rightGid) {
                min = mid + 1;
                continue;
            }
            if (leftGid < l || leftGid == l && rightGid < r) {
                max = mid;
                continue;
            }
            int value = this.data.getint16(offset + this.interpretter.getSubtableHeaderSize() + 8 + 6 * mid + 4);
            if ((value & 0xFFFF) == 32768) {
                crossStream = false;
            } else {
                int vectorIndex;
                int coverage = this.interpretter.getCoverage(this.data, offset);
                int n = vectorIndex = crossStream ? 1 : 0;
                if (this.interpretter.minimumSubtable(coverage)) {
                    kernVector[vectorIndex] = Math.max(kernVector[vectorIndex], value);
                } else if (this.interpretter.overrideSubtable(coverage)) {
                    kernVector[vectorIndex] = value;
                } else {
                    int n2 = vectorIndex;
                    kernVector[n2] = kernVector[n2] + value;
                }
            }
            return crossStream;
        }
        return crossStream;
    }

    public void stream(Map tables) {
        OTByteArray.OTByteArrayBuilder newData = this.getDataAsByteArray();
        tables.put(new Integer(1801810542), newData);
    }

    private int writeTableDataFormat0(OTByteArray.OTByteArrayBuilder builder, int newOffset, List pairs) {
        if (pairs.size() == 0) {
            return 0;
        }
        Collections.sort(pairs);
        int size = 8 + 6 * pairs.size();
        builder.ensureCapacity(newOffset + size);
        int entrySelector = (int)Math.floor(Kern.log2(pairs.size()));
        int searchRange = (int)Math.pow(2.0, entrySelector);
        builder.setuint16(newOffset, pairs.size());
        builder.setuint16(newOffset + 2, searchRange * 6);
        builder.setuint16(newOffset + 4, entrySelector);
        builder.setuint16(newOffset + 6, (pairs.size() - searchRange) * 6);
        for (int i = 0; i < pairs.size(); ++i) {
            KernEntry entry = (KernEntry)pairs.get(i);
            builder.setuint16(newOffset + 8 + 6 * i, entry.left);
            builder.setuint16(newOffset + 8 + 6 * i + 2, entry.right);
            builder.setuint16(newOffset + 8 + 6 * i + 4, entry.kern);
        }
        return size;
    }

    private int writeTableDataFormat0(OTByteArray.OTByteArrayBuilder builder, int origOffset, int newOffset, Subset subset) throws InvalidFontException, UnsupportedFontException {
        int origNPairs = this.data.getuint16(origOffset);
        ArrayList<KernEntry> pairs = new ArrayList<KernEntry>();
        for (int i = 0; i < origNPairs; ++i) {
            int rightGid;
            int leftGid;
            try {
                leftGid = this.data.getuint16(origOffset + 8 + 6 * i);
            }
            catch (InvalidFontException e) {
                break;
            }
            if (subset.getExistingSubsetGid(leftGid) == -1 || subset.getExistingSubsetGid(rightGid = this.data.getuint16(origOffset + 8 + 6 * i + 2)) == -1) continue;
            pairs.add(new KernEntry(subset.getExistingSubsetGid(leftGid), subset.getExistingSubsetGid(rightGid), this.data.getint16(origOffset + 8 + 6 * i + 4)));
        }
        return this.writeTableDataFormat0(builder, newOffset, pairs);
    }

    private int writeTableDataFormat2As0(OTByteArray.OTByteArrayBuilder builder, int origSTDataOffset, int newSTDataOffset, Subset subset) throws InvalidFontException {
        int leftOffset = origSTDataOffset - this.interpretter.getSubtableHeaderSize() + this.data.getuint16(origSTDataOffset + 2);
        int rightOffset = origSTDataOffset - this.interpretter.getSubtableHeaderSize() + this.data.getuint16(origSTDataOffset + 4);
        int leftFirstGlyph = this.data.getuint16(leftOffset);
        int leftNGlyphs = this.data.getuint16(leftOffset + 2);
        int rightFirstGlyph = this.data.getuint16(rightOffset);
        int rightNGlyphs = this.data.getuint16(rightOffset + 2);
        ArrayList<KernEntry> pairs = new ArrayList<KernEntry>();
        for (int i = 0; i < subset.getNumGlyphs(); ++i) {
            int fullLeft = subset.getFullGid(i);
            if (fullLeft < leftFirstGlyph || fullLeft >= leftFirstGlyph + leftNGlyphs) continue;
            for (int j = 0; j < subset.getNumGlyphs(); ++j) {
                int fullRight = subset.getFullGid(j);
                if (fullRight < rightFirstGlyph || fullRight >= rightFirstGlyph + rightNGlyphs) continue;
                int leftClass = this.data.getuint16(leftOffset + (fullLeft - leftFirstGlyph) * 2 + 4);
                int rightClass = this.data.getuint16(rightOffset + (fullRight - rightFirstGlyph) * 2 + 4);
                int value = this.data.getint16(origSTDataOffset - this.interpretter.getSubtableHeaderSize() + leftClass + rightClass);
                if (value == 0) continue;
                pairs.add(new KernEntry(i, j, value));
            }
        }
        return this.writeTableDataFormat0(builder, newSTDataOffset, pairs);
    }

    private int writeFormat0TableData(OTByteArray.OTByteArrayBuilder builder, int origSTDataOffset, int newSTDataOffset, Subset subset, int format) throws InvalidFontException, UnsupportedFontException {
        switch (format) {
            case 0: {
                return this.writeTableDataFormat0(builder, origSTDataOffset, newSTDataOffset, subset);
            }
            case 2: {
                return this.writeTableDataFormat2As0(builder, origSTDataOffset, newSTDataOffset, subset);
            }
        }
        return 0;
    }

    private static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public void subsetAndStreamForSWF(Subset subset, Map tables) throws InvalidFontException, UnsupportedFontException {
        OTByteArray.OTByteArrayBuilder newData = OTByteArray.getOTByteArrayBuilderInstance();
        int origNTables = this.interpretter.getNumTables(this.data);
        if (origNTables > 0) {
            int newNTables = 0;
            int origOffset = this.interpretter.getOffsetOfFirstSubtable();
            int newOffset = this.interpretter.getOffsetOfFirstSubtable();
            for (int t = 0; t < origNTables; ++t) {
                int coverage = this.interpretter.getCoverage(this.data, origOffset);
                if (this.interpretter.verticalSubtable(coverage) || this.interpretter.minimumSubtable(coverage) || this.interpretter.crossStreamSubtable(coverage)) continue;
                int format = this.interpretter.subtableFormat(coverage);
                int newSize = this.writeFormat0TableData(newData, origOffset + this.interpretter.getSubtableHeaderSize(), newOffset + this.interpretter.getSubtableHeaderSize(), subset, format);
                if (newSize > 0) {
                    this.interpretter.writeSubtableHeader(this.data, newData, origOffset, newOffset, newSize, 0);
                    ++newNTables;
                }
                origOffset += this.interpretter.getLength(this.data, origOffset);
                newOffset += newSize;
            }
            if (newNTables != 0) {
                this.interpretter.writeHeader(newData, newNTables);
                tables.put(new Integer(1801810542), newData);
            }
        }
    }

    private class KernEntry
    implements Comparable {
        final int left;
        final int right;
        final int kern;

        KernEntry(int left, int right, int kern2) {
            this.left = left;
            this.right = right;
            this.kern = kern2;
        }

        public int compareTo(Object o) {
            KernEntry right = (KernEntry)o;
            if (this.left < right.left) {
                return -1;
            }
            if (this.left > right.left) {
                return 1;
            }
            if (this.right < right.right) {
                return -1;
            }
            if (this.right > right.right) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "[" + this.left + ", " + this.right + ", " + this.kern + "]";
        }
    }

    private static class AppleKernTable
    implements KernInterpretter {
        private static final int COVERAGE_VERTICAL = 32768;
        private static final int CROSS_STREAM = 16384;

        private AppleKernTable() {
        }

        @Override
        public int getOffsetOfFirstSubtable() {
            return 8;
        }

        @Override
        public int getSubtableHeaderSize() {
            return 8;
        }

        @Override
        public int getNumTables(OTByteArray data) throws InvalidFontException, UnsupportedFontException {
            if (data.getSize() < 8) {
                return 0;
            }
            return data.getuint32asint(4, "Too many subtables in kern table");
        }

        @Override
        public int getCoverage(OTByteArray data, int subtableOffset) throws InvalidFontException {
            return data.getuint16(subtableOffset + 4);
        }

        @Override
        public int getLength(OTByteArray data, int subtableOffset) throws InvalidFontException, UnsupportedFontException {
            return data.getuint32asint(subtableOffset, "Kern subtable too large");
        }

        @Override
        public boolean minimumSubtable(int coverage) {
            return false;
        }

        @Override
        public boolean overrideSubtable(int coverage) {
            return false;
        }

        @Override
        public int subtableFormat(int coverage) {
            return coverage & 0xFF;
        }

        @Override
        public boolean verticalSubtable(int coverage) {
            return (coverage & 0x8000) != 0;
        }

        @Override
        public boolean crossStreamSubtable(int coverage) {
            return (coverage & 0x4000) != 0;
        }

        @Override
        public void writeHeader(OTByteArray.OTByteArrayBuilder newData, int newNTables) {
            newData.setuint32(0, 65536);
            newData.setuint32(4, newNTables);
        }

        @Override
        public void writeSubtableHeader(OTByteArray origData, OTByteArray.OTByteArrayBuilder newData, int origOffset, int newOffset, int newSize, int format) throws InvalidFontException {
            int coverage = this.getCoverage(origData, origOffset);
            coverage = coverage & 0xFF00 | format & 0xFF;
            newData.setuint32(newOffset, newSize);
            newData.setuint16(newOffset + 4, coverage);
            newData.setuint16(newOffset + 6, origData.getuint16(origOffset + 6));
        }
    }

    private static class MSKernTable
    implements KernInterpretter {
        private static final int COVERAGE_HORIZONTAL = 1;
        private static final int COVERAGE_MINIMUM = 2;
        private static final int CROSS_STREAM = 4;
        private static final int COVERAGE_OVERRIDES = 8;

        private MSKernTable() {
        }

        @Override
        public int getNumTables(OTByteArray data) throws InvalidFontException {
            if (data.getSize() < 4) {
                return 0;
            }
            return data.getuint16(2);
        }

        @Override
        public int getSubtableHeaderSize() {
            return 6;
        }

        @Override
        public int getOffsetOfFirstSubtable() {
            return 4;
        }

        @Override
        public int getCoverage(OTByteArray data, int subtableOffset) throws InvalidFontException {
            return data.getuint16(subtableOffset + 4);
        }

        @Override
        public int getLength(OTByteArray data, int subtableOffset) throws InvalidFontException {
            return data.getuint16(subtableOffset + 2);
        }

        @Override
        public boolean minimumSubtable(int coverage) {
            return (coverage & 2) != 0;
        }

        @Override
        public boolean overrideSubtable(int coverage) {
            return (coverage & 8) != 0;
        }

        @Override
        public int subtableFormat(int coverage) {
            return coverage >> 8;
        }

        @Override
        public boolean verticalSubtable(int coverage) {
            return (coverage & 1) == 0;
        }

        @Override
        public boolean crossStreamSubtable(int coverage) {
            return (coverage & 4) != 0;
        }

        @Override
        public void writeSubtableHeader(OTByteArray origData, OTByteArray.OTByteArrayBuilder newData, int origOffset, int newOffset, int newSize, int format) throws InvalidFontException {
            int coverage = this.getCoverage(origData, origOffset);
            coverage = coverage & 0xFF | format << 8 & 0xFF00;
            newData.setuint16(newOffset, origData.getuint16(origOffset));
            newData.setuint16(newOffset + 2, newSize);
            newData.setuint16(newOffset + 4, coverage);
        }

        @Override
        public void writeHeader(OTByteArray.OTByteArrayBuilder newData, int newNTables) {
            newData.setuint16(0, 0);
            newData.setuint16(2, newNTables);
        }
    }

    private static interface KernInterpretter {
        public int getNumTables(OTByteArray var1) throws InvalidFontException, UnsupportedFontException;

        public int getOffsetOfFirstSubtable();

        public int getSubtableHeaderSize();

        public int getCoverage(OTByteArray var1, int var2) throws InvalidFontException;

        public int getLength(OTByteArray var1, int var2) throws InvalidFontException, UnsupportedFontException;

        public boolean verticalSubtable(int var1);

        public boolean minimumSubtable(int var1);

        public boolean overrideSubtable(int var1);

        public boolean crossStreamSubtable(int var1);

        public int subtableFormat(int var1);

        public void writeSubtableHeader(OTByteArray var1, OTByteArray.OTByteArrayBuilder var2, int var3, int var4, int var5, int var6) throws InvalidFontException;

        public void writeHeader(OTByteArray.OTByteArrayBuilder var1, int var2);
    }
}

