/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font.type1;

import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.font.CScan;
import com.adobe.fontengine.font.CatalogDescription;
import com.adobe.fontengine.font.CodePage;
import com.adobe.fontengine.font.CoolTypeScript;
import com.adobe.fontengine.font.EmbeddingPermission;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontInputStream;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.LineMetrics;
import com.adobe.fontengine.font.Matrix;
import com.adobe.fontengine.font.OrigFontType;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.PDFFontDescription;
import com.adobe.fontengine.font.Permission;
import com.adobe.fontengine.font.ROS;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.SWFFont4Description;
import com.adobe.fontengine.font.SWFFontDescription;
import com.adobe.fontengine.font.Scaler;
import com.adobe.fontengine.font.ScanConverter;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.SubsetDefaultImpl;
import com.adobe.fontengine.font.SubsetSimpleTrueType;
import com.adobe.fontengine.font.SubsetSimpleType1;
import com.adobe.fontengine.font.UnderlineMetrics;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.XDCFontDescription;
import com.adobe.fontengine.font.cff.CIDKeyedFont;
import com.adobe.fontengine.font.cff.CharStrings;
import com.adobe.fontengine.font.cff.Dict;
import com.adobe.fontengine.font.cff.NameKeyedFont;
import com.adobe.fontengine.font.cff.Type2CStringGenerator;
import com.adobe.fontengine.font.postscript.GlyphNamesAccessor;
import com.adobe.fontengine.font.postscript.NameHeuristics;
import com.adobe.fontengine.font.postscript.ScriptHeuristics;
import com.adobe.fontengine.font.postscript.StandardEncoding;
import com.adobe.fontengine.font.postscript.SubArrays;
import com.adobe.fontengine.font.postscript.Token;
import com.adobe.fontengine.font.postscript.TokenType;
import com.adobe.fontengine.font.postscript.Tokenizer;
import com.adobe.fontengine.font.postscript.UnicodeCmap;
import com.adobe.fontengine.font.type1.AFM;
import com.adobe.fontengine.font.type1.AsciiEexecReader;
import com.adobe.fontengine.font.type1.BinaryEexecReader;
import com.adobe.fontengine.font.type1.MetricFile;
import com.adobe.fontengine.font.type1.PFBInputStream;
import com.adobe.fontengine.font.type1.PFM;
import com.adobe.fontengine.font.type1.Type1CStringParser;
import com.adobe.fontengine.font.type1.Type1Glyph;
import com.adobe.fontengine.font.type1.Type1GlyphBBoxCalculator;
import com.adobe.fontengine.font.type1.Type1OutlineParser;
import com.adobe.fontengine.font.type1.Type1Scaler;
import com.adobe.fontengine.font.type1.Type1Subset;
import com.adobe.fontengine.font.type1.Type1WidthFetcher;
import com.adobe.fontengine.fontmanagement.CacheSupportInfo;
import com.adobe.fontengine.fontmanagement.Platform;
import com.adobe.fontengine.fontmanagement.fxg.FXGFontDescription;
import com.adobe.fontengine.fontmanagement.platform.PlatformFontDescription;
import com.adobe.fontengine.fontmanagement.postscript.PostscriptFontDescription;
import com.adobe.fontengine.inlineformatting.css20.CSS20Attribute;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class Type1Font
extends FontData {
    private Map keyVal;
    private byte[][] subrs;
    private Type1Glyph[] charStrings;
    private MetricFile metricFile;
    private final URL fontLocation;
    private boolean seenPrivate;
    private Map syntheticBaseMap;
    private Map currentMap;
    private static final int maxIntArrayLen = 16;
    private static final int maxDoubleArrayLen = 64;
    private static final Map literals;
    private static final int defaultLenIV = 4;
    static final Matrix defaultFontMatrix;
    static final double[] defaultKernValue;
    private final T1XDCFontDescription xdcDescription;
    UnicodeCmap cmap = null;
    Object cmapMutex = new Object();

    Type1Font(FontInputStream inStream, URL location) throws IOException, InvalidFontException, UnsupportedFontException {
        super(null);
        this.keyVal = new HashMap();
        this.currentMap = this.keyVal;
        this.fontLocation = location;
        this.parse(inStream);
        this.xdcDescription = new T1XDCFontDescription();
    }

    public MetricFile getMetricFile() {
        return this.metricFile;
    }

    public URL getFontLocation() {
        return this.fontLocation;
    }

    private boolean pickFromEqualMetricFiles(MetricFile alternative) {
        if (this.metricFile instanceof AFM && alternative instanceof PFM) {
            this.metricFile = alternative;
            return true;
        }
        return false;
    }

    private void removeLastFileFromPath(StringBuffer path) {
        for (int i = path.length() - 1; i >= 0; --i) {
            if (path.charAt(i) != '/') continue;
            path.delete(i, path.length());
            return;
        }
    }

    public boolean setMetricFile(MetricFile f) {
        if (this.metricFile == null) {
            this.metricFile = f;
            return true;
        }
        StringBuffer currPath = new StringBuffer(this.metricFile.getLocation().getPath());
        StringBuffer fPath = new StringBuffer(f.getLocation().getPath());
        if (this.fontLocation == null) {
            return this.pickFromEqualMetricFiles(f);
        }
        StringBuffer fontPath = new StringBuffer(this.fontLocation.getPath());
        this.removeLastFileFromPath(fontPath);
        for (int i = 0; i < 2; ++i) {
            this.removeLastFileFromPath(currPath);
            this.removeLastFileFromPath(fPath);
            if (currPath.length() == fontPath.length() && SubArrays.stringBufferCompare(currPath, 0, fontPath, 0, fontPath.length())) {
                if (fPath.length() == fontPath.length() && SubArrays.stringBufferCompare(fPath, 0, fontPath, 0, fontPath.length())) {
                    return this.pickFromEqualMetricFiles(f);
                }
                return false;
            }
            if (fPath.length() != fontPath.length() || !SubArrays.stringBufferCompare(fPath, 0, fontPath, 0, fontPath.length())) continue;
            this.metricFile = f;
            return true;
        }
        return this.pickFromEqualMetricFiles(f);
    }

    private Integer parseInteger(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kINTEGER) {
            return new Integer(token.convertInteger(0));
        }
        return null;
    }

    private Double parseNumber(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kINTEGER) {
            return new Double(token.convertInteger(0));
        }
        if (token.tokenType == TokenType.kREAL) {
            return new Double(Double.parseDouble(new String(token.buff, 0, token.tokenLength)));
        }
        return null;
    }

    private byte[] parseBytes(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kSTRING) {
            byte[] retVal = new byte[token.tokenLength - 2];
            System.arraycopy(token.buff, 1, retVal, 0, token.tokenLength - 2);
            return retVal;
        }
        return new byte[0];
    }

    private String parseString(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kSTRING) {
            char[] chars = new char[token.tokenLength - 2];
            for (int i = 1; i < token.tokenLength - 1; ++i) {
                chars[i - 1] = (char)token.buff[i];
            }
            return new String(chars);
        }
        return null;
    }

    private String parseName(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kSTRING) {
            return token.stringTokenToString(1, token.tokenLength - 1);
        }
        if (token.tokenType == TokenType.kLITERAL) {
            return token.stringTokenToString(1, token.tokenLength);
        }
        return null;
    }

    private Boolean parseBool(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kOPERATOR) {
            if (SubArrays.arrayCompare(token.buff, 0, Operators.kTRUE, 0, Operators.kTRUE.length)) {
                return true;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Operators.kFALSE, 0, Operators.kFALSE.length)) {
                return false;
            }
        }
        return null;
    }

    private OrigFontType parseOrigFontType(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kLITERAL) {
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kTRUETYPE_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kTRUETYPE;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kTYPE1_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kTYPE1;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kCID_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kCID;
            }
            if (SubArrays.arrayCompare(token.buff, 0, Literals.kOCF_LITERAL, 0, token.tokenLength)) {
                return OrigFontType.kOCF;
            }
        }
        return null;
    }

    private int[] parseIntArray(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kARRAY || token.tokenType == TokenType.kPROCEDURE) {
            int[] array = new int[17];
            int validEntries = 0;
            boolean inNumber = false;
            block4: for (int i = 0; i < token.tokenLength; ++i) {
                switch (token.buff[i]) {
                    default: {
                        inNumber = false;
                        continue block4;
                    }
                    case 43: 
                    case 45: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (inNumber) continue block4;
                        array[validEntries++] = token.convertInteger(i);
                        inNumber = true;
                    }
                    case 35: 
                }
            }
            if (validEntries > 0) {
                int[] retArray = new int[validEntries];
                System.arraycopy(array, 0, retArray, 0, validEntries);
                return retArray;
            }
        }
        return new int[0];
    }

    private double[] parseNumArray(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType == TokenType.kARRAY || token.tokenType == TokenType.kPROCEDURE) {
            double[] array = new double[65];
            int validEntries = 0;
            for (int i = 0; i < token.tokenLength; ++i) {
                switch (token.buff[i]) {
                    case 43: 
                    case 45: 
                    case 46: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        int j;
                        boolean endOfNumber = false;
                        block9: for (j = i + 1; j < token.tokenLength && !endOfNumber; ++j) {
                            switch (token.buff[j]) {
                                case 43: 
                                case 45: 
                                case 46: 
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: 
                                case 69: 
                                case 101: {
                                    continue block9;
                                }
                                default: {
                                    endOfNumber = true;
                                }
                            }
                        }
                        String doubleString = new String(token.buff, i, j - i - 1, "US-ASCII");
                        try {
                            array[validEntries++] = Double.parseDouble(doubleString);
                        }
                        catch (NumberFormatException e) {
                            throw new InvalidFontException(e);
                        }
                        i = j - 1;
                    }
                }
            }
            if (validEntries > 0) {
                double[] retArray = new double[validEntries];
                System.arraycopy(array, 0, retArray, 0, validEntries);
                return retArray;
            }
        }
        return new double[0];
    }

    private void parseEncoding(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (SubArrays.arrayCompare(token.buff, 0, Operators.kSTANDARDENCODING, 0, Operators.kSTANDARDENCODING.length)) {
            this.keyVal.put(Type1Keys.StandardEncoding, true);
            return;
        }
        byte[][] customEncoding = new byte[256][];
        for (int i = 0; i < 256; ++i) {
            customEncoding[i] = Operators.kNOTDEF;
        }
        while (true) {
            if (SubArrays.arrayCompare(token.buff, 0, Operators.kDUP, 0, Operators.kDUP.length)) {
                int code;
                token = tokenizer.getNextPSToken();
                if (token.tokenType != TokenType.kINTEGER || (code = token.convertInteger(0)) < 0 || code > 255) continue;
                token = tokenizer.getNextPSToken();
                if (token.tokenType != TokenType.kLITERAL) continue;
                byte[] glyphName = new byte[token.tokenLength - 1];
                System.arraycopy(token.buff, 1, glyphName, 0, glyphName.length);
                token = tokenizer.getNextPSToken();
                if (!SubArrays.arrayCompare(token.buff, 0, Operators.kPUT, 0, Operators.kPUT.length)) continue;
                customEncoding[code] = glyphName;
            } else if (SubArrays.arrayCompare(token.buff, 0, Operators.kDEF, 0, Operators.kDEF.length) || SubArrays.arrayCompare(token.buff, 0, Operators.kREADONLY, 0, Operators.kREADONLY.length)) {
                this.keyVal.put(Type1Keys.Encoding, customEncoding);
                return;
            }
            token = tokenizer.getNextPSToken();
        }
    }

    private int readCharStringLen(Tokenizer tokenizer) throws IOException, InvalidFontException {
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kINTEGER) {
            return 0;
        }
        int length = token.convertInteger(0);
        if (length < 1 || length > 65535) {
            return 0;
        }
        token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kOPERATOR) {
            return 0;
        }
        return length;
    }

    private void readLenIVBytes(byte[] lenIVBytes, Tokenizer tokenizer) throws IOException, InvalidFontException {
        tokenizer.read();
        for (int i = 0; i < lenIVBytes.length; ++i) {
            lenIVBytes[i] = (byte)tokenizer.read();
        }
    }

    private byte[] readCharString(Tokenizer tokenizer, int length) throws IOException, InvalidFontException {
        byte[] cstr = new byte[length];
        for (int i = 0; i < length; ++i) {
            cstr[i] = (byte)tokenizer.read();
        }
        return cstr;
    }

    private void decryptCharString(byte[] lenIVBytes, byte[] cipher, byte[] plain) {
        int i;
        int r = 4330;
        for (i = 0; i < lenIVBytes.length; ++i) {
            r = ((lenIVBytes[i] & 0xFF) + r) * 52845 + 22719 & 0xFFFF;
        }
        for (i = 0; i < cipher.length; ++i) {
            int c1 = cipher[i] & 0xFF;
            plain[i] = (byte)(c1 ^ r >> 8);
            r = (c1 + r) * 52845 + 22719 & 0xFFFF;
        }
    }

    private void parseChars(Tokenizer tokenizer) throws IOException, InvalidFontException {
        boolean foundNotdef = false;
        byte[] lenIVBytes = null;
        byte[] replacementName = new byte[]{32};
        Object val = this.keyVal.get(Type1Keys.lenIV);
        int lenIV = val == null ? 4 : (Integer)val;
        if (lenIV >= 0) {
            lenIVBytes = new byte[lenIV];
        }
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kINTEGER) {
            return;
        }
        int numChars = token.convertInteger(0);
        if (numChars < 0) {
            return;
        }
        ArrayList<Type1Glyph> foundCharStrings = new ArrayList<Type1Glyph>(numChars);
        tokenizer.findToken(Operators.kBEGIN);
        for (int i = 0; i < numChars && !(token = tokenizer.getNextPSToken()).matches(Operators.kEND); ++i) {
            byte[] glyphName;
            if (token.tokenType != TokenType.kLITERAL) continue;
            if (token.tokenLength > 1) {
                glyphName = new byte[token.tokenLength - 1];
                System.arraycopy(token.buff, 1, glyphName, 0, token.tokenLength - 1);
            } else {
                glyphName = replacementName;
            }
            int length = this.readCharStringLen(tokenizer) - (lenIVBytes != null ? lenIV : 0);
            if (length < 1 || length > 65535) continue;
            if (lenIVBytes != null) {
                this.readLenIVBytes(lenIVBytes, tokenizer);
            }
            byte[] cstr = this.readCharString(tokenizer, length);
            if (lenIVBytes != null) {
                this.decryptCharString(lenIVBytes, cstr, cstr);
            }
            if (glyphName.length == Literals.kNOTDEF.length && SubArrays.arrayCompare(glyphName, 0, Literals.kNOTDEF, 0, Literals.kNOTDEF.length)) {
                foundNotdef = true;
            }
            foundCharStrings.add(new Type1Glyph(glyphName, cstr));
            token = tokenizer.getNextPSToken();
        }
        if (!foundNotdef) {
            byte[] notdefCharstring = new byte[]{-117, -9, -114, 13, 14};
            foundCharStrings.add(new Type1Glyph(Literals.kNOTDEF, notdefCharstring));
        }
        this.charStrings = new Type1Glyph[foundCharStrings.size()];
        foundCharStrings.toArray(this.charStrings);
        Arrays.sort(this.charStrings, CharstringCompare.comparator);
    }

    private void parseSubrs(Tokenizer tokenizer) throws IOException, InvalidFontException {
        byte[] lenIVBytes = null;
        Object val = this.keyVal.get(Type1Keys.lenIV);
        int lenIV = val == null ? 4 : (Integer)val;
        Token token = tokenizer.getNextPSToken();
        if (token.tokenType != TokenType.kINTEGER) {
            return;
        }
        int cnt = token.convertInteger(0);
        if (cnt < 0 || cnt > 65535) {
            return;
        }
        this.subrs = new byte[cnt][];
        if (lenIV >= 0) {
            lenIVBytes = new byte[lenIV];
        }
        tokenizer.findToken(Operators.kARRAY);
        int i = 0;
        while (true) {
            if (!(token = tokenizer.getNextPSToken()).matches(Operators.kDUP)) {
                return;
            }
            token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kINTEGER) {
                return;
            }
            int subrNumber = token.convertInteger(0);
            if (subrNumber < 0 || subrNumber >= cnt) {
                return;
            }
            int length = this.readCharStringLen(tokenizer) - (lenIVBytes != null ? lenIV : 0);
            if (lenIVBytes != null) {
                this.readLenIVBytes(lenIVBytes, tokenizer);
            }
            byte[] cstr = this.readCharString(tokenizer, length);
            if (lenIVBytes != null) {
                this.decryptCharString(lenIVBytes, cstr, cstr);
            }
            this.subrs[subrNumber] = cstr;
            token = tokenizer.getNextPSToken();
            if (token.tokenType != TokenType.kOPERATOR) {
                return;
            }
            if (token.matches(Operators.kNOACCESS)) {
                token = tokenizer.getNextPSToken();
                if (token.tokenType != TokenType.kOPERATOR) break;
            }
            ++i;
        }
    }

    private void parseFontMatrix(Tokenizer tokenizer) throws IOException, InvalidFontException {
        double[] arg = this.parseNumArray(tokenizer);
        if (arg.length == 6 && (arg[0] != 0.001 || arg[1] != 0.0 || arg[2] != 0.0 || arg[3] != 0.001 || arg[4] != 0.0 || arg[5] != 0.0)) {
            if (arg[4] != 0.0 || arg[5] != 0.0) {
                throw new InvalidFontException("non-zero translation components in the font matrix");
            }
            double det = arg[0] * arg[3] - arg[2] * arg[1];
            double absDet = Math.abs(det);
            if (absDet < 1.0) {
                double mx = Double.MAX_VALUE * absDet;
                if (Math.abs(arg[0]) >= mx || Math.abs(arg[1]) >= mx || Math.abs(arg[2]) >= mx || Math.abs(arg[3]) >= mx) {
                    throw new InvalidFontException("non-invertible font matrix");
                }
            }
            this.currentMap.put(Type1Keys.FontMatrix, new Matrix(arg));
            Matrix inverse = new Matrix(arg[3] / det, -arg[1] / det, -arg[2] / det, arg[0] / det, 0.0, 0.0);
            this.currentMap.put(Type1Keys.InvertedFontMatrix, inverse);
        }
    }

    private void parseErodeProc(Tokenizer tokenizer) throws IOException, InvalidFontException {
        if (this.keyVal.get(Type1Keys.StdVW) != null) {
            return;
        }
        Token token = tokenizer.getNextPSToken();
        int currToken = 0;
        if (token.tokenType == TokenType.kPROCEDURE) {
            for (int currPos = 1; currPos < token.tokenLength; ++currPos) {
                while (currPos < token.tokenLength && Tokenizer.isWhite(token.buff[currPos])) {
                    ++currPos;
                }
                if (currPos == token.tokenLength || token.buff[currPos] == 125) break;
                if (++currToken == 16) {
                    Double stdvw = new Double(token.convertInteger(currPos));
                    this.keyVal.put(Type1Keys.StdVW, stdvw);
                    break;
                }
                while (currPos < token.tokenLength && !Tokenizer.isWhite(token.buff[currPos])) {
                    ++currPos;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doLiteral(Tokenizer tokenizer, Token currToken) throws IOException, InvalidFontException, UnsupportedFontException {
        String theLiteral = new String(currToken.buff, 1, currToken.tokenLength - 1, "ISO-8859-1");
        ArgumentType argType = (ArgumentType)literals.get(theLiteral);
        if (argType == null) {
            return false;
        }
        if (argType == ArgumentType.kBOOL) {
            Boolean arg = this.parseBool(tokenizer);
            if (arg == null) return false;
            this.keyVal.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kSTRING) {
            String arg = this.parseString(tokenizer);
            if (arg == null) return false;
            this.currentMap.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kBYTES) {
            byte[] arg = this.parseBytes(tokenizer);
            if (arg.length == 0) return false;
            this.keyVal.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kNAME) {
            String arg = this.parseName(tokenizer);
            if (arg == null) return false;
            this.currentMap.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kNUMARRAY) {
            double[] arg = this.parseNumArray(tokenizer);
            if (arg.length == 0) return false;
            this.keyVal.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kBBOX) {
            double[] arg = this.parseNumArray(tokenizer);
            if (arg.length != 4) return false;
            this.keyVal.put(theLiteral, new Rect(arg[0], arg[1], arg[2], arg[3]));
            return false;
        } else if (argType == ArgumentType.kINTARRAY) {
            int[] arg = this.parseIntArray(tokenizer);
            if (arg.length == 0) return false;
            this.keyVal.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kINTEGER) {
            Integer arg = this.parseInteger(tokenizer);
            if (arg == null) return false;
            this.keyVal.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kNUMBER) {
            Double arg = this.parseNumber(tokenizer);
            if (arg == null) return false;
            this.keyVal.put(theLiteral, arg);
            return false;
        } else if (argType == ArgumentType.kARRAYOF1) {
            double[] arg = this.parseNumArray(tokenizer);
            if (arg.length != 1) return false;
            this.keyVal.put(theLiteral, new Double(arg[0]));
            return false;
        } else if (argType == ArgumentType.kITALICANGLE) {
            Double arg = this.parseNumber(tokenizer);
            if (arg == null) return false;
            this.currentMap.put(theLiteral, arg);
            return false;
        } else {
            if (argType == ArgumentType.kCHARSTRINGS) {
                this.parseChars(tokenizer);
                return true;
            }
            if (argType == ArgumentType.kSUBRS) {
                this.parseSubrs(tokenizer);
                return false;
            } else if (argType == ArgumentType.kERODE) {
                this.parseErodeProc(tokenizer);
                return false;
            } else if (argType == ArgumentType.kFONTTYPE) {
                Integer arg = this.parseInteger(tokenizer);
                if (arg == null || arg != 1) throw new UnsupportedFontException("Fonttype not supported");
                this.keyVal.put(theLiteral, arg);
                return false;
            } else if (argType == ArgumentType.kORIGFONTTYPE) {
                OrigFontType arg = this.parseOrigFontType(tokenizer);
                if (arg == null) return false;
                this.keyVal.put(theLiteral, arg);
                return false;
            } else if (argType == ArgumentType.kENCODING) {
                this.parseEncoding(tokenizer);
                return false;
            } else if (argType == ArgumentType.kFONTMATRIX) {
                this.parseFontMatrix(tokenizer);
                return false;
            } else if (argType == ArgumentType.kRNDSTEMUP) {
                this.keyVal.put(Type1Keys.LanguageGroup, new Integer(1));
                return false;
            } else if (argType == ArgumentType.kPRIVATE) {
                this.seenPrivate = true;
                return false;
            } else {
                if (argType != ArgumentType.kUNSUPPORTEDFONT) return false;
                throw new UnsupportedFontException("unsupported fonttype");
            }
        }
    }

    private void setupEexec(Tokenizer tokenizer) throws IOException, InvalidFontException {
        int i;
        boolean binaryCipher = false;
        byte[] randomSeed = new byte[8];
        int nextByte = tokenizer.read();
        for (i = 0; i < 4; ++i) {
            nextByte = tokenizer.read();
            if (!Tokenizer.isHex(nextByte) && nextByte != 32 && nextByte != 9 && nextByte != 10 && nextByte != 13) {
                binaryCipher = true;
            }
            randomSeed[i] = (byte)nextByte;
        }
        if (binaryCipher) {
            BinaryEexecReader newReader = new BinaryEexecReader();
            newReader.decryptBuffer(randomSeed, 4);
            tokenizer.setReader(newReader);
        } else {
            while (Tokenizer.isWhite(randomSeed[0])) {
                for (i = 0; i < 3; ++i) {
                    randomSeed[i] = randomSeed[i + 1];
                }
                nextByte = tokenizer.read();
                randomSeed[3] = (byte)nextByte;
            }
            for (i = 4; i < 8; ++i) {
                nextByte = tokenizer.read();
                randomSeed[i] = (byte)nextByte;
            }
            AsciiEexecReader newReader = new AsciiEexecReader();
            newReader.decryptBuffer(randomSeed, 8);
            tokenizer.setReader(newReader);
        }
    }

    private void doOperator(Tokenizer tokenizer, Token lastToken) throws IOException, InvalidFontException {
        if (SubArrays.arrayCompare(lastToken.buff, 0, Operators.kCURRENTFILE, 0, Operators.kCURRENTFILE.length)) {
            Token token = tokenizer.getNextPSToken();
            if (SubArrays.arrayCompare(token.buff, 0, Operators.kEEXEC, 0, Operators.kEEXEC.length)) {
                this.setupEexec(tokenizer);
            }
        } else if (this.seenPrivate && SubArrays.arrayCompare(lastToken.buff, 0, Operators.kFONTDIRECTORY, 0, Operators.kCURRENTFILE.length)) {
            this.syntheticBaseMap = new HashMap();
            this.currentMap = this.syntheticBaseMap;
        }
    }

    private void parse(FontInputStream in) throws IOException, InvalidFontException, UnsupportedFontException {
        int firstByte = in.read();
        in.unread(firstByte);
        if (firstByte == 128) {
            in = new PFBInputStream(in);
        }
        this.seenPrivate = false;
        Tokenizer tokenizer = new Tokenizer(in);
        while (true) {
            Token currToken = tokenizer.getNextPSToken();
            if (currToken.tokenType == TokenType.kLITERAL) {
                if (!this.doLiteral(tokenizer, currToken)) continue;
                break;
            }
            if (currToken.tokenType != TokenType.kOPERATOR) continue;
            this.doOperator(tokenizer, currToken);
        }
        Object o = this.keyVal.get(Type1Keys.FullName);
        if (o != null) {
            String s = (String)o;
            this.keyVal.put(Type1Keys.CSSWeight, new Integer(NameHeuristics.fullNameToWeight(s)));
            this.keyVal.put(Type1Keys.CSSWidth, NameHeuristics.fullNameToWidth(s, (String)this.keyVal.get("FamilyName")));
            this.keyVal.put(Type1Keys.IsSmallCaps, NameHeuristics.fullNameIndicatesSmallCaps(s));
        }
    }

    Object getValue(String key) {
        return this.keyVal.get(key);
    }

    public int glyphName2gid(String glyphName) {
        Type1Glyph tmp = new Type1Glyph(glyphName);
        int index = Arrays.binarySearch(this.charStrings, tmp, CharstringCompare.comparator);
        if (index < 0) {
            return 0;
        }
        if (this.charStrings[index].glyphName.equals(glyphName)) {
            return index;
        }
        return 0;
    }

    public String charCode2GlyphName(int charCode) {
        Object o = this.getValue(Type1Keys.StandardEncoding);
        if (o != null && ((Boolean)o).booleanValue()) {
            if (0 <= charCode && charCode < StandardEncoding.names.length) {
                return StandardEncoding.names[charCode];
            }
            return ".notdef";
        }
        o = this.getValue(Type1Keys.Encoding);
        if (o != null) {
            byte[][] encoding = (byte[][])o;
            byte[] glyphName = encoding[charCode];
            return this.bytesToString(glyphName);
        }
        return ".notdef";
    }

    public int charCode2gid(int charCode) {
        return this.glyphName2gid(this.charCode2GlyphName(charCode));
    }

    @Override
    public int getNumGlyphs() {
        return this.charStrings.length;
    }

    byte[] getCharstring(int glyphID) {
        return this.charStrings[glyphID].charString;
    }

    public ROS getROS() {
        return null;
    }

    public String getGlyphName(int glyphID) {
        return this.charStrings[glyphID].glyphName;
    }

    int getNumSubrs() {
        return this.subrs.length;
    }

    byte[] getSubr(int subrNumber) {
        return this.subrs[subrNumber];
    }

    public String getPostscriptName() {
        Object o = this.getValue(Type1Keys.FontName);
        if (o != null) {
            return (String)o;
        }
        return null;
    }

    public double getStemV() {
        Object o = (Double)this.getValue(Type1Keys.StdVW);
        if (o != null) {
            return (Double)o * this.getFontMatrix().a * this.getUnitsPerEmX();
        }
        o = (double[])this.getValue(Type1Keys.StemSnapV);
        if (o != null && ((Object)o).length != 0) {
            return (double)(o[0] * this.getFontMatrix().a * this.getUnitsPerEmX());
        }
        return 0.0;
    }

    public Matrix getFontMatrix() {
        Matrix m = (Matrix)this.getValue(Type1Keys.FontMatrix);
        if (m != null) {
            return m;
        }
        return defaultFontMatrix;
    }

    @Override
    public double getUnitsPerEmX() {
        return 1.0 / this.getFontMatrix().a;
    }

    @Override
    public double getUnitsPerEmY() {
        return 1.0 / this.getFontMatrix().d;
    }

    private Matrix getFontToMetricsMatrix() {
        Matrix m = this.getFontMatrix();
        double x = this.getUnitsPerEmX();
        double y = this.getUnitsPerEmY();
        return new Matrix(x * m.a, y * m.b, x * m.c, y * m.d, x * m.tx, y * m.ty);
    }

    @Override
    public Rect getFontBBox() {
        Rect rawBBox = (Rect)this.getValue("FontBBox");
        if (rawBBox == null) {
            return null;
        }
        return rawBBox.applyMatrix(this.getFontToMetricsMatrix());
    }

    @Override
    public Rect getCoolTypeRawFontBBox() {
        return this.getFontBBox();
    }

    @Override
    public CoolTypeScript getCoolTypeScript() throws UnsupportedFontException, InvalidFontException {
        return ScriptHeuristics.getCoolTypeScript(this.getPostscriptName(), 256, new GlyphNamesAccessor(){

            @Override
            public String getAGlyphName(int ccode) throws UnsupportedFontException, InvalidFontException {
                return Type1Font.this.charCode2GlyphName(ccode);
            }
        });
    }

    private Rect getCoolTypeIdeoEmBoxFromCapHeight() throws InvalidFontException, UnsupportedFontException {
        double capHeight = this.getCoolTypeCapHeight();
        if (Double.isNaN(capHeight)) {
            return null;
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        double ymin = -(unitsPerEmY - capHeight) / 2.0;
        return new Rect(0.0, ymin, unitsPerEmX, ymin + unitsPerEmY);
    }

    @Override
    public Rect getCoolTypeIdeoEmBox() throws InvalidFontException, UnsupportedFontException {
        if (this.useCoolTypeCJKHeuristics()) {
            Rect r = this.getCoolTypeIdeoEmBoxFromFullBoxCharacter();
            if (r != null) {
                return r;
            }
            r = this.getCoolTypeIdeoEmBoxFromTypicalCharacter();
            if (r != null) {
                return r;
            }
        } else {
            Rect r = this.getCoolTypeIdeoEmBoxFromCapHeight();
            if (r != null) {
                return r;
            }
        }
        double unitsPerEmX = this.getUnitsPerEmX();
        double unitsPerEmY = this.getUnitsPerEmY();
        return new Rect(0.0, -0.12 * unitsPerEmY, unitsPerEmX, 0.88 * unitsPerEmY);
    }

    @Override
    public Rect getCoolTypeIcfBox() throws InvalidFontException, UnsupportedFontException {
        Rect ideoEmBox = this.getCoolTypeIdeoEmBox();
        Rect r = this.getCoolTypeIcfBoxFromTypicalCharacter(ideoEmBox);
        if (r != null) {
            return r;
        }
        return this.getCoolTypeIcfBoxFromIdeoEmBox(ideoEmBox);
    }

    @Override
    public LineMetrics getCoolTypeLineMetrics() throws UnsupportedFontException, InvalidFontException {
        return this.getCoolTypeLineMetricsFromFontBbox();
    }

    @Override
    public UnderlineMetrics getCoolTypeUnderlineMetrics() throws UnsupportedFontException, InvalidFontException {
        double position = -150.0;
        Object o = this.getValue("UnderlinePosition");
        if (o != null) {
            position = (Double)o;
        }
        double thickness = 50.0;
        o = this.getValue("UnderlineThickness");
        if (o != null) {
            thickness = (Double)o;
        }
        double cooltypeUnitsPerEm = this.getCoolTypeUnitsPerEm();
        double unitsPerEmY = this.getUnitsPerEmY();
        return new UnderlineMetrics(position * unitsPerEmY / cooltypeUnitsPerEm, thickness * unitsPerEmY / cooltypeUnitsPerEm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getFirstChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getFirstSupportedChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLastChar() throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getLastSupportedChar();
        }
    }

    private boolean isDingbat() {
        Object o = this.getValue(Type1Keys.FullName);
        return NameHeuristics.fullNameIndicatesDingbats(o != null ? (String)o : null);
    }

    private void initCmap() throws InvalidFontException, UnsupportedFontException {
        if (this.cmap == null) {
            this.cmap = UnicodeCmap.computeCmapFromGlyphNames(this.getNumGlyphs(), this.isDingbat(), new GlyphNamesAccessor(){

                @Override
                public String getAGlyphName(int gid) throws UnsupportedFontException, InvalidFontException {
                    return Type1Font.this.getGlyphName(gid);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGlyphForChar(int usv) throws InvalidFontException, UnsupportedFontException {
        Object object = this.cmapMutex;
        synchronized (object) {
            this.initCmap();
            return this.cmap.getGlyphForChar(usv);
        }
    }

    @Override
    public double getHorizontalAdvance(int glyphID) throws InvalidGlyphException, UnsupportedFontException {
        Type1WidthFetcher fetcher = new Type1WidthFetcher();
        Type1CStringParser parser = new Type1CStringParser();
        parser.parse(fetcher, this, glyphID);
        return fetcher.getWidth() * (this.getFontMatrix().a * this.getUnitsPerEmX());
    }

    public double getKernValue(int leftGID, int rightGID) throws InvalidFontException, UnsupportedFontException {
        if (this.metricFile == null) {
            return 0.0;
        }
        double rawKernValue = this.metricFile.getKernValue(this.getGlyphName(leftGID), this.getGlyphName(rightGID));
        return rawKernValue * this.getUnitsPerEmX() / 1000.0;
    }

    @Override
    public void getGlyphOutline(int gid, OutlineConsumer consumer) throws InvalidFontException, UnsupportedFontException {
        Type1OutlineParser parser = new Type1OutlineParser();
        parser.parse(this, gid, consumer);
    }

    @Override
    public Rect getGlyphBBox(int gid) throws UnsupportedFontException, InvalidFontException {
        Matrix m = new Matrix(this.getUnitsPerEmX(), 0.0, 0.0, this.getUnitsPerEmY(), 0.0, 0.0);
        return new Type1GlyphBBoxCalculator(m).calculateBBox(this, gid);
    }

    @Override
    public Scaler getScaler(ScanConverter c) throws InvalidFontException, UnsupportedFontException {
        if (c == null) {
            c = new CScan(false, 1.0, true);
        }
        return new Type1Scaler(this, c);
    }

    @Override
    public Set getCSSFamilyNames() {
        Object o;
        HashSet<Object> s = new HashSet<Object>();
        String familyName = null;
        if (this.metricFile != null && (familyName = this.metricFile.getFamilyName()) != null) {
            s.add(familyName);
        }
        if ((o = this.getValue(Type1Keys.FamilyName)) != null) {
            s.add(o);
        }
        return s;
    }

    @Override
    public String getPreferredCSSFamilyName() {
        String familyName;
        if (this.metricFile != null && (familyName = this.metricFile.getFamilyName()) != null) {
            return familyName;
        }
        Object o = this.getValue(Type1Keys.FamilyName);
        if (o != null) {
            return (String)o;
        }
        return null;
    }

    @Override
    public boolean isCSSStyleNormal() {
        if (this.metricFile != null && this.metricFile instanceof PFM) {
            return !((PFM)this.metricFile).isItalic();
        }
        Object o = this.getValue(Type1Keys.ItalicAngle);
        if (o == null) {
            return true;
        }
        Double d = (Double)o;
        return d == 0.0;
    }

    @Override
    public boolean isCSSStyleItalic() {
        return !this.isCSSStyleNormal();
    }

    @Override
    public boolean isCSSStyleOblique() {
        return !this.isCSSStyleNormal();
    }

    @Override
    public boolean isCSSVariantNormal() {
        Object o = this.getValue(Type1Keys.IsSmallCaps);
        if (o != null) {
            return (Boolean)o == false;
        }
        return true;
    }

    @Override
    public boolean isCSSVariantSmallCaps() {
        Object o = this.getValue(Type1Keys.IsSmallCaps);
        if (o != null) {
            return (Boolean)o;
        }
        return false;
    }

    @Override
    public int getCSSWeight() {
        int retval;
        if (this.metricFile != null && (retval = this.metricFile.getWeight()) != 0) {
            return retval;
        }
        Object o = this.getValue(Type1Keys.CSSWeight);
        if (o != null) {
            return (Integer)o;
        }
        return 400;
    }

    @Override
    public CSS20Attribute.CSSStretchValue getCSSStretchValue() {
        Object o = this.getValue(Type1Keys.CSSWidth);
        if (o != null) {
            return (CSS20Attribute.CSSStretchValue)o;
        }
        return CSS20Attribute.CSSStretchValue.NORMAL;
    }

    @Override
    public CacheSupportInfo getCacheSupportInfo() throws InvalidFontException, UnsupportedFontException {
        return new CacheSupportInfo(this.getClass().getSimpleName(), this.getNumGlyphs(), false);
    }

    @Override
    public PostscriptFontDescription[] getPostscriptFontDescription() {
        String s = this.getPostscriptName();
        if (s != null) {
            return new PostscriptFontDescription[]{new PostscriptFontDescription(s)};
        }
        return new PostscriptFontDescription[0];
    }

    @Override
    public FXGFontDescription[] getFXGFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        return new FXGFontDescription[0];
    }

    @Override
    public PlatformFontDescription[] getPlatformFontDescription(Platform platform, ULocale locale) throws InvalidFontException, UnsupportedFontException {
        return new PlatformFontDescription[0];
    }

    @Override
    public PDFFontDescription getPDFFontDescription(Font font) {
        return this.xdcDescription;
    }

    @Override
    public XDCFontDescription getXDCFontDescription(Font font) {
        return this.xdcDescription;
    }

    @Override
    public boolean getCoolTypeProportionalRomanFromFontProperties() throws InvalidFontException {
        Boolean o = (Boolean)this.getValue(Type1Keys.isFixedPitch);
        if (o != null) {
            return o == false;
        }
        return true;
    }

    @Override
    public Permission getEmbeddingPermission(boolean wasEmbedded) {
        Integer fsType = (Integer)this.getValue(Type1Keys.FSType);
        if (fsType != null) {
            return EmbeddingPermission.interpretFSType(fsType);
        }
        OrigFontType oft = (OrigFontType)this.getValue(Type1Keys.OrigFontType);
        if (oft == null || oft == OrigFontType.kTYPE1) {
            String name = this.getPostscriptName();
            byte[] tmp = (byte[])this.getValue(Type1Keys.Notice);
            String notice = tmp == null ? null : this.bytesToString(tmp);
            return EmbeddingPermission.getType1DefaultPermission(notice, name);
        }
        if (wasEmbedded) {
            return EmbeddingPermission.getDefaultWasEmbeddedPermission();
        }
        if (oft == OrigFontType.kCID) {
            int[] v = (int[])this.getValue(Type1Keys.XUID);
            return EmbeddingPermission.getCIDDefaultPermission(v);
        }
        if (oft == OrigFontType.kTRUETYPE) {
            return EmbeddingPermission.getTrueTypeDefaultPermission();
        }
        return EmbeddingPermission.getOCFDefaultPermission();
    }

    @Override
    public Subset createSubset() throws UnsupportedFontException, InvalidFontException {
        return new Type1Subset(this, true);
    }

    private String bytesToString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return new String(chars);
    }

    private Dict createTopDict(boolean nameKeyed) throws InvalidFontException {
        Matrix fontMatrix;
        String ordering;
        String registry;
        if (nameKeyed) {
            registry = null;
            ordering = null;
            fontMatrix = (Matrix)this.getValue(Type1Keys.FontMatrix);
        } else {
            registry = "Adobe";
            ordering = "Identity";
            fontMatrix = null;
        }
        byte[] tmp = (byte[])this.getValue(Type1Keys.version);
        String version = tmp == null ? null : this.bytesToString(tmp);
        tmp = (byte[])this.getValue(Type1Keys.Notice);
        String notice = tmp == null ? null : this.bytesToString(tmp);
        tmp = (byte[])this.getValue(Type1Keys.Copyright);
        String copyright = tmp == null ? null : this.bytesToString(tmp);
        tmp = (byte[])this.getValue(Type1Keys.PostScript);
        String postscript = tmp == null ? null : this.bytesToString(tmp);
        OrigFontType oft = (OrigFontType)this.getValue(Type1Keys.OrigFontType);
        postscript = oft != null ? (postscript == null ? "/OrigFontType /" + oft.toString() + " def" : postscript + " /OrigFontType /" + oft.toString() + " def") : (postscript == null ? "/OrigFontType /Type1 def" : postscript + " /OrigFontType /Type1 def");
        String fullname = (String)this.getValue(Type1Keys.FullName);
        String familyname = (String)this.getValue(Type1Keys.FamilyName);
        String weight = (String)this.getValue(Type1Keys.Weight);
        Boolean fixedPitch = (Boolean)this.getValue(Type1Keys.isFixedPitch);
        Double italicangle = (Double)this.getValue(Type1Keys.ItalicAngle);
        Double underPos = (Double)this.getValue(Type1Keys.UnderlinePosition);
        Double underThick = (Double)this.getValue(Type1Keys.UnderlineThickness);
        Integer paintType = (Integer)this.getValue(Type1Keys.PaintType);
        Integer uniqueID = (Integer)this.getValue(Type1Keys.UniqueID);
        Rect bbox = (Rect)this.getValue(Type1Keys.FontBBox);
        Double strokewidth = (Double)this.getValue(Type1Keys.StrokeWidth);
        int[] xuid = (int[])this.getValue(Type1Keys.XUID);
        Integer fsType = (Integer)this.getValue(Type1Keys.FSType);
        int[] bfBlend = (int[])this.getValue(Type1Keys.BaseFontBlend);
        String basefontname = (String)this.getValue(Type1Keys.BaseFontName);
        String fontname = (String)this.getValue(Type1Keys.FontName);
        return new Dict(registry, ordering, 0, version, notice, copyright, fullname, fontname, familyname, weight, fixedPitch, italicangle, underPos, underThick, paintType, uniqueID, bbox, strokewidth, xuid, postscript, fsType, bfBlend, basefontname, fontMatrix);
    }

    private Dict createPrivateDict(double nominalWidth, double defaultWidth) {
        double[] blues = (double[])this.getValue(Type1Keys.BlueValues);
        double[] otherBlues = (double[])this.getValue(Type1Keys.OtherBlues);
        double[] familyBlues = (double[])this.getValue(Type1Keys.FamilyBlues);
        double[] familyOtherBlues = (double[])this.getValue(Type1Keys.FamilyOtherBlues);
        Double blueScale = (Double)this.getValue(Type1Keys.BlueScale);
        Double blueShift = (Double)this.getValue(Type1Keys.BlueShift);
        Integer bluefuzz = (Integer)this.getValue(Type1Keys.BlueFuzz);
        Double stdHW = (Double)this.getValue(Type1Keys.StdHW);
        Double stdVW = (Double)this.getValue(Type1Keys.StdVW);
        double[] stemSnapH = (double[])this.getValue(Type1Keys.StemSnapH);
        double[] stemSnapV = (double[])this.getValue(Type1Keys.StemSnapV);
        Boolean forceBold = (Boolean)this.getValue(Type1Keys.ForceBold);
        Integer langGroup = (Integer)this.getValue(Type1Keys.LanguageGroup);
        Double expansionFactor = (Double)this.getValue(Type1Keys.ExpansionFactor);
        Integer initRandSeed = (Integer)this.getValue(Type1Keys.initialRandomSeed);
        return new Dict(blues, otherBlues, familyBlues, familyOtherBlues, blueScale, blueShift, bluefuzz, stdHW, stdVW, stemSnapH, stemSnapV, forceBold, langGroup, expansionFactor, initRandSeed, new Double(nominalWidth), new Double(defaultWidth));
    }

    private Type2CStringGenerator seedGenerator(Subset subset) throws InvalidFontException, UnsupportedFontException {
        int numGlyphs = subset == null ? this.getNumGlyphs() : subset.getNumGlyphs();
        Type2CStringGenerator cstringGenerator = new Type2CStringGenerator(numGlyphs, 1);
        Type1CStringParser parser = new Type1CStringParser();
        for (int i = 0; i < numGlyphs; ++i) {
            int fullGid = subset == null ? i : subset.getFullGid(i);
            cstringGenerator.newGlyph(i, 0, 0.0, 0.0);
            parser.parse(cstringGenerator, this, fullGid);
        }
        return cstringGenerator;
    }

    private CIDKeyedFont toCID(Subset subset) throws InvalidFontException, UnsupportedFontException {
        Dict topDict = this.createTopDict(false);
        Type2CStringGenerator cstringGenerator = this.seedGenerator(subset);
        double nominalWidth = cstringGenerator.calculateNominalWidth(0);
        double defaultWidth = cstringGenerator.calculateDefaultWidth(0);
        CharStrings charstrings = cstringGenerator.getCharstringIndex();
        Matrix matrix = (Matrix)this.getValue(Type1Keys.FontMatrix);
        Dict cidDict = new Dict(matrix);
        Dict privateDict = this.createPrivateDict(nominalWidth, defaultWidth);
        String fontname = (String)this.getValue(Type1Keys.FontName);
        return new CIDKeyedFont(fontname, topDict, charstrings, subset.getNumGlyphs(), cidDict, privateDict);
    }

    @Override
    public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
        CIDKeyedFont cid = this.toCID(subset);
        Integer fsType = (Integer)this.getValue(Type1Keys.FSType);
        SubsetDefaultImpl completeSubset = new SubsetDefaultImpl(subset.getNumGlyphs(), false);
        cid.subsetAndStream(completeSubset, out, false, fsType);
    }

    private NameKeyedFont createNKFontFromSubset(Subset subset) throws InvalidFontException, UnsupportedFontException {
        Dict topDict = this.createTopDict(true);
        String fontName = (String)this.getValue(Type1Keys.FontName);
        Type2CStringGenerator cstringGenerator = this.seedGenerator(subset);
        double nominalWidth = cstringGenerator.calculateNominalWidth(0);
        double defaultWidth = cstringGenerator.calculateDefaultWidth(0);
        CharStrings charStrings = cstringGenerator.getCharstringIndex();
        Dict privateDict = this.createPrivateDict(nominalWidth, defaultWidth);
        return new NameKeyedFont(fontName, topDict, charStrings, privateDict);
    }

    public void subsetAndStream(SubsetSimpleType1 t1Subset, OutputStream out) throws InvalidFontException, UnsupportedFontException, IOException {
        Subset subset = this.createSubset();
        String[] glyphNames = t1Subset.getGlyphNames();
        for (int i = 0; i < glyphNames.length; ++i) {
            String glyphName = glyphNames[i];
            if (glyphName == null) continue;
            int gid = this.glyphName2gid(glyphName);
            if (gid == 0 && !glyphName.equals(".notdef")) {
                throw new InvalidFontException("Font does not contain required codepoint");
            }
            subset.getSubsetGid(gid);
        }
        NameKeyedFont nk = this.createNKFontFromSubset(subset);
        Integer fsType = (Integer)this.getValue(Type1Keys.FSType);
        nk.subsetAndStream(subset, out, fsType, false, new FetchGNameFromT1Subset(t1Subset));
    }

    public void stream(OutputStream out, boolean openTypeOk) throws InvalidFontException, UnsupportedFontException, IOException {
        Type1Subset subset = new Type1Subset(this, false);
        NameKeyedFont nk = this.createNKFontFromSubset(subset);
        Integer fsType = (Integer)this.getValue(Type1Keys.FSType);
        nk.subsetAndStream((Subset)subset, out, fsType, false, new NameKeyedFont.GlyphNameFetcher(){

            @Override
            public String getGlyphName(Subset s, int i) {
                return Type1Font.this.getGlyphName(i);
            }
        });
    }

    @Override
    public CatalogDescription getSelectionDescription() throws InvalidFontException, UnsupportedFontException {
        String n;
        String familyName;
        HashSet<String> s = new HashSet<String>();
        String bestName = null;
        if (this.metricFile != null && (familyName = this.metricFile.getFamilyName()) != null) {
            bestName = familyName;
            s.add(familyName);
        }
        if ((n = (String)this.getValue(Type1Keys.FullName)) != null) {
            bestName = n;
            s.add(n);
        }
        return new CatalogDescription("T1", s, bestName, "");
    }

    @Override
    public SWFFontDescription getSWFFontDescription(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return new T1SWFFont3Description(wasEmbedded);
    }

    @Override
    public SWFFont4Description getSWFFont4Description(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
        return null;
    }

    static {
        defaultFontMatrix = new Matrix(0.001, 0.0, 0.0, 0.001, 0.0, 0.0);
        defaultKernValue = new double[]{0.0, 0.0};
        literals = new HashMap(72);
        literals.put(Type1Keys.BaseFontBlend, ArgumentType.kINTARRAY);
        literals.put(Type1Keys.BaseFontName, ArgumentType.kNAME);
        literals.put(Type1Keys.Blend, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.BlendDesignMap, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.BlendDesignPositions, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.BlueFuzz, ArgumentType.kINTEGER);
        literals.put(Type1Keys.BlueScale, ArgumentType.kNUMBER);
        literals.put(Type1Keys.BlueShift, ArgumentType.kNUMBER);
        literals.put(Type1Keys.BlueValues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.CIDInit, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.Chameleon, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.CharStrings, ArgumentType.kCHARSTRINGS);
        literals.put(Type1Keys.Copyright, ArgumentType.kBYTES);
        literals.put(Type1Keys.Encoding, ArgumentType.kENCODING);
        literals.put(Type1Keys.Erode, ArgumentType.kERODE);
        literals.put(Type1Keys.ExpansionFactor, ArgumentType.kNUMBER);
        literals.put(Type1Keys.FSType, ArgumentType.kINTEGER);
        literals.put(Type1Keys.FamilyBlues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.FamilyName, ArgumentType.kSTRING);
        literals.put(Type1Keys.FamilyOtherBlues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.FontBBox, ArgumentType.kBBOX);
        literals.put(Type1Keys.FontMatrix, ArgumentType.kFONTMATRIX);
        literals.put(Type1Keys.FontName, ArgumentType.kNAME);
        literals.put(Type1Keys.FontType, ArgumentType.kFONTTYPE);
        literals.put(Type1Keys.ForceBold, ArgumentType.kBOOL);
        literals.put(Type1Keys.ForceBoldThreshold, ArgumentType.kNUMBER);
        literals.put(Type1Keys.FullName, ArgumentType.kSTRING);
        literals.put(Type1Keys.GlyphDirectory, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.ItalicAngle, ArgumentType.kITALICANGLE);
        literals.put(Type1Keys.LanguageGroup, ArgumentType.kINTEGER);
        literals.put(Type1Keys.Notice, ArgumentType.kBYTES);
        literals.put(Type1Keys.OrigFontType, ArgumentType.kORIGFONTTYPE);
        literals.put(Type1Keys.OtherBlues, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.PaintType, ArgumentType.kINTEGER);
        literals.put(Type1Keys.Private, ArgumentType.kPRIVATE);
        literals.put(Type1Keys.PostScript, ArgumentType.kBYTES);
        literals.put(Type1Keys.RndStemUp, ArgumentType.kRNDSTEMUP);
        literals.put(Type1Keys.StdHW, ArgumentType.kARRAYOF1);
        literals.put(Type1Keys.StdVW, ArgumentType.kARRAYOF1);
        literals.put(Type1Keys.StemSnapH, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.StemSnapV, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.StrokeWidth, ArgumentType.kNUMBER);
        literals.put(Type1Keys.Subrs, ArgumentType.kSUBRS);
        literals.put(Type1Keys.UnderlinePosition, ArgumentType.kNUMBER);
        literals.put(Type1Keys.UnderlineThickness, ArgumentType.kNUMBER);
        literals.put(Type1Keys.UniqueID, ArgumentType.kINTEGER);
        literals.put(Type1Keys.WasEmbedded, ArgumentType.kBOOL);
        literals.put(Type1Keys.Weight, ArgumentType.kSTRING);
        literals.put(Type1Keys.WeightVector, ArgumentType.kNUMARRAY);
        literals.put(Type1Keys.XUID, ArgumentType.kINTARRAY);
        literals.put(Type1Keys.hires, ArgumentType.kUNSUPPORTEDFONT);
        literals.put(Type1Keys.initialRandomSeed, ArgumentType.kINTEGER);
        literals.put(Type1Keys.isFixedPitch, ArgumentType.kBOOL);
        literals.put(Type1Keys.lenIV, ArgumentType.kINTEGER);
        literals.put(Type1Keys.version, ArgumentType.kBYTES);
    }

    private static class FetchGNameFromT1Subset
    extends NameKeyedFont.GlyphNameFetcher {
        private final SubsetSimpleType1 t1Subset;

        FetchGNameFromT1Subset(SubsetSimpleType1 t1Subset) {
            this.t1Subset = t1Subset;
        }

        @Override
        public String getGlyphName(Subset s, int i) {
            if (i == 0) {
                return ".notdef";
            }
            return this.t1Subset.getGlyphNames()[i - 1];
        }
    }

    private class T1XDCFontDescription
    extends XDCFontDescription {
        private T1XDCFontDescription() {
        }

        @Override
        public int getNumGlyphs() throws UnsupportedFontException, InvalidFontException {
            return Type1Font.this.getNumGlyphs();
        }

        @Override
        public String getGlyphName(int gid) throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getGlyphName(gid);
        }

        @Override
        public int getGlyphCid(int glyphID) throws UnsupportedFontException, InvalidFontException {
            return -1;
        }

        @Override
        public ROS getROS() {
            return null;
        }

        @Override
        public boolean pdfFontIsTrueType() {
            return false;
        }

        @Override
        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getPostscriptName();
        }

        @Override
        public String getFontFamily() throws InvalidFontException, UnsupportedFontException {
            Object o = Type1Font.this.getValue(Type1Keys.FamilyName);
            if (o != null) {
                return (String)o;
            }
            return null;
        }

        @Override
        public double getAdvance(int glyphID) throws InvalidGlyphException, UnsupportedFontException, InvalidFontException {
            return Type1Font.this.getHorizontalAdvance(glyphID) * 1000.0 / Type1Font.this.getUnitsPerEmX();
        }

        @Override
        public Rect getFontBBox() throws InvalidFontException, UnsupportedFontException {
            Rect bbox = (Rect)Type1Font.this.getValue("FontBBox");
            if (bbox == null) {
                return null;
            }
            return bbox.applyMatrix(Type1Font.this.getFontMatrix().multiply(1000.0));
        }

        @Override
        public double getStemV() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getStemV() * 1000.0 / Type1Font.this.getUnitsPerEmX();
        }

        @Override
        public double getCapHeight() throws UnsupportedFontException, InvalidFontException {
            double capHeight = Type1Font.this.getCoolTypeCapHeight();
            if (Double.isNaN(capHeight)) {
                return 0.0;
            }
            return capHeight * 1000.0 / Type1Font.this.getUnitsPerEmY();
        }

        @Override
        public double getXHeight() throws UnsupportedFontException, InvalidFontException {
            double xHeight = Type1Font.this.getCoolTypeXHeight();
            if (Double.isNaN(xHeight)) {
                return 0.0;
            }
            return xHeight * 1000.0 / Type1Font.this.getUnitsPerEmY();
        }

        @Override
        public double getItalicAngle() throws InvalidFontException, UnsupportedFontException {
            Object o = Type1Font.this.getValue("ItalicAngle");
            if (o != null) {
                return (Double)o;
            }
            return 0.0;
        }

        @Override
        public String getBase14Name() {
            return null;
        }

        @Override
        public boolean isSerifFont() throws InvalidFontException, UnsupportedFontException {
            int gid1 = Type1Font.this.getGlyphForChar(108);
            if (gid1 == 0) {
                gid1 = Type1Font.this.glyphName2gid("Lsmall");
            }
            int gid2 = Type1Font.this.getGlyphForChar(73);
            return Type1Font.this.isSerifFont(gid1, gid2, this.getItalicAngle());
        }

        @Override
        public boolean isSmallCapFont() throws InvalidFontException, UnsupportedFontException {
            if (!this.isAllCapFont()) {
                int gid2;
                int gid1 = Type1Font.this.getGlyphForChar(104);
                if (gid1 == 0) {
                    gid1 = Type1Font.this.glyphName2gid("Hsmall");
                }
                if ((gid2 = Type1Font.this.getGlyphForChar(120)) == 0) {
                    gid2 = Type1Font.this.glyphName2gid("Xsmall");
                }
                if (gid2 != 0) {
                    Rect bbox = Type1Font.this.getGlyphBBox(gid2);
                    return Type1Font.this.isSmallCapFont(gid1, bbox.ymax);
                }
            }
            return false;
        }

        @Override
        public boolean isAllCapFont() throws InvalidFontException, UnsupportedFontException {
            int gid1 = Type1Font.this.getGlyphForChar(75);
            int gid2 = Type1Font.this.getGlyphForChar(107);
            if (gid2 == 0) {
                gid2 = Type1Font.this.glyphName2gid("Ksmall");
            }
            return Type1Font.this.isAllCapFont(gid1, gid2);
        }

        @Override
        public int getCIDCount() {
            return -1;
        }

        @Override
        public void subsetAndStream(Subset subset, OutputStream out, boolean preserveROS) throws InvalidFontException, UnsupportedFontException, IOException {
            Type1Font.this.subsetAndStream(subset, out, preserveROS);
        }

        @Override
        public void subsetAndStream(SubsetSimpleType1 t1Subset, OutputStream out) throws InvalidFontException, UnsupportedFontException, IOException {
            Type1Font.this.subsetAndStream(t1Subset, out);
        }

        @Override
        public void subsetAndStream(SubsetSimpleTrueType ttSubset, OutputStream out) throws UnsupportedFontException {
            throw new UnsupportedFontException("Not a TrueType font");
        }

        @Override
        public CodePage[] getXDCCodePages() throws InvalidFontException, UnsupportedFontException {
            HashSet<CodePage> codePageSet = new HashSet<CodePage>();
            CoolTypeScript script = Type1Font.this.getCoolTypeScript();
            if (script == CoolTypeScript.ROMAN) {
                if (Type1Font.this.getGlyphForChar(65) > 0) {
                    codePageSet.add(CodePage.ROMAN1);
                }
            } else if (script == CoolTypeScript.EAST_EUROPEAN_ROMAN) {
                codePageSet.add(CodePage.ROMAN2);
            } else if (script == CoolTypeScript.JAPANESE) {
                codePageSet.add(CodePage.JAPANESE);
            } else if (script == CoolTypeScript.KOREAN) {
                codePageSet.add(CodePage.KOREAN);
            } else if (script == CoolTypeScript.SIMPLIFIED_CHINESE) {
                codePageSet.add(CodePage.SIMPLIFIED_CHINESE);
            } else if (script == CoolTypeScript.TRADITIONAL_CHINESE) {
                codePageSet.add(CodePage.TRADITIONAL_CHINESE);
            }
            if (Type1Font.this.glyphName2gid("ecircumflex") > 0) {
                codePageSet.add(CodePage.ROMAN1);
            }
            if (Type1Font.this.glyphName2gid("Ccaron") > 0 || Type1Font.this.glyphName2gid("ncaron") > 0) {
                codePageSet.add(CodePage.ROMAN2);
            }
            if (Type1Font.this.glyphName2gid("akatakana") > 0) {
                codePageSet.add(CodePage.JAPANESE);
            }
            CodePage[] retVal = new CodePage[codePageSet.size()];
            Iterator iter = codePageSet.iterator();
            int index = 0;
            while (iter.hasNext()) {
                retVal[index++] = (CodePage)iter.next();
            }
            return retVal;
        }

        @Override
        public void stream(OutputStream out, boolean openTypeFontsAllowed) throws InvalidFontException, UnsupportedFontException, IOException {
            Type1Font.this.stream(out, openTypeFontsAllowed);
        }
    }

    private class T1SWFFont3Description
    implements SWFFontDescription {
        private final boolean wasEmbedded;
        private final LineMetrics metrics;

        T1SWFFont3Description(boolean wasEmbedded) throws UnsupportedFontException, InvalidFontException {
            this.wasEmbedded = wasEmbedded;
            this.metrics = Type1Font.this.getCoolTypeLineMetrics();
        }

        @Override
        public boolean canDisplay(char c) throws UnsupportedFontException, InvalidFontException {
            return Type1Font.this.getGlyphForChar(c) != 0;
        }

        @Override
        public double getAscent() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.ascender * Type1Font.this.getUnitsPerEmX() / Type1Font.this.getUnitsPerEmY();
        }

        @Override
        public double getDescent() throws InvalidFontException, UnsupportedFontException {
            return -this.metrics.descender * Type1Font.this.getUnitsPerEmX() / Type1Font.this.getUnitsPerEmY();
        }

        @Override
        public double getLineGap() throws InvalidFontException, UnsupportedFontException {
            return this.metrics.linegap * Type1Font.this.getUnitsPerEmX() / Type1Font.this.getUnitsPerEmY();
        }

        @Override
        public double getEmScale() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getUnitsPerEmX();
        }

        @Override
        public String getFullName() throws InvalidFontException, UnsupportedFontException {
            return (String)Type1Font.this.getValue(Type1Keys.FullName);
        }

        @Override
        public String getFamily() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getPreferredCSSFamilyName();
        }

        @Override
        public String getCopyright() throws InvalidFontException, UnsupportedFontException {
            byte[] tmp = (byte[])Type1Font.this.getValue(Type1Keys.Copyright);
            return tmp == null ? null : Type1Font.this.bytesToString(tmp);
        }

        @Override
        public String getTrademark() throws InvalidFontException, UnsupportedFontException {
            byte[] tmp = (byte[])Type1Font.this.getValue(Type1Keys.Notice);
            return tmp == null ? null : Type1Font.this.bytesToString(tmp);
        }

        @Override
        public int getFirstChar() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getFirstChar();
        }

        @Override
        public double getHorizontalAdvance(char ccode) throws UnsupportedFontException, InvalidFontException {
            int gid = Type1Font.this.getGlyphForChar(ccode);
            return Type1Font.this.getHorizontalAdvance(gid);
        }

        @Override
        public int getLastChar() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getLastChar();
        }

        @Override
        public int getNumGlyphs() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getNumGlyphs();
        }

        @Override
        public void getOutline(char ccode, OutlineConsumer consumer) throws UnsupportedFontException, InvalidFontException {
            int gid = Type1Font.this.getGlyphForChar(ccode);
            Type1Font.this.getGlyphOutline(gid, consumer);
        }

        @Override
        public Permission getPermissions() throws InvalidFontException, UnsupportedFontException {
            Permission perm = Type1Font.this.getEmbeddingPermission(this.wasEmbedded);
            if (perm == Permission.ILLEGAL_VALUE) {
                perm = Permission.EDITABLE;
            }
            return perm;
        }

        @Override
        public String getPostscriptName() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getPostscriptName();
        }

        @Override
        public boolean isBold() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.getCSSWeight() >= 700;
        }

        @Override
        public boolean isItalic() throws InvalidFontException, UnsupportedFontException {
            return Type1Font.this.isCSSStyleItalic();
        }

        @Override
        public String getSubFamily() throws InvalidFontException, UnsupportedFontException {
            return null;
        }
    }

    private static class CharstringCompare
    implements Comparator {
        static final CharstringCompare comparator = new CharstringCompare();

        private CharstringCompare() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            Type1Glyph first = (Type1Glyph)o1;
            Type1Glyph second = (Type1Glyph)o2;
            if (first.glyphName.equals(".notdef")) {
                if (second.glyphName.equals(".notdef")) {
                    return 0;
                }
                return -1;
            }
            if (second.glyphName.equals(".notdef")) {
                return 1;
            }
            return first.glyphName.compareTo(second.glyphName);
        }
    }

    private static class ArgumentType {
        private String description;
        static ArgumentType kINTEGER = new ArgumentType("Integer");
        static ArgumentType kNUMBER = new ArgumentType("Number");
        static ArgumentType kSTRING = new ArgumentType("String");
        static ArgumentType kBYTES = new ArgumentType("Bytes");
        static ArgumentType kBOOL = new ArgumentType("Bool");
        static ArgumentType kNUMARRAY = new ArgumentType("NumArray");
        static ArgumentType kARRAYOF1 = new ArgumentType("Array of 1");
        static ArgumentType kINTARRAY = new ArgumentType("IntArray");
        static ArgumentType kNAME = new ArgumentType("Name");
        static ArgumentType kUNSUPPORTEDFONT = new ArgumentType("Unsupported font");
        static ArgumentType kFONTTYPE = new ArgumentType("FontType");
        static ArgumentType kORIGFONTTYPE = new ArgumentType("OrigFontType");
        static ArgumentType kENCODING = new ArgumentType("Encoding");
        static ArgumentType kERODE = new ArgumentType("ErodeProcedure");
        static ArgumentType kCHARSTRINGS = new ArgumentType("CharStrings");
        static ArgumentType kSUBRS = new ArgumentType("Subroutines");
        static ArgumentType kFONTMATRIX = new ArgumentType("FontMatrix");
        static ArgumentType kRNDSTEMUP = new ArgumentType("RndStemUp");
        static ArgumentType kITALICANGLE = new ArgumentType("ItalicAngle");
        static ArgumentType kBBOX = new ArgumentType("BoundingBox");
        static ArgumentType kPRIVATE = new ArgumentType("Private Dictionary");

        private ArgumentType(String s) {
            this.description = s;
        }

        public String toString() {
            return this.description;
        }
    }

    private static class Type1Keys {
        static String BaseFontBlend = "BaseFontBlend";
        static String BaseFontName = "BaseFontName";
        static String Blend = "Blend";
        static String BlendDesignMap = "BlendDesignMap";
        static String BlendDesignPositions = "BlendDesignPositions";
        static String BlueFuzz = "BlueFuzz";
        static String BlueScale = "BlueScale";
        static String BlueShift = "BlueShift";
        static String BlueValues = "BlueValues";
        static String CIDInit = "CIDInit";
        static String Chameleon = "Chameleon";
        static String CharStrings = "CharStrings";
        static String Copyright = "Copyright";
        static String CSSWeight = "CSSWeight";
        static String CSSWidth = "CSSWidth";
        static String Encoding = "Encoding";
        static String Erode = "Erode";
        static String ExpansionFactor = "ExpansionFactor";
        static String FSType = "FSType";
        static String FamilyBlues = "FamilyBlues";
        static String FamilyName = "FamilyName";
        static String FamilyOtherBlues = "FamilyOtherBlues";
        static String FontBBox = "FontBBox";
        static String FontMatrix = "FontMatrix";
        static String FontName = "FontName";
        static String FontType = "FontType";
        static String ForceBold = "ForceBold";
        static String ForceBoldThreshold = "ForceBoldThreshold";
        static String FullName = "FullName";
        static String GlyphDirectory = "GlyphDirectory";
        static String InvertedFontMatrix = "InvertedFontMatrix";
        static String IsSmallCaps = "IsSmallCaps";
        static String ItalicAngle = "ItalicAngle";
        static String LanguageGroup = "LanguageGroup";
        static String Notice = "Notice";
        static String OrigFontType = "OrigFontType";
        static String OtherBlues = "OtherBlues";
        static String PaintType = "PaintType";
        static String Private = "Private";
        static String PostScript = "PostScript";
        static String RndStemUp = "RndStemUp";
        static String StandardEncoding = "StandardEncoding";
        static String StdHW = "StdHW";
        static String StdVW = "StdVW";
        static String StemSnapH = "StemSnapH";
        static String StemSnapV = "StemSnapV";
        static String StrokeWidth = "StrokeWidth";
        static String Subrs = "Subrs";
        static String UnderlinePosition = "UnderlinePosition";
        static String UnderlineThickness = "UnderlineThickness";
        static String UniqueID = "UniqueID";
        static String WasEmbedded = "WasEmbedded";
        static String Weight = "Weight";
        static String WeightVector = "WeightVector";
        static String XUID = "XUID";
        static String hires = "hires";
        static String initialRandomSeed = "initialRandomSeed";
        static String isFixedPitch = "isFixedPitch";
        static String lenIV = "lenIV";
        static String version = "version";

        private Type1Keys() {
        }
    }

    private static class Literals {
        static final byte[] kCID_LITERAL = new byte[]{47, 67, 73, 68};
        static final byte[] kTRUETYPE_LITERAL = new byte[]{47, 84, 114, 117, 101, 84, 121, 112, 101};
        static final byte[] kTYPE1_LITERAL = new byte[]{47, 84, 121, 112, 101, 49};
        static final byte[] kOCF_LITERAL = new byte[]{47, 79, 67, 70};
        static final byte[] kNOTDEF = new byte[]{46, 110, 111, 116, 100, 101, 102};

        private Literals() {
        }
    }

    private static class Operators {
        static final byte[] kTRUE = new byte[]{116, 114, 117, 101};
        static final byte[] kFALSE = new byte[]{102, 97, 108, 115, 101};
        static final byte[] kCURRENTFILE = new byte[]{99, 117, 114, 114, 101, 110, 116, 102, 105, 108, 101};
        static final byte[] kCLOSEFILE = new byte[]{99, 108, 111, 115, 101, 102, 105, 108, 101};
        static final byte[] kEEXEC = new byte[]{101, 101, 120, 101, 99};
        static final byte[] kSTANDARDENCODING = new byte[]{83, 116, 97, 110, 100, 97, 114, 100, 69, 110, 99, 111, 100, 105, 110, 103};
        static final byte[] kNOTDEF = new byte[]{46, 110, 111, 116, 100, 101, 102};
        static final byte[] kDUP = new byte[]{100, 117, 112};
        static final byte[] kPUT = new byte[]{112, 117, 116};
        static final byte[] kDEF = new byte[]{100, 101, 102};
        static final byte[] kREADONLY = new byte[]{114, 101, 97, 100, 111, 110, 108, 121};
        static final byte[] kBEGIN = new byte[]{98, 101, 103, 105, 110};
        static final byte[] kEND = new byte[]{101, 110, 100};
        static final byte[] kARRAY = new byte[]{97, 114, 114, 97, 121};
        static final byte[] kNOACCESS = new byte[]{110, 111, 97, 99, 99, 101, 115, 115};
        static final byte[] kFONTDIRECTORY = new byte[]{70, 111, 110, 116, 68, 105, 114, 101, 99, 116, 111, 114, 121};

        private Operators() {
        }
    }
}

