/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting.infontformatting;

import com.adobe.agl.util.LocaleData;
import com.adobe.agl.util.ULocale;
import com.adobe.fontengine.CharUtil;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.InvalidGlyphException;
import com.adobe.fontengine.font.Rect;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.OpenTypeFont;
import com.adobe.fontengine.font.opentype.Tag;
import com.adobe.fontengine.font.type1.Type1Font;
import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;
import com.adobe.fontengine.inlineformatting.infontformatting.InFontFormatter;
import java.util.HashMap;
import java.util.Map;

public class BaseFormatter {
    private static final Map otScriptMap = new HashMap();

    public int firstPass(AttributedRun run, int start, int limit) {
        return limit;
    }

    public int canRenderWithNotdef(AttributedRun run, int start, int limit) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int graphemeLimit;
        int usv = run.elementAt(start);
        if (CharUtil.isControl(usv)) {
            return 1;
        }
        if (!CharUtil.isBase(usv) || start + 1 == limit || run.getElementStyle(start + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(run.elementAt(start + 1))) {
            return 1;
        }
        for (graphemeLimit = start + 1; graphemeLimit < limit && run.getElementStyle(graphemeLimit, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(run.elementAt(graphemeLimit)); ++graphemeLimit) {
        }
        return graphemeLimit - start;
    }

    public int canRenderWithFont(FontData fontData, AttributedRun run, int start, int limit) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        int gid;
        int graphemeLimit;
        if (this.shouldFormatOT(fontData) ? !this.canFormatOT() : (this.shouldFormatTT(fontData) ? !this.canFormatTT() : (this.shouldFormatT1(fontData) ? !this.canFormatT1() : !this.canFormatGeneric()))) {
            return 0;
        }
        int usv = run.elementAt(start);
        if (CharUtil.isControl(usv) && !fontData.isSymbolic()) {
            return 1;
        }
        if (!CharUtil.isBase(usv) || start + 1 == limit || run.getElementStyle(start + 1, ElementAttribute.isGlyph) == Boolean.TRUE || !CharUtil.isCombining(run.elementAt(start + 1))) {
            int gid2 = fontData.getGlyphForChar(usv);
            return gid2 == 0 ? 0 : 1;
        }
        for (graphemeLimit = start + 1; graphemeLimit < limit && run.getElementStyle(graphemeLimit, ElementAttribute.isGlyph) != Boolean.TRUE && CharUtil.isCombining(run.elementAt(graphemeLimit)); ++graphemeLimit) {
        }
        boolean directMappingHasNotdef = false;
        int[] usvs = new int[graphemeLimit - start];
        int[] gids = new int[graphemeLimit - start];
        for (int i = start; i < graphemeLimit; ++i) {
            usvs[i - start] = run.elementAt(i);
            gid = fontData.getGlyphForChar(usvs[i - start]);
            if (gid == 0) {
                directMappingHasNotdef = true;
            }
            gids[i - start] = gid;
        }
        if (directMappingHasNotdef) {
            int usvc = CharUtil.compose(usvs, 0, graphemeLimit - start);
            if (usvc != -1 && (gid = fontData.getGlyphForChar(usvc)) != 0) {
                return graphemeLimit - start;
            }
            return 0;
        }
        return graphemeLimit - start;
    }

    protected boolean shouldFormatOT(FontData fontData) {
        if (fontData instanceof OpenTypeFont) {
            OpenTypeFont otFont = (OpenTypeFont)fontData;
            return otFont.gpos != null || otFont.gsub != null;
        }
        return false;
    }

    protected boolean canFormatOT() {
        return false;
    }

    protected int formatOT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    protected boolean shouldFormatTT(FontData fontData) {
        if (fontData instanceof OpenTypeFont) {
            OpenTypeFont otFont = (OpenTypeFont)fontData;
            return otFont.gpos == null && otFont.gsub == null;
        }
        return false;
    }

    protected boolean canFormatTT() {
        return false;
    }

    protected int formatTT(OpenTypeFont otFont, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    protected boolean shouldFormatT1(FontData fontData) {
        return fontData instanceof Type1Font;
    }

    protected boolean canFormatT1() {
        return false;
    }

    protected int formatT1(Type1Font t1Font, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    protected boolean shouldFormatGeneric(FontData fontData) {
        return !(fontData instanceof Type1Font) && !(fontData instanceof OpenTypeFont);
    }

    protected boolean canFormatGeneric() {
        return false;
    }

    protected int formatGeneric(FontData fontData, AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        throw new UnsupportedFontException();
    }

    public int format(AttributedRun run, int start, int limit, boolean shouldKern) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        while (start < limit) {
            int newFontLimit;
            int fontLimit = run.getSubrunLimit(start, limit, InFontFormatter.fontAtts);
            Font font = (Font)run.getElementStyle(start, ElementAttribute.font);
            FontData fontData = ((FontImpl)font).getFontData();
            if (this.shouldFormatOT(fontData)) {
                newFontLimit = this.formatOT((OpenTypeFont)fontData, run, start, fontLimit, shouldKern);
            } else if (this.shouldFormatTT(fontData)) {
                newFontLimit = this.formatTT((OpenTypeFont)fontData, run, start, fontLimit, shouldKern);
            } else if (this.shouldFormatT1(fontData)) {
                Type1Font t1Font = (Type1Font)fontData;
                newFontLimit = this.formatT1(t1Font, run, start, fontLimit, shouldKern);
            } else {
                newFontLimit = this.formatGeneric(fontData, run, start, fontLimit, shouldKern);
            }
            start = newFontLimit;
            limit += newFontLimit - fontLimit;
        }
        return limit;
    }

    public void posFromAdvanceWidth(AttributedRun run, FontData fontData, int first, int limit) throws InvalidFontException, UnsupportedFontException, InvalidGlyphException {
        run.startWorkingWithPositions(first, limit);
        for (int i = first; i < limit; ++i) {
            int gid = run.elementAt(i);
            if (gid > fontData.getNumGlyphs()) {
                throw new InvalidFontException("gid " + gid + " is not a valid gid (numGlyphs = " + fontData.getNumGlyphs() + ")");
            }
            double ascent = 0.0;
            double descent = 0.0;
            Rect bbox = fontData.getCoolTypeGlyphBBox(gid);
            ascent = bbox.ymax;
            descent = bbox.ymin;
            run.setElementPlacementAndAdvance(i, 0.0, 0.0, fontData.getHorizontalAdvance(gid), 0.0);
            run.setElementAscentAndDescent(i, ascent, descent);
        }
    }

    protected void applyKernTable(OpenTypeFont otFont, AttributedRun run, int start, int limit) throws InvalidFontException, UnsupportedFontException {
        if (otFont.kern == null) {
            return;
        }
        for (int i = start; i < limit - 1; ++i) {
            int[] kernVector = otFont.kern.getKernVector(run.elementAt(i), run.elementAt(i + 1));
            run.adjustPlacementAndAdvance(i, 0.0, 0.0, kernVector[0], kernVector[1]);
        }
    }

    static int getOTScriptTag(Integer uscript) {
        Integer i = (Integer)otScriptMap.get(uscript);
        if (i != null) {
            return i;
        }
        return Tag.script_DFLT;
    }

    static int getOTLanguageTag(ULocale locale) {
        int langTag = LocaleData.getOpenTypeData(locale).getLanguageTag();
        if (langTag == 0) {
            langTag = Tag.language_ENG;
        }
        return langTag;
    }

    static {
        otScriptMap.put(new Integer(2), new Integer(Tag.script_arab));
        otScriptMap.put(new Integer(3), new Integer(Tag.script_armn));
        otScriptMap.put(new Integer(4), new Integer(Tag.script_beng));
        otScriptMap.put(new Integer(5), new Integer(Tag.script_bopo));
        otScriptMap.put(new Integer(46), new Integer(Tag.script_brai));
        otScriptMap.put(new Integer(40), new Integer(Tag.script_cans));
        otScriptMap.put(new Integer(6), new Integer(Tag.script_cher));
        otScriptMap.put(new Integer(8), new Integer(Tag.script_cyrl));
        otScriptMap.put(new Integer(10), new Integer(Tag.script_deva));
        otScriptMap.put(new Integer(11), new Integer(Tag.script_ethi));
        otScriptMap.put(new Integer(12), new Integer(Tag.script_geor));
        otScriptMap.put(new Integer(14), new Integer(Tag.script_grek));
        otScriptMap.put(new Integer(15), new Integer(Tag.script_gujr));
        otScriptMap.put(new Integer(16), new Integer(Tag.script_guru));
        otScriptMap.put(new Integer(17), new Integer(Tag.script_hani));
        otScriptMap.put(new Integer(18), new Integer(Tag.script_hang));
        otScriptMap.put(new Integer(19), new Integer(Tag.script_hebr));
        otScriptMap.put(new Integer(20), new Integer(Tag.script_kana));
        otScriptMap.put(new Integer(21), new Integer(Tag.script_knda));
        otScriptMap.put(new Integer(22), new Integer(Tag.script_kana));
        otScriptMap.put(new Integer(23), new Integer(Tag.script_khmr));
        otScriptMap.put(new Integer(24), new Integer(Tag.script_lao));
        otScriptMap.put(new Integer(25), new Integer(Tag.script_latn));
        otScriptMap.put(new Integer(26), new Integer(Tag.script_mlym));
        otScriptMap.put(new Integer(27), new Integer(Tag.script_mong));
        otScriptMap.put(new Integer(28), new Integer(Tag.script_mymr));
        otScriptMap.put(new Integer(29), new Integer(Tag.script_ogam));
        otScriptMap.put(new Integer(31), new Integer(Tag.script_orya));
        otScriptMap.put(new Integer(32), new Integer(Tag.script_runr));
        otScriptMap.put(new Integer(33), new Integer(Tag.script_sinh));
        otScriptMap.put(new Integer(34), new Integer(Tag.script_syrc));
        otScriptMap.put(new Integer(35), new Integer(Tag.script_taml));
        otScriptMap.put(new Integer(36), new Integer(Tag.script_telu));
        otScriptMap.put(new Integer(37), new Integer(Tag.script_thaa));
        otScriptMap.put(new Integer(38), new Integer(Tag.script_thai));
        otScriptMap.put(new Integer(39), new Integer(Tag.script_tibt));
        otScriptMap.put(new Integer(41), new Integer(Tag.script_yi));
        otScriptMap.put(new Integer(54), new Integer(Tag.script_kana));
    }
}

