/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.translation.core.common;

import com.adobe.granite.translation.api.TranslationConstants;
import com.adobe.granite.translation.api.TranslationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationResultImpl
implements TranslationResult {
    private static final Logger log = LoggerFactory.getLogger(TranslationResultImpl.class);
    public static int UNKNOWN_RATING = -999;
    private String translation;
    private String sourceLang;
    private String targetLang;
    private TranslationConstants.ContentType contentType;
    private String category;
    private String source;
    private int rating;
    private String userId;

    public TranslationResultImpl(String translation, String sourceLang, String targetLang, TranslationConstants.ContentType contentType, String category, String source, int rating, String userId) {
        log.trace("In function: TranslationResultImpl");
        this.translation = translation;
        this.sourceLang = sourceLang;
        this.targetLang = targetLang;
        this.contentType = contentType;
        this.category = category;
        this.source = source;
        this.rating = rating;
        this.userId = userId;
        if (log.isDebugEnabled()) {
            log.debug("translation: {}", (Object)translation);
            log.debug("sourceLang: {}", (Object)sourceLang);
            log.debug("targetLang: {}", (Object)targetLang);
            log.debug("contentType: {}", (Object)contentType.getType());
            log.debug("category: {}", (Object)category);
            log.debug("source: {}", (Object)source);
            log.debug("rating: {}", (Object)rating);
            log.debug("userId: {}", (Object)userId);
        }
    }

    @Override
    public String getTranslation() {
        return this.translation;
    }

    @Override
    public String getSourceLanguage() {
        return this.sourceLang;
    }

    @Override
    public String getTargetLanguage() {
        return this.targetLang;
    }

    @Override
    public TranslationConstants.ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getSourceString() {
        return this.source;
    }

    @Override
    public int getRating() {
        return this.rating;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }
}

