/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCIIHexOutputStream
extends FilterOutputStream {
    private int NEWLINE_EVERY = 64;
    private int lineLength;
    private byte[] toHex;
    private long totalOut;

    public ASCIIHexOutputStream(OutputStream out, FilterParams p) {
        super(out);
        this.initOutput();
        if (p != null && p.containsKey("NewlineEvery")) {
            this.NEWLINE_EVERY = (Integer)p.get("NewlineEvery");
        }
    }

    public ASCIIHexOutputStream(OutputStream out) {
        this(out, null);
    }

    private void initOutput() {
        int i;
        this.lineLength = this.NEWLINE_EVERY;
        this.totalOut = 0L;
        this.toHex = new byte[16];
        for (i = 0; i <= 9; ++i) {
            this.toHex[i] = (byte)(i + 48);
        }
        for (i = 10; i <= 15; ++i) {
            this.toHex[i] = (byte)(i - 10 + 65);
        }
    }

    private void putEOL() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.lineLength = 0;
        this.totalOut += 2L;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.lineLength > this.NEWLINE_EVERY - 2) {
            this.putEOL();
        }
        this.out.write(this.toHex[b >>> 4 & 0xF]);
        this.out.write(this.toHex[b & 0xF]);
        this.lineLength += 2;
        this.totalOut += 2L;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int maxWrite = b.length - off;
        if (maxWrite > len) {
            maxWrite = len;
        }
        while (maxWrite-- > 0) {
            this.write(b[off++] & 0xFF);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.out.write(62);
        ++this.totalOut;
        super.close();
    }

    public long getTotalOut() {
        return this.totalOut;
    }
}

