/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.permissionprovider;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.util.BitwiseExpression;
import com.adobe.internal.util.BitwiseOperandEvaluator;
import com.adobe.internal.util.InvalidOperandException;
import com.adobe.internal.util.MalformedExpressionException;
import java.util.HashMap;
import java.util.Map;

public class PermissionProviderStandard
implements PermissionProvider,
BitwiseOperandEvaluator {
    private int m_Perms = 0;
    static final String OPEN = "Open";
    static final String SECURE = "Secure";
    static final String PRINT_LOW = "PrintLow";
    static final String EDIT = "Modfiy/Edit";
    static final String COPY = "Copy";
    static final String EDIT_NOTES = "EditNotes";
    static final String EXT = "Ext";
    static final String SAVE_AS = "SaveAs";
    static final String FILL_SIGNIN = "FillAndSign";
    static final String ACCESSIBLE = "Accessible";
    static final String DOC_ASSEMBLY = "DocAssembly";
    static final String HIGH_PRINT = "HighPrint";
    private static final Map m_PermissionData = PermissionProviderStandard.initPermissionData();
    private static final Map m_ReversePermissionData = PermissionProviderStandard.initReversePermissionData();
    private static final Map m_BitFlags = PermissionProviderStandard.initBitFlags();

    public PermissionProviderStandard(int perms) {
        this.m_Perms = perms;
    }

    public static PermissionProviderStandard newInstance(PermissionProvider provider) throws PDFUnableToCompleteOperationException {
        if (provider == null) {
            return null;
        }
        if (provider instanceof PermissionProviderStandard) {
            return new PermissionProviderStandard(((PermissionProviderStandard)provider).getPermissionBits());
        }
        int perms = 0;
        for (ObjectOperations operation : m_ReversePermissionData.keySet()) {
            if (!provider.isPermitted(operation)) continue;
            String permission = (String)m_ReversePermissionData.get(operation);
            Integer bitFlag = (Integer)m_BitFlags.get(permission);
            perms |= 1 << bitFlag;
        }
        return new PermissionProviderStandard(perms);
    }

    public int getPermissionBits() {
        return this.m_Perms;
    }

    private static Map initPermissionData() {
        HashMap<ObjectOperations, String> permissionData = new HashMap<ObjectOperations, String>();
        permissionData.put(ObjectOperations.DOC_MODIFY, EDIT);
        permissionData.put(ObjectOperations.DOC_COPY, COPY);
        permissionData.put(ObjectOperations.DOC_ACCESSIBLE, "Copy|Accessible");
        permissionData.put(ObjectOperations.DOC_OPEN, OPEN);
        permissionData.put(ObjectOperations.DOC_SECURE, SECURE);
        permissionData.put(ObjectOperations.DOC_PRINT_HIGH, HIGH_PRINT);
        permissionData.put(ObjectOperations.DOC_PRINT_LOW, PRINT_LOW);
        permissionData.put(ObjectOperations.DOC_FULLSAVE, "Modfiy/Edit|EditNotes|FillAndSign|DocAssembly");
        permissionData.put(ObjectOperations.DOC_IMPORT, EDIT);
        permissionData.put(ObjectOperations.DOC_EXPORT, COPY);
        permissionData.put(ObjectOperations.PAGE_CREATE, EDIT);
        permissionData.put(ObjectOperations.PAGE_DELETE, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.PAGE_MODIFY, EDIT);
        permissionData.put(ObjectOperations.PAGE_COPY, EDIT);
        permissionData.put(ObjectOperations.PAGE_ROTATE, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.PAGE_CROP, EDIT);
        permissionData.put(ObjectOperations.PAGE_INSERT, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.PAGE_REPLACE, EDIT);
        permissionData.put(ObjectOperations.PAGE_REORDER, EDIT);
        permissionData.put(ObjectOperations.PAGE_EXPORT, SECURE);
        permissionData.put(ObjectOperations.LINK_CREATE, EDIT);
        permissionData.put(ObjectOperations.LINK_DELETE, EDIT);
        permissionData.put(ObjectOperations.LINK_MODIFY, EDIT);
        permissionData.put(ObjectOperations.LINK_IMPORT, EDIT);
        permissionData.put(ObjectOperations.LINK_EXPORT, "Modfiy/Edit|Copy");
        permissionData.put(ObjectOperations.BOOKMARK_CREATE, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.BOOKMARK_DELETE, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.BOOKMARK_MODIFY, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.BOOKMARK_EXPORT, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.THUMBNAIL_CREATE, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.THUMBNAIL_DELETE, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.THUMBNAIL_EXPORT, "Modfiy/Edit|DocAssembly");
        permissionData.put(ObjectOperations.ANNOT_CREATE, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_DELETE, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_MODIFY, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_COPY, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_SUMMARIZE, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_IMPORT, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_EXPORT, "Copy|EditNotes");
        permissionData.put(ObjectOperations.FORM_CREATE, "Modfiy/Edit&EditNotes");
        permissionData.put(ObjectOperations.FORM_DELETE, "Modfiy/Edit&EditNotes");
        permissionData.put(ObjectOperations.FORM_MODIFY, "Modfiy/Edit&EditNotes");
        permissionData.put(ObjectOperations.FORM_FILLIN, "Modfiy/Edit|EditNotes|FillAndSign");
        permissionData.put(ObjectOperations.FORM_IMPORT, "Modfiy/Edit|EditNotes|FillAndSign");
        permissionData.put(ObjectOperations.FORM_EXPORT, "Copy| (Modfiy/Edit&EditNotes)");
        permissionData.put(ObjectOperations.FORM_SPAWN_TEMPLATE, "Modfiy/Edit|FillAndSign");
        permissionData.put(ObjectOperations.SIGNATURE_CREATE, "Modfiy/Edit&EditNotes");
        permissionData.put(ObjectOperations.SIGNATURE_DELETE, "Modfiy/Edit&EditNotes");
        permissionData.put(ObjectOperations.SIGNATURE_MODIFY, "Modfiy/Edit&EditNotes");
        permissionData.put(ObjectOperations.SIGNATURE_FILLIN, "Modfiy/Edit|EditNotes|FillAndSign");
        permissionData.put(ObjectOperations.EF_CREATE, "Modfiy/Edit|EditNotes");
        permissionData.put(ObjectOperations.EF_DELETE, "Modfiy/Edit|EditNotes");
        permissionData.put(ObjectOperations.EF_MODIFY, "Modfiy/Edit|EditNotes|FillAndSign");
        permissionData.put(ObjectOperations.EF_IMPORT, "Modfiy/Edit|EditNotes");
        permissionData.put(ObjectOperations.EF_EXPORT, COPY);
        return permissionData;
    }

    private static Map initReversePermissionData() {
        HashMap<ObjectOperations, String> permissionData = new HashMap<ObjectOperations, String>();
        permissionData.put(ObjectOperations.DOC_MODIFY, EDIT);
        permissionData.put(ObjectOperations.DOC_COPY, COPY);
        permissionData.put(ObjectOperations.DOC_PRINT_HIGH, HIGH_PRINT);
        permissionData.put(ObjectOperations.DOC_PRINT_LOW, PRINT_LOW);
        permissionData.put(ObjectOperations.DOC_IMPORT, EDIT);
        permissionData.put(ObjectOperations.DOC_EXPORT, COPY);
        permissionData.put(ObjectOperations.DOC_ACCESSIBLE, ACCESSIBLE);
        permissionData.put(ObjectOperations.PAGE_CREATE, EDIT);
        permissionData.put(ObjectOperations.PAGE_MODIFY, EDIT);
        permissionData.put(ObjectOperations.PAGE_COPY, EDIT);
        permissionData.put(ObjectOperations.PAGE_CROP, EDIT);
        permissionData.put(ObjectOperations.PAGE_REPLACE, EDIT);
        permissionData.put(ObjectOperations.PAGE_REORDER, EDIT);
        permissionData.put(ObjectOperations.PAGE_DELETE, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.PAGE_ROTATE, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.PAGE_INSERT, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.LINK_CREATE, EDIT);
        permissionData.put(ObjectOperations.LINK_DELETE, EDIT);
        permissionData.put(ObjectOperations.LINK_MODIFY, EDIT);
        permissionData.put(ObjectOperations.LINK_IMPORT, EDIT);
        permissionData.put(ObjectOperations.ANNOT_CREATE, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_DELETE, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_MODIFY, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_COPY, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_SUMMARIZE, EDIT_NOTES);
        permissionData.put(ObjectOperations.ANNOT_IMPORT, EDIT_NOTES);
        permissionData.put(ObjectOperations.BOOKMARK_CREATE, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.BOOKMARK_DELETE, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.BOOKMARK_MODIFY, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.BOOKMARK_EXPORT, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.THUMBNAIL_CREATE, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.THUMBNAIL_DELETE, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.THUMBNAIL_EXPORT, DOC_ASSEMBLY);
        permissionData.put(ObjectOperations.FORM_FILLIN, FILL_SIGNIN);
        permissionData.put(ObjectOperations.FORM_IMPORT, FILL_SIGNIN);
        permissionData.put(ObjectOperations.FORM_SPAWN_TEMPLATE, FILL_SIGNIN);
        permissionData.put(ObjectOperations.SIGNATURE_FILLIN, FILL_SIGNIN);
        return permissionData;
    }

    private static Map initBitFlags() {
        HashMap<String, Integer> bitFlags = new HashMap<String, Integer>();
        bitFlags.put(OPEN, 0);
        bitFlags.put(SECURE, 1);
        bitFlags.put(PRINT_LOW, 2);
        bitFlags.put(EDIT, 3);
        bitFlags.put(COPY, 4);
        bitFlags.put(EDIT_NOTES, 5);
        bitFlags.put(FILL_SIGNIN, 8);
        bitFlags.put(ACCESSIBLE, 9);
        bitFlags.put(DOC_ASSEMBLY, 10);
        bitFlags.put(HIGH_PRINT, 11);
        return bitFlags;
    }

    @Override
    public boolean isPermitted(ObjectOperations objOpr) {
        String permValue = (String)m_PermissionData.get(objOpr);
        if (permValue == null) {
            return true;
        }
        BitwiseExpression expObj = new BitwiseExpression(this);
        boolean bRet = true;
        try {
            bRet = expObj.evaluateExpression(permValue);
        }
        catch (MalformedExpressionException e) {
            throw new RuntimeException("Gibson Internal error", e);
        }
        catch (InvalidOperandException e) {
            throw new RuntimeException("Gibson Internal error", e);
        }
        return bRet;
    }

    @Override
    public boolean evaluate(String operandVar) throws InvalidOperandException {
        Integer bitVal = (Integer)m_BitFlags.get(operandVar);
        if (bitVal == null) {
            throw new InvalidOperandException(operandVar + " is not valid Encryption permission paramter");
        }
        return (this.m_Perms & 1 << bitVal) != 0;
    }
}

