/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Arg;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Element;
import com.adobe.xfa.EventManager;
import com.adobe.xfa.LogMessenger;
import com.adobe.xfa.Model;
import com.adobe.xfa.ObjScript;
import com.adobe.xfa.ScriptDynamicPropObj;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.PeerImpl;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;

public abstract class Obj
implements Peer {
    private PeerImpl mPeers;
    private String maClassName = null;
    private int meClassTag = -1;

    @Override
    public final void addPeer(Peer poPeerNode) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.addPeer(poPeerNode);
    }

    @Override
    public final void addPeeredNode(Peer poPeer) {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.addPeeredNode(poPeer);
    }

    @Override
    public final void clearPeers() {
        if (this.mPeers != null) {
            this.mPeers.clearPeers();
        }
    }

    @Override
    public final void deafen() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.deafen();
    }

    private ScriptFuncObj findScriptFunc(ScriptTable table, String sName) {
        while (table != null) {
            if (table.mFuncTable != null) {
                ScriptFuncObj[] funcTable = table.mFuncTable;
                for (int i = 0; i < funcTable.length; ++i) {
                    ScriptFuncObj funcObj = funcTable[i];
                    if (!sName.equals(funcObj.getName())) continue;
                    return funcObj;
                }
            }
            table = table.mParentClass;
        }
        return null;
    }

    private ScriptPropObj findScriptProp(ScriptTable table, String sName) {
        while (table != null) {
            if (table.mPropTable != null) {
                ScriptPropObj[] propTable = table.mPropTable;
                for (int i = 0; i < propTable.length; ++i) {
                    ScriptPropObj propObj = propTable[i];
                    if (!sName.equals(propObj.getName() == null ? "" : propObj.getName())) continue;
                    return propObj;
                }
            }
            table = table.mParentClass;
        }
        return null;
    }

    public final void setClass(String sClassName, int eClassTag) {
        this.maClassName = sClassName;
        this.meClassTag = eClassTag;
    }

    public final void setClassTag(int eClassTag) {
        this.meClassTag = eClassTag;
    }

    public final int getClassTag() {
        return this.meClassTag;
    }

    public String getClassAtom() {
        return this.maClassName;
    }

    public String getClassName() {
        return this.getClassAtom();
    }

    protected ScriptDynamicPropObj getDynamicScriptProp(String sPropertyName, boolean bPropertyOverride, boolean bPeek) {
        return null;
    }

    protected EventManager.EventTable getEventTable(boolean bCreate) {
        return null;
    }

    @Override
    public final Peer getPeer(int nPeer) {
        if (this.mPeers == null) {
            return null;
        }
        return this.mPeers.getPeer(nPeer);
    }

    public ScriptFuncObj getScriptMethodInfo(String sName) {
        return this.findScriptFunc(this.getScriptThis().getScriptTable(), sName);
    }

    protected ScriptPropObj getScriptProp(String sPropertyName) {
        return this.findScriptProp(this.getScriptTable(), sPropertyName);
    }

    public boolean getScriptProperty(Arg retValue, String sPropertyName, DependencyTracker dependencyTracker, boolean bPeek, boolean bSuppressExceptions) {
        int eType;
        MsgFormatPos reason;
        boolean bIsFatal;
        ScriptDynamicPropObj desc;
        boolean bPropertyOverride = sPropertyName.startsWith("#");
        String sPropName = bPropertyOverride ? sPropertyName.substring(1) : sPropertyName;
        if (dependencyTracker != null) {
            dependencyTracker.addVirtualDependency(this, sPropertyName);
        }
        Obj scriptThis = this.getScriptThis();
        boolean bGotDynamicScriptProp = false;
        boolean bHasDynamicProp = false;
        if (sPropName.length() != 0 && (desc = scriptThis.getDynamicScriptProp(sPropName, bPropertyOverride, bPeek)) != null) {
            assert (desc.hasGetter());
            if (!this.validateUsage(desc.getXFAVersion(), desc.getAvailability(), false)) {
                bIsFatal = this.validateUsageFailedIsFatal(desc.getXFAVersion(), desc.getAvailability());
                if (bIsFatal && bSuppressExceptions) {
                    return false;
                }
                if (bIsFatal) {
                    MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
                    message.format(scriptThis.getClassAtom());
                    message.format(sPropName);
                    retValue.setException(new ExFull(message));
                    return true;
                }
                reason = new MsgFormatPos(ResId.InvalidScriptVersionException);
                reason.format(this.getClassAtom());
                reason.format(sPropName);
                this.sendMessenge(new ExFull(reason), 3);
            }
            bHasDynamicProp = true;
            bGotDynamicScriptProp = desc.invokeGetProp(this, retValue, sPropName);
        }
        if (!bGotDynamicScriptProp) {
            ScriptPropObj prop = this.getScriptProp(sPropName);
            if (prop != null && prop.hasGetter()) {
                if (!this.validateUsage(prop.getXFAVersion(), prop.getAvailability(), false)) {
                    bIsFatal = this.validateUsageFailedIsFatal(prop.getXFAVersion(), prop.getAvailability());
                    if (bIsFatal && bSuppressExceptions) {
                        return false;
                    }
                    if (bIsFatal) {
                        MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
                        message.format(scriptThis.getClassAtom());
                        message.format(sPropName);
                        retValue.setException(new ExFull(message));
                    } else {
                        reason = new MsgFormatPos(ResId.InvalidScriptVersionException);
                        reason.format(this.getClassAtom());
                        reason.format(sPropName);
                        this.sendMessenge(new ExFull(reason), 3);
                    }
                }
                prop.invokeGetProp(this, retValue, dependencyTracker);
            } else if (prop != null && bHasDynamicProp) {
                MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException);
                message.format(scriptThis.getClassAtom());
                message.format(sPropName);
                retValue.setException(new ExFull(message));
            } else {
                if (bSuppressExceptions) {
                    return false;
                }
                if (sPropName.length() == 0) {
                    MsgFormatPos message = new MsgFormatPos(ResId.NoDefaultGetPropertyException, this.getClassAtom());
                    retValue.setException(new ExFull(message));
                } else {
                    MsgFormatPos message = new MsgFormatPos(ResId.InvalidGetPropertyException, this.getClassAtom());
                    message.format(sPropName);
                    retValue.setException(new ExFull(message));
                }
            }
        }
        if (dependencyTracker != null && (eType = retValue.getArgType()) != 8) {
            dependencyTracker.addDependency(this);
        }
        return true;
    }

    public ScriptTable getScriptTable() {
        return ObjScript.getScriptTable();
    }

    public Obj getScriptThis() {
        return this;
    }

    public boolean invokeFunction(Arg retValue, String sFunctionName, Arg[] parameters, DependencyTracker dependencyTracker, boolean bSuppressExceptions) {
        int eType;
        Obj scriptThis = this.getScriptThis();
        ScriptFuncObj func = this.getScriptMethodInfo(sFunctionName);
        if (func != null) {
            if (!this.validateUsage(func.getXFAVersion(), func.getAvailability(), false)) {
                boolean bIsFatal = this.validateUsageFailedIsFatal(func.getXFAVersion(), func.getAvailability());
                if (bIsFatal && bSuppressExceptions) {
                    return false;
                }
                MsgFormatPos reason = new MsgFormatPos(ResId.InvalidScriptVersionException);
                reason.format(this.getClassAtom());
                reason.format(sFunctionName);
                if (bIsFatal) {
                    throw new ExFull(reason);
                }
                this.sendMessenge(new ExFull(reason), 3);
            }
            if (parameters.length < func.getMinParam()) {
                throw new ExFull(new MsgFormat(ResId.BadParamCountException, sFunctionName));
            }
            for (int i = 0; i < parameters.length; ++i) {
                if (i == func.getParamTypes().length) {
                    throw new ExFull(new MsgFormat(ResId.BadParamCountException, sFunctionName));
                }
                if (func.getParamTypes()[i] == 0 || parameters[i].isCompatibleWith(func.getParamTypes()[i])) continue;
                throw new ExFull(ResId.ArgumentMismatchException);
            }
            if (!func.invokePermsFunc(this, parameters)) {
                MsgFormatPos message = new MsgFormatPos(ResId.PermissionsViolationExceptionMethod);
                message.format(sFunctionName);
                throw new ExFull(message);
            }
            func.invoke(scriptThis, retValue, parameters, dependencyTracker);
            int nRetType = func.getRetType();
            if ((nRetType == 0 || retValue.isCompatibleWith(nRetType)) && bSuppressExceptions) {
                return false;
            }
        } else if (StringUtils.isEmpty(sFunctionName)) {
            if (bSuppressExceptions) {
                return false;
            }
            MsgFormatPos message = new MsgFormatPos(ResId.NoDefaultMethodException);
            message.format(scriptThis.getClassAtom());
            retValue.setException(new ExFull(message));
        } else {
            if (bSuppressExceptions) {
                return false;
            }
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidMethodException);
            message.format(scriptThis.getClassAtom());
            message.format(sFunctionName);
            retValue.setException(new ExFull(message));
        }
        if (dependencyTracker != null && (eType = retValue.getArgType()) != 8) {
            dependencyTracker.addDependency(this);
        }
        return true;
    }

    @Override
    public final boolean isDeaf() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isDeaf();
    }

    @Override
    public final boolean isMute() {
        if (this.mPeers == null) {
            return false;
        }
        return this.mPeers.isMute();
    }

    public final boolean isSameClass(Obj oClass) {
        return oClass.getClassAtom() == this.getClassAtom();
    }

    public final boolean isSameClass(String aClass) {
        return aClass == this.getClassAtom();
    }

    public final boolean isSameClass(int eClassTag) {
        return eClassTag == this.meClassTag;
    }

    @Override
    public final void mute() {
        if (this.mPeers == null) {
            this.mPeers = new PeerImpl(this);
        }
        this.mPeers.mute();
    }

    @Override
    public void notifyPeers(int eventType, String arg1, Object arg2) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.notifyPeers(eventType, arg1, arg2);
    }

    @Override
    public final void removePeer(Peer peerNode) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeer(peerNode);
    }

    @Override
    public final void removePeeredNode(Peer peer) {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.removePeeredNode(peer);
    }

    public void sendMessenge(ExFull error, int eSeverity) {
    }

    public boolean setScriptProperty(String sPropertyName, Arg propertyValue, boolean bSuppressExceptions) {
        ScriptDynamicPropObj desc;
        boolean bPropertyOverride = sPropertyName.startsWith("#");
        String sPropName = bPropertyOverride ? sPropertyName.substring(1) : sPropertyName;
        boolean bError = false;
        Obj scriptThis = this.getScriptThis();
        if (sPropertyName.length() != 0 && (desc = scriptThis.getDynamicScriptProp(sPropName, bPropertyOverride, false)) != null) {
            Arg retVal;
            boolean bGetProp;
            boolean bReturnVal = false;
            if (!this.validateUsage(desc.getXFAVersion(), desc.getAvailability(), false)) {
                boolean bIsFatal = this.validateUsageFailedIsFatal(desc.getXFAVersion(), desc.getAvailability());
                if (bIsFatal && bSuppressExceptions) {
                    return false;
                }
                MsgFormatPos reason = new MsgFormatPos(ResId.InvalidScriptVersionException);
                reason.format(this.getClassAtom());
                reason.format(sPropName);
                if (bIsFatal) {
                    throw new ExFull(reason);
                }
                this.sendMessenge(new ExFull(reason), 3);
            }
            if (desc.hasSetter()) {
                if (!desc.invokePermsFunc(this)) {
                    MsgFormatPos message = new MsgFormatPos(ResId.PermissionsViolationExceptionProperty);
                    if (StringUtils.isEmpty(sPropName)) {
                        message.format(this.getClassAtom());
                    } else {
                        message.format(sPropName);
                    }
                    throw new ExFull(message);
                }
                bReturnVal = desc.invokeSetProp(this, propertyValue, sPropName);
            }
            if (bReturnVal) {
                return true;
            }
            if (desc.hasGetter() && (bGetProp = desc.invokeGetProp(this, retVal = new Arg(), sPropName)) && retVal.getArgType() == 7) {
                Obj obj = retVal.getObject();
                return obj.setScriptProperty("", propertyValue, bSuppressExceptions);
            }
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
            message.format(scriptThis.getClassAtom());
            message.format(sPropertyName);
            throw new ExFull(message);
        }
        if (!bError) {
            ScriptPropObj prop = this.getScriptProp(sPropName);
            if (prop != null) {
                if (!this.validateUsage(prop.getXFAVersion(), prop.getAvailability(), false)) {
                    boolean bIsFatal = this.validateUsageFailedIsFatal(prop.getXFAVersion(), prop.getAvailability());
                    if (bIsFatal && bSuppressExceptions) {
                        return false;
                    }
                    MsgFormatPos reason = new MsgFormatPos(ResId.InvalidScriptVersionException);
                    reason.format(this.getClassAtom());
                    reason.format(sPropertyName);
                    if (bIsFatal) {
                        throw new ExFull(reason);
                    }
                    this.sendMessenge(new ExFull(reason), 3);
                }
                if (prop.hasSetter()) {
                    if (prop.getParamType() != 0 && !propertyValue.isCompatibleWith(prop.getParamType())) {
                        throw new ExFull(ResId.ArgumentMismatchException);
                    }
                    if (!prop.invokePermsFunc(this)) {
                        MsgFormatPos message = new MsgFormatPos(ResId.PermissionsViolationExceptionProperty);
                        message.format(sPropName);
                        throw new ExFull(message);
                    }
                    Model oModel = null;
                    LogMessenger oTempLogMessenger = new LogMessenger();
                    LogMessenger oSaveLogMessenger = null;
                    int nStartErrorCount = 0;
                    if (this instanceof Element) {
                        oModel = ((Element)this).getModel();
                    }
                    if (oModel != null) {
                        oSaveLogMessenger = oModel.getLogMessenger();
                        oModel.setLogMessenger(oTempLogMessenger);
                        nStartErrorCount = oModel.getErrorList().size();
                    }
                    bError = prop.invokeSetProp(this, propertyValue);
                    if (oModel != null) {
                        oTempLogMessenger.removeStoredMessages();
                        oModel.setLogMessenger(oSaveLogMessenger);
                        if (oModel.getErrorList().size() > nStartErrorCount) {
                            int nErrors = oModel.getErrorList().size();
                            ExFull oError = oModel.getErrorList().get(nErrors - 1);
                            oModel.removeLastError();
                            MsgFormatPos sError = new MsgFormatPos(oError.toString());
                            throw new ExFull(sError);
                        }
                    }
                    if (!bError) {
                        return true;
                    }
                }
                MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
                message.format(scriptThis.getClassAtom());
                message.format(sPropertyName);
                throw new ExFull(message);
            }
            if (sPropName.length() == 0) {
                if (bSuppressExceptions) {
                    return false;
                }
                MsgFormatPos message = new MsgFormatPos(ResId.NoDefaultSetPropertyException, this.getClassAtom());
                throw new ExFull(message);
            }
            if (bSuppressExceptions) {
                return false;
            }
            MsgFormatPos message = new MsgFormatPos(ResId.InvalidSetPropertyException);
            message.format(scriptThis.getClassAtom());
            message.format(sPropertyName);
            throw new ExFull(message);
        }
        return true;
    }

    @Override
    public final void unDeafen() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unDeafen();
    }

    @Override
    public final void unMute() {
        if (this.mPeers == null) {
            return;
        }
        this.mPeers.unMute();
    }

    @Override
    public void updateFromPeer(Object peerNode, int eventType, String arg1, Object arg2) {
    }

    @Override
    public void peerRemoved(Peer peer) {
    }

    public boolean validateUsage(int nXFAVersion, int nAvailability, boolean bUpdateVersion) {
        return true;
    }

    public boolean validateUsageFailedIsFatal(int nXFAVersion, int nAvailability) {
        return false;
    }
}

