/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.agent;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.ListBase;
import com.adobe.xfa.LogMessage;
import com.adobe.xfa.LogMessenger;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Node;
import com.adobe.xfa.Packet;
import com.adobe.xfa.XSLTranslator;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.configuration.ConfigurationModelFactory;
import com.adobe.xfa.configuration.ConfigurationSchema;
import com.adobe.xfa.configuration.ConfigurationValue;
import com.adobe.xfa.connectionset.ConnectionSetModel;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.data.DataModelFactory;
import com.adobe.xfa.service.storage.PacketHandler;
import com.adobe.xfa.service.storage.XMLStorage;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;

public abstract class Agent
implements PacketHandler {
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final int SUCCESS_WITH_WARNINGS = 2;
    public static final int SUCCESS_WITH_INFORMATION = 3;
    protected static final int UNKNOWN = 0;
    protected static final int CONFIG = 1;
    protected static final int DATA = 2;
    protected static final int TEMPLATE = 3;
    protected static final int XDC = 4;
    protected static final int SOURCESET = 5;
    protected static final int CONNECTIONSET = 6;
    protected static final int XDP = 7;
    protected static final int LOCALESET = 8;
    protected static final int XSL = 9;
    private boolean mbXDPLoadedConfig = false;
    private boolean mbXDPLoadedConnectionSet = false;
    private boolean mbXDPLoadedData = false;
    private boolean mbXDPLoadedSourceSet = false;
    private boolean mbXDPLoadedTemplate = false;
    private boolean mbXDPLoadedXDC = false;
    private boolean mbIsDataIncremental = false;
    private AppModel moAppModel = null;
    private ConfigurationModelFactory moConfigFactory = null;
    private DataModelFactory moDataFactory = null;
    private final LogMessenger moMessenger = new LogMessenger();
    private InputStream moConfigurationStream = null;
    private InputStream moXDPStream = null;
    private String msPacketList = null;
    private static final Trace goGeneralTrace = new Trace("general", ResId.GeneralTraceHelp);

    public Agent() {
        this.reset();
    }

    protected void reset() {
        this.moAppModel = new AppModel(this.moMessenger);
        this.moDataFactory = new DataModelFactory();
        this.moAppModel.addFactory(this.moDataFactory);
        this.moConfigFactory = new ConfigurationModelFactory();
        this.moAppModel.addFactory(this.moConfigFactory);
        this.setPacketList("");
    }

    void activateTracing() {
    }

    protected void checkXDPOptions(BooleanHolder oSaveAsXDP, BooleanHolder oIsMergedXDP, BooleanHolder oEmbedRenderedOutput) {
        String sEmbed;
        ConfigurationValue oConfigurationValue;
        Node oContextNode = this.getContextNode();
        oSaveAsXDP.value = false;
        oIsMergedXDP.value = false;
        String sOutputType = "native";
        Node oResolvedNode = null;
        if (oContextNode != null) {
            oResolvedNode = oContextNode.resolveNode("output.type");
        }
        if (oResolvedNode instanceof ConfigurationValue) {
            oConfigurationValue = (ConfigurationValue)oResolvedNode;
            sOutputType = oConfigurationValue.getValue().toString();
            if (sOutputType.equalsIgnoreCase("xdp")) {
                oSaveAsXDP.value = true;
            } else if (sOutputType.equalsIgnoreCase("mergedXDP")) {
                oSaveAsXDP.value = true;
                oIsMergedXDP.value = true;
            }
        }
        oEmbedRenderedOutput.value = false;
        if (sOutputType.equalsIgnoreCase("xdp") && (oResolvedNode = oContextNode.resolveNode("xdp.embedRenderedOutput")) instanceof ConfigurationValue && (sEmbed = (oConfigurationValue = (ConfigurationValue)oResolvedNode).getValue().toString()).equalsIgnoreCase("1")) {
            oEmbedRenderedOutput.value = true;
        }
    }

    @Override
    public void filterPackets(Node oPacket, Object data) {
        Element oPacketNode = null;
        if (oPacket instanceof Element) {
            oPacketNode = (Element)oPacket;
        }
        if (oPacketNode != null) {
            boolean bInList;
            String sLocalName = oPacketNode.getLocalName();
            String sPackets = this.getPacketList();
            boolean bExclude = sPackets.startsWith("-");
            if (sPackets.length() != 0 && !sPackets.equals("*") && ((bInList = sPackets.contains(sLocalName)) && bExclude || !bInList && !bExclude)) {
                oPacketNode.getXMLParent().removeChild(oPacketNode);
                return;
            }
            AppModel oApp = this.getAppModel();
            List<ModelFactory> factories = oApp.factories();
            for (int i = 0; i < factories.size(); ++i) {
                ModelFactory oFactory = factories.get(i);
                if (!oFactory.isRootName(sLocalName)) continue;
                if (oPacketNode.getFirstXMLChild() == null) {
                    oPacketNode.getXMLParent().removeChild(oPacketNode);
                    return;
                }
                if (oFactory instanceof ConfigurationModelFactory) {
                    this.setDataLoadOptions(null);
                    LogMessenger oMessenger = this.getMessenger();
                    if (oMessenger != null) {
                        oMessenger.updateMessaging(ConfigurationModel.getConfigurationModel(oApp, false));
                    }
                    this.activateTracing();
                    return;
                }
                if (!(oFactory instanceof DataModelFactory)) break;
                this.setDataLoadOptions(null);
                break;
            }
        }
    }

    protected AppModel getAppModel() {
        return this.moAppModel;
    }

    protected int getCompletionStatus(LogMessenger oMessenger) {
        int cc = 0;
        int eSeverity = oMessenger == null ? 6 : oMessenger.getSeverity();
        switch (eSeverity) {
            case 2: {
                cc = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                cc = 2;
                break;
            }
            case 6: {
                cc = 1;
            }
        }
        return cc;
    }

    protected ConfigurationModel getConfigModel() {
        return ConfigurationModel.getConfigurationModel(this.getAppModel(), false);
    }

    protected ConnectionSetModel getConnectionSetModel() {
        return ConnectionSetModel.getConnectionSetModel(this.getAppModel(), false);
    }

    public abstract String getConfigSchemaName();

    protected Node getContextNode() {
        ConfigurationModel oConfigModel = this.getConfigModel();
        if (oConfigModel == null) {
            oConfigModel = ConfigurationModel.getConfigurationModel(this.getAppModel(), true);
        }
        return oConfigModel.getCommonNode(this.getConfigSchemaName());
    }

    protected DataModel getDataModel() {
        for (Node node = this.moAppModel.getFirstXFAChild(); node != null; node = node.getNextXFASibling()) {
            if (node.getClassName() != "dataModel") continue;
            return (DataModel)node;
        }
        return null;
    }

    String getDefaultConfiguration(String sSchemaName) {
        ConfigurationSchema oSchema = new ConfigurationSchema();
        return oSchema.printConfigSchema(this.getConfigSchemaName(), "", false);
    }

    protected LogMessenger getMessenger() {
        return this.moMessenger;
    }

    public String getPacketList() {
        return this.msPacketList;
    }

    protected TemplateModel getTemplateModel() {
        return TemplateModel.getTemplateModel(this.getAppModel(), false);
    }

    protected String getXDCDest(boolean bReportError) {
        String sXDCDest = "";
        Node oContextNode = this.getContextNode();
        if (oContextNode != null) {
            Node resolvedNode = oContextNode.resolveNode("destination");
            if (resolvedNode instanceof ConfigurationValue) {
                ConfigurationValue oConfigurationValue = (ConfigurationValue)resolvedNode;
                sXDCDest = oConfigurationValue.getValue().toString();
            }
            if (bReportError && sXDCDest.length() == 0) {
                throw new ExFull(ResId.DestinationNotSpecifiedError);
            }
        }
        return sXDCDest;
    }

    String getXFAModelConfigURI(int eType) {
        StringBuilder sConfigURI = new StringBuilder();
        switch (eType) {
            case 4: {
                sConfigURI.append(this.getXDCDest(true));
                sConfigURI.append('.');
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                sConfigURI.append(this.getXFAModelName(eType));
                sConfigURI.append('.');
            }
            case 7: {
                sConfigURI.append("uri");
            }
        }
        return sConfigURI.toString();
    }

    int getXFAModelMessageFileNotFound(int eType) {
        switch (eType) {
            case 1: {
                return ResId.ConfigFileNotFound;
            }
            case 4: {
                return ResId.XDCFileNotFound;
            }
            case 3: {
                return ResId.TemplateFileNotFound;
            }
            case 5: {
                return ResId.SourceSetFileNotFound;
            }
            case 6: {
                return ResId.ConnectionSetFileNotFound;
            }
            case 7: {
                return ResId.XDPFileNotFound;
            }
        }
        return ResId.DataFileNotFound;
    }

    int getXFAModelMessageFileNotSpecified(int eType) {
        switch (eType) {
            case 4: {
                return ResId.XDCFileNotSpecified;
            }
            case 2: {
                return ResId.DataFileNotSpecified;
            }
            case 3: {
                return ResId.TemplateFileNotSpecified;
            }
            case 5: {
                return ResId.SourceSetFileNotSpecified;
            }
            case 6: {
                return ResId.ConnectionSetFileNotSpecified;
            }
            case 7: {
                return ResId.XDPFileNotSpecified;
            }
        }
        return ResId.ConfigFileNotSpecified;
    }

    String getXFAModelName(int eType) {
        switch (eType) {
            case 1: {
                return "config";
            }
            case 4: {
                return "xdc";
            }
            case 2: {
                return "data";
            }
            case 3: {
                return "template";
            }
            case 5: {
                return "sourceSet";
            }
            case 6: {
                return "connectionSet";
            }
            case 8: {
                return "localeSet";
            }
            case 9: {
                return "xsl";
            }
        }
        return null;
    }

    InputStream getXFAModelStream(int eType) {
        switch (eType) {
            case 1: {
                return this.moConfigurationStream;
            }
            case 7: {
                return this.moXDPStream;
            }
        }
        return null;
    }

    int getXFAModelType(String sModelName) {
        if (sModelName.equals("config")) {
            return 1;
        }
        if (sModelName.equals("xdc")) {
            return 4;
        }
        if (sModelName.equals("data")) {
            return 2;
        }
        if (sModelName.equals("datasets")) {
            return 2;
        }
        if (sModelName.equals("template")) {
            return 3;
        }
        if (sModelName.equals("sourceSet")) {
            return 5;
        }
        if (sModelName.equals("connectionSet")) {
            return 6;
        }
        if (sModelName.equals("localeSet")) {
            return 8;
        }
        if (sModelName.equals("xsl")) {
            return 9;
        }
        return 0;
    }

    boolean getXFAPacketLoaded(int eType) {
        switch (eType) {
            case 4: {
                return this.mbXDPLoadedXDC;
            }
            case 1: {
                return this.mbXDPLoadedConfig;
            }
            case 3: {
                return this.mbXDPLoadedTemplate;
            }
            case 2: {
                return this.mbXDPLoadedData;
            }
            case 5: {
                return this.mbXDPLoadedSourceSet;
            }
            case 6: {
                return this.mbXDPLoadedConnectionSet;
            }
        }
        return false;
    }

    void getXSLOptions(String sModelName, StringBuilder sLoadOptions, StringBuilder sDebugXSL) {
        Node oContextNode = this.getContextNode();
        if (oContextNode != null) {
            ConfigurationValue oConfigurationValue;
            String sValue;
            Node resolvedNode = oContextNode.resolveNode(sModelName + ".xsl.uri");
            if (resolvedNode instanceof ConfigurationValue && !StringUtils.isEmpty(sValue = (oConfigurationValue = (ConfigurationValue)resolvedNode).getValue().toString())) {
                sLoadOptions.append(" XSL=\"").append(sValue).append('\"');
            }
            if ((resolvedNode = oContextNode.resolveNode(sModelName + ".xsl.debug.uri")) instanceof ConfigurationValue && (sValue = (oConfigurationValue = (ConfigurationValue)resolvedNode).getValue().toString()).length() != 0) {
                sDebugXSL.append(sValue);
            }
        }
    }

    boolean isPacketLoaded(int eType, boolean bRemove) {
        if (this.isXFAModelLoaded(eType, bRemove)) {
            this.setXFAPacketLoaded(eType, !bRemove);
            return true;
        }
        this.setXFAPacketLoaded(eType, false);
        return false;
    }

    boolean isPacketLoaded(String oPacketList, boolean bRemove) {
        if (oPacketList != null) {
            if (oPacketList.length() == 0 || oPacketList.equals("*")) {
                return true;
            }
            if (oPacketList.charAt(0) == '-') {
                return true;
            }
            StringTokenizer sTemp = new StringTokenizer(oPacketList);
            while (sTemp.hasMoreTokens()) {
                String sToken = sTemp.nextToken();
                int eType = this.getXFAModelType(sToken);
                if (this.isPacketLoaded(eType, bRemove) || bRemove) continue;
                return false;
            }
        }
        return true;
    }

    boolean isXFAModelInXDP(int eType, boolean bMergeConfig) {
        ConfigurationValue oConfigurationValue;
        String sConfigSourceFile;
        Node resolvedNode;
        Node oContextNode;
        if (this.moXDPStream == null && (oContextNode = this.getContextNode()) != null && (resolvedNode = oContextNode.resolveNode("uri")) instanceof ConfigurationValue && !StringUtils.isEmpty(sConfigSourceFile = (oConfigurationValue = (ConfigurationValue)resolvedNode).getValue().toString())) {
            this.setXFAInput(7, sConfigSourceFile);
        }
        if (this.moXDPStream != null) {
            XMLStorage oXMLStorage = new XMLStorage();
            if (this.getXFAPacketLoaded(eType)) {
                return true;
            }
            ConfigurationModel oOldConfig = null;
            if (bMergeConfig) {
                oOldConfig = this.getConfigModel();
                oOldConfig.remove();
            }
            AppModel oApp = this.getAppModel();
            if (eType == 2) {
                this.setDataLoadOptions(oXMLStorage);
                String sLoadOptions = "Model=\"datasets\"";
                oXMLStorage.loadModel(oApp, this.moXDPStream, sLoadOptions, null);
            } else {
                this.setPacketList(this.getXFAModelName(eType));
                oApp.setPacketList(this.getPacketList());
                oXMLStorage.loadXDP(oApp, this.moXDPStream, null, null, true);
            }
            if (bMergeConfig) {
                ConfigurationModel oNewConfig = ConfigurationModel.getConfigurationModel(oApp, true);
                oNewConfig.mergeModel(oOldConfig);
            }
            if (this.isPacketLoaded(eType, false)) {
                return true;
            }
        }
        return false;
    }

    boolean isXFAModelLoaded(int eType, boolean bRemove) {
        String aExpectedModelName = null;
        aExpectedModelName = eType == 2 ? "datasets" : this.getXFAModelName(eType);
        for (Node oChild = this.getAppModel().getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
            if (oChild.getName() != aExpectedModelName) continue;
            if (bRemove) {
                oChild.remove();
                return true;
            }
            if (oChild.getFirstXFAChild() == null) continue;
            if (eType == 2 && oChild.getFirstXFAChild().getFirstXFAChild() == null) break;
            return true;
        }
        return false;
    }

    boolean isXFAModelRequired(int eType) {
        switch (eType) {
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected boolean loadXFAModel(InputStream is, String oPacketList, boolean bReload) {
        XMLStorage oXMLStorage = new XMLStorage();
        if (oPacketList != null) {
            this.setPacketList(oPacketList);
            this.getAppModel().setPacketList(oPacketList);
            if (bReload) {
                this.isPacketLoaded(oPacketList, true);
            }
        }
        if (is.markSupported()) {
            is.mark(Integer.MAX_VALUE);
        }
        if (!oXMLStorage.loadXDP(this.getAppModel(), is, null, null, true) && (oPacketList == null || oPacketList.length() == 0 || oPacketList.equals("*") || oPacketList.contains("datasets"))) {
            StringBuilder sLoadOptions = new StringBuilder();
            sLoadOptions.append("Model=\"");
            sLoadOptions.append("data");
            sLoadOptions.append('\"');
            StringBuilder sDebugXSL = new StringBuilder();
            this.getXSLOptions("data", sLoadOptions, sDebugXSL);
            this.setDataLoadOptions(oXMLStorage);
            try {
                is.reset();
            }
            catch (IOException e) {
                return false;
            }
            oXMLStorage.loadModel(this.getAppModel(), is, sLoadOptions.toString(), sDebugXSL.toString());
            if (this.getDataModel() == null) {
                return false;
            }
        }
        return this.isPacketLoaded(oPacketList, false);
    }

    protected boolean loadXFAModel(int eType, boolean bReload) {
        StringBuilder sSOMName = new StringBuilder();
        InputStream oInputStream = this.resolveModelInput(eType, sSOMName);
        if (oInputStream == null) {
            return false;
        }
        this.outputTraceMessage(ResId.GeneralTraceLoadDom, this.getXFAModelName(eType));
        XMLStorage oXMLStorage = new XMLStorage();
        if (bReload) {
            this.isPacketLoaded(eType, true);
        }
        if (!this.getXFAPacketLoaded(eType)) {
            String sExpectedModelName = eType == 2 ? "datasets" : this.getXFAModelName(eType);
            StringBuilder sLoadOptions = new StringBuilder();
            sLoadOptions.append("Model=\"");
            sLoadOptions.append(sExpectedModelName);
            sLoadOptions.append('\"');
            StringBuilder sDebugXSL = new StringBuilder();
            this.getXSLOptions(sSOMName.toString(), sLoadOptions, sDebugXSL);
            if (eType != 3 && eType == 2) {
                this.setDataLoadOptions(oXMLStorage);
            }
            oXMLStorage.loadModel(this.getAppModel(), oInputStream, sLoadOptions.toString(), sDebugXSL.toString());
            if (eType == 7 && this.moXDPStream != null) {
                try {
                    this.moXDPStream.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.moXDPStream = null;
            }
            if (this.isXFAModelLoaded(eType, false)) {
                return true;
            }
            MsgFormatPos formatError = new MsgFormatPos(ResId.XFAAgentWrongFileType);
            formatError.format(this.getXFAModelName(eType));
            throw new ExFull(formatError);
        }
        return true;
    }

    void outputTraceMessage(int nResId, String sInput) {
        if (goGeneralTrace.isEnabled(1)) {
            MsgFormatPos oFormatPos = new MsgFormatPos(nResId);
            if (sInput.length() > 0) {
                oFormatPos.format(sInput);
            }
            goGeneralTrace.trace(1, oFormatPos);
        }
    }

    InputStream resolveModelInput(int eType, StringBuilder oSOMName) {
        InputStream oInputStream = this.getXFAModelStream(eType);
        oSOMName.append(this.getXFAModelName(eType));
        if (oInputStream == null) {
            if (this.setConfigInputStream(eType)) {
                oInputStream = this.getXFAModelStream(eType);
            }
            if (oInputStream == null && this.isXFAModelInXDP(eType, false)) {
                oInputStream = this.getXFAModelStream(7);
            }
            if (oInputStream == null && this.isXFAModelRequired(eType)) {
                LogMessage oMessage = new LogMessage();
                MsgFormatPos formatError = new MsgFormatPos(this.getXFAModelMessageFileNotFound(eType));
                formatError.format(this.getXFAModelConfigURI(eType));
                oMessage.insertMessage(formatError, 6, "");
                this.getMessenger().sendMessage(oMessage);
                return null;
            }
        }
        if (oInputStream != null) {
            if (this.isXFAModelRequired(eType)) {
                LogMessage oMessage = new LogMessage();
                MsgFormatPos formatError = new MsgFormatPos(this.getXFAModelMessageFileNotSpecified(eType));
                oMessage.insertMessage(formatError, 6, "");
                this.getMessenger().sendMessage(oMessage);
            }
            return null;
        }
        return oInputStream;
    }

    void saveDataModel(OutputStream oStream) {
        ConfigurationValue oConfigurationValue;
        String sFile;
        Node oResolvedNode;
        XMLStorage xml = new XMLStorage();
        DataModel oDataModel = this.getDataModel();
        Node oContextNode = this.getContextNode();
        if (oContextNode != null && (oResolvedNode = oContextNode.resolveNode("data.outputXSL.uri")) instanceof ConfigurationValue && !StringUtils.isEmpty(sFile = (oConfigurationValue = (ConfigurationValue)oResolvedNode).getValue().toString())) {
            File oFileID = new File(sFile);
            if (!oFileID.exists()) {
                throw new ExFull(new MsgFormatPos(ResId.XSLFileNotFound, sFile));
            }
            FileInputStream oXSLStream = null;
            try {
                ByteArrayOutputStream oTempOutput = new ByteArrayOutputStream();
                xml.saveModelAs(oDataModel, oTempOutput, "");
                ByteArrayInputStream oTempInput = new ByteArrayInputStream(oTempOutput.toByteArray());
                oXSLStream = new FileInputStream(oFileID);
                XSLTranslator translator = new XSLTranslator(oXSLStream);
                translator.process(oTempInput, oStream);
                return;
            }
            catch (IOException e) {
                throw new ExFull(e);
            }
            finally {
                try {
                    if (oXSLStream != null) {
                        oXSLStream.close();
                    }
                }
                catch (IOException ex) {}
            }
        }
        xml.saveModelAs(oDataModel, oStream, "");
    }

    void saveSimpleXDP(String sPacketList, OutputStream oStream) {
        Node oPackets;
        String sPackets;
        DataModel oDataModel;
        Node oTemplateOptions;
        Element oClone;
        Node oChild;
        ArrayNodeList oNodesToSave = new ArrayNodeList();
        boolean bIncludeData = true;
        AppModel oAppModel = this.getAppModel();
        ConfigurationModel oConfigModel = this.getConfigModel();
        TemplateModel oTemplateModel = this.getTemplateModel();
        ConnectionSetModel oCSModel = this.getConnectionSetModel();
        String sConfigNS = ConfigurationModel.configurationNS();
        Element oAcrobat = oConfigModel.createElement(oConfigModel, null, sConfigNS, "acrobat", "acrobat", null, 0, null);
        Element oCommon = oConfigModel.createElement(oAcrobat, null, sConfigNS, "common", "common", null, 0, null);
        Node oDataOptions = this.getContextNode().resolveNode("common.data");
        if (oDataOptions instanceof ConfigurationValue) {
            Element oRoot;
            Document oDoc;
            FileInputStream oXSLStream;
            String sXSLFile;
            File oXSLFileID;
            ConfigurationValue oConfigValue = (ConfigurationValue)oDataOptions.resolveNode("xsl.uri");
            if (oConfigValue != null && oConfigValue.getXFAChildCount() == 1 && (oXSLFileID = new File(sXSLFile = oConfigValue.getValue().toString())).exists()) {
                oXSLStream = null;
                try {
                    oXSLStream = new FileInputStream(oXSLFileID);
                    oDoc = oAppModel.getDocument();
                    oRoot = oDoc.loadIntoDocument(oXSLStream);
                    for (oChild = oRoot.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
                        if (!(oChild instanceof Element)) continue;
                        Packet oDataInputXSL = new Packet(oAppModel, null);
                        oDataInputXSL.setXmlPeer(oChild);
                        oDataInputXSL.setAttribute("XFADataInputXSL", "id");
                        ((ListBase)oNodesToSave).append(oDataInputXSL);
                        break;
                    }
                }
                catch (IOException e) {
                    throw new ExFull(e);
                }
                finally {
                    try {
                        if (oXSLStream != null) {
                            oXSLStream.close();
                        }
                    }
                    catch (IOException ex) {}
                }
            }
            if ((oConfigValue = (ConfigurationValue)oDataOptions.resolveNode("outputXSL.uri")) != null && oConfigValue.getXFAChildCount() == 1 && (oXSLFileID = new File(sXSLFile = oConfigValue.getValue().toString())).exists()) {
                oXSLStream = null;
                try {
                    oXSLStream = new FileInputStream(oXSLFileID);
                    oDoc = oAppModel.getDocument();
                    oRoot = oDoc.loadIntoDocument(oXSLStream);
                    for (oChild = oRoot.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
                        if (!(oChild instanceof Element)) continue;
                        Packet oDataOutputXSL = new Packet(oAppModel, oChild);
                        oDataOutputXSL.setAttribute("XFADataOutputXSL", "id");
                        ((ListBase)oNodesToSave).append(oDataOutputXSL);
                        break;
                    }
                }
                catch (IOException e) {
                    throw new ExFull(e);
                }
                finally {
                    try {
                        if (oXSLStream != null) {
                            oXSLStream.close();
                        }
                    }
                    catch (IOException ex) {}
                }
            }
            if (this.mbIsDataIncremental) {
                bIncludeData = false;
            }
            oClone = ((ConfigurationValue)oDataOptions).clone(null, true);
            oCommon.getNodes().append(oClone);
            ((ListBase)oNodesToSave).append(oConfigModel);
        }
        if ((oTemplateOptions = this.getContextNode().resolveNode("common.template")) instanceof ConfigurationValue) {
            oClone = ((ConfigurationValue)oTemplateOptions).clone(null, true);
            oCommon.getNodes().append(oClone);
        }
        ((ListBase)oNodesToSave).append(oTemplateModel);
        if (oCSModel != null) {
            ((ListBase)oNodesToSave).append(oCSModel);
        }
        if (bIncludeData && (oDataModel = this.getDataModel()) != null) {
            ((ListBase)oNodesToSave).append(oDataModel);
        }
        Element oUser = null;
        Element oMaster = null;
        Node oPDFEncryption = oConfigModel.resolveNode("$config.present.pdf.encryption");
        if (oPDFEncryption instanceof Element) {
            if (((Element)oPDFEncryption).isPropertySpecified(336, true, 0)) {
                oUser = ((Element)oPDFEncryption).getElement(336, false, 0, false, false);
                oUser.isHidden(true);
            }
            if (((Element)oPDFEncryption).isPropertySpecified(185, true, 0)) {
                oMaster = ((Element)oPDFEncryption).getElement(185, false, 0, false, false);
                oMaster.isHidden(true);
            }
        }
        if ((sPackets = sPacketList).length() == 0 && (oPackets = this.getContextNode().resolveNode("xdp.packets")) instanceof ConfigurationValue) {
            ConfigurationValue oConfigurationValue = (ConfigurationValue)oPackets;
            sPackets = oConfigurationValue.getValue().toString();
        }
        if (sPackets.length() != 0) {
            boolean bAllPackets = sPackets.equals("*");
            oNodesToSave = new ArrayNodeList();
            block20: for (oChild = oAppModel.getFirstXFAChild(); oChild != null; oChild = oChild.getNextXFASibling()) {
                if (bAllPackets) {
                    ((ListBase)oNodesToSave).append(oChild);
                    continue;
                }
                String packetName = oChild.getName();
                StringTokenizer sPacketsCopy = new StringTokenizer(sPackets);
                while (sPacketsCopy.hasMoreTokens()) {
                    String sToken = sPacketsCopy.nextToken();
                    if (!sToken.equals(packetName)) continue;
                    ((ListBase)oNodesToSave).append(oChild);
                    continue block20;
                }
            }
        }
        XMLStorage oStorage = new XMLStorage();
        oStorage.saveAggregate(null, oStream, oNodesToSave, "");
        if (oUser != null) {
            oUser.isHidden(false);
        }
        if (oMaster != null) {
            oMaster.isHidden(false);
        }
    }

    boolean setConfigInputStream(int eType) {
        ConfigurationValue oConfigurationValue;
        String sConfigSourceFile;
        Node resolvedNode;
        String sConfigURI = this.getXFAModelConfigURI(eType);
        Node oContextNode = this.getContextNode();
        if (oContextNode != null && !StringUtils.isEmpty(sConfigURI) && (resolvedNode = oContextNode.resolveNode(sConfigURI)) instanceof ConfigurationValue && !StringUtils.isEmpty(sConfigSourceFile = (oConfigurationValue = (ConfigurationValue)resolvedNode).getValue().toString())) {
            this.setXFAInput(eType, sConfigSourceFile);
            return true;
        }
        return false;
    }

    void setDataLoadOptions(XMLStorage oXMLStorage) {
        Node oContextNode = this.getContextNode();
        Node oResolvedNode = null;
        this.moDataFactory.reset();
        if (oContextNode != null && (oResolvedNode = oContextNode.resolveNode("data")) != null) {
            if (oResolvedNode.getFirstXFAChild() == null) {
                return;
            }
            StringBuilder sExclNS = new StringBuilder();
            for (Node node = oResolvedNode.getFirstXFAChild(); node != null; node = node.getNextXFASibling()) {
                if (!(node instanceof Element)) continue;
                Element child = (Element)node;
                String sName = child.getName();
                if (sName.equals("transform")) {
                    String sOptionName = "data_transform";
                    StringBuilder sTransform = new StringBuilder();
                    sTransform.append("ref");
                    sTransform.append("='");
                    sTransform.append(child.getAttribute(392).toString());
                    sTransform.append('\'');
                    ConfigurationValue oConfigVal = (ConfigurationValue)child.getFirstXFAChild();
                    while (child != null) {
                        sTransform.append(' ');
                        Attribute oValue = oConfigVal.getValue();
                        sTransform.append(oConfigVal.getName());
                        sTransform.append("='");
                        sTransform.append(oValue.toString());
                        sTransform.append('\'');
                        child = (ConfigurationValue)child.getNextXFASibling();
                    }
                    this.moDataFactory.setOption(sOptionName, sTransform.toString(), false);
                    continue;
                }
                if (child.isContainer()) continue;
                String sValue = "";
                if (child instanceof ConfigurationValue) {
                    sValue = ((ConfigurationValue)child).getValue().toString();
                }
                if (sName.equals("uri")) continue;
                if (sName.equals("excludeNS") && !StringUtils.isEmpty(sValue)) {
                    if (sExclNS.length() != 0) {
                        sExclNS.append(' ');
                    }
                    sExclNS.append(sValue);
                    this.moDataFactory.setOption("excludeNS", sExclNS.toString(), false);
                    continue;
                }
                if (StringUtils.isEmpty(sValue) || sName.equals("adjustData")) continue;
                this.moDataFactory.setOption(sName, sValue, false);
            }
        }
    }

    void setDataModel(Model oModel) {
    }

    void setPacketList(String sPacketList) {
        this.msPacketList = sPacketList;
    }

    protected void setXFAInput(int eModel, String sInputFile) {
        if (StringUtils.isEmpty(sInputFile)) {
            return;
        }
        InputStream oStream = null;
        try {
            oStream = new URL(sInputFile).openStream();
        }
        catch (Exception e) {
            try {
                oStream = new FileInputStream(sInputFile);
            }
            catch (IOException f) {
                // empty catch block
            }
        }
        this.setXFAInput(eModel, oStream);
    }

    protected void setXFAInput(int eModel, InputStream oStream) {
        if (oStream != null) {
            switch (eModel) {
                case 1: {
                    this.moConfigurationStream = oStream;
                    break;
                }
                case 7: {
                    this.moXDPStream = oStream;
                }
            }
        }
    }

    void setXFAPacketLoaded(int eType, boolean bLoaded) {
        switch (eType) {
            case 4: {
                this.mbXDPLoadedXDC = bLoaded;
                break;
            }
            case 1: {
                this.mbXDPLoadedConfig = bLoaded;
                break;
            }
            case 3: {
                this.mbXDPLoadedTemplate = bLoaded;
                break;
            }
            case 2: {
                this.mbXDPLoadedData = bLoaded;
                break;
            }
            case 5: {
                this.mbXDPLoadedSourceSet = bLoaded;
                break;
            }
            case 6: {
                this.mbXDPLoadedConnectionSet = bLoaded;
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                break;
            }
        }
    }
}

