/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.Obj;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormChoiceListField;
import com.adobe.xfa.form.FormExclGroup;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.form.FormSubform;
import com.adobe.xfa.ut.Peer;

public class FormDataListener
extends Obj {
    private Element mFormNode;
    private DataNode mDataNode;

    public FormDataListener(Element formNode, DataNode dataNode) {
        this.mFormNode = formNode;
        this.mDataNode = dataNode;
        this.mFormNode.addPeer(this);
        this.mDataNode.addPeer(this);
        this.mFormNode.setMapped(true);
    }

    void dispose() {
        if (this.mFormNode != null) {
            this.mFormNode.setMapped(false);
            this.mFormNode.removePeer(this);
        }
        if (this.mDataNode != null) {
            this.mDataNode.setMapped(false);
            this.mDataNode.removePeer(this);
        }
    }

    public DataNode getDataNode() {
        return this.mDataNode;
    }

    public Element getFormNode() {
        return this.mFormNode;
    }

    public void setDataNode(DataNode newDataNode) {
        this.mDataNode.removePeer(this);
        assert (this.mDataNode == null);
        this.mDataNode = newDataNode;
        this.mDataNode.addPeer(this);
        if (this.mFormNode instanceof FormField) {
            ((FormField)this.mFormNode).setFromData(null, true);
        } else if (this.mFormNode instanceof FormExclGroup) {
            ((FormExclGroup)this.mFormNode).setFromData(null);
        }
    }

    public static boolean isMapped(DataNode dataNode) {
        int nPeer = 0;
        Peer peer = dataNode.getPeer(nPeer);
        while (peer != null) {
            if (peer instanceof FormDataListener) {
                return true;
            }
            peer = dataNode.getPeer(++nPeer);
        }
        return false;
    }

    public boolean isFieldValueChange(Object peerNode, int eventType, String arg1, Object arg2) {
        block11: {
            if (eventType != 2 && eventType != 7) break block11;
            if (peerNode == this.mDataNode) {
                return true;
            }
            if (peerNode == this.mFormNode) {
                if (this.mFormNode instanceof FormField) {
                    for (Node oNode = (Node)arg2; oNode != null; oNode = oNode.getXFAParent()) {
                        if (oNode.isSameClass(405)) {
                            Element oParent = oNode.getXFAParent();
                            if (oParent == null || oParent != this.mFormNode) continue;
                            return true;
                        }
                        if (oNode != this.mFormNode) {
                            continue;
                        }
                        break;
                    }
                } else if (this.mFormNode instanceof FormExclGroup) {
                    for (Node oNode = (Node)arg2; oNode != null; oNode = oNode.getXFAParent()) {
                        if (oNode.isSameClass(405)) {
                            Element oParent = oNode.getXFAParent();
                            if (!(oParent instanceof FormField) || oParent.getXFAParent() != this.mFormNode) continue;
                            return true;
                        }
                        if (oNode != this.mFormNode) {
                            continue;
                        }
                        break;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void updateFromPeer(Object peerNode, int eventType, String arg1, Object arg2) {
        if (this.isFieldValueChange(peerNode, eventType, arg1, arg2)) {
            this.deafen();
            if (peerNode == this.mDataNode) {
                if (this.mFormNode instanceof FormField) {
                    ((FormField)this.mFormNode).setFromData(null, true);
                } else if (this.mFormNode instanceof FormExclGroup) {
                    ((FormExclGroup)this.mFormNode).setFromData(null);
                }
            } else if (peerNode == this.mFormNode) {
                if (this.mFormNode instanceof FormField) {
                    if (this.mFormNode instanceof FormChoiceListField) {
                        ((FormChoiceListField)this.mFormNode).setData(null);
                    } else {
                        ((FormField)this.mFormNode).setData(null);
                    }
                } else if (this.mFormNode instanceof FormExclGroup) {
                    ((FormExclGroup)this.mFormNode).setData(null);
                }
            }
            this.unDeafen();
        } else if (eventType == 10 || eventType == 11) {
            this.deafen();
            if (peerNode == this.mDataNode) {
                if (this.mFormNode instanceof FormField || this.mFormNode instanceof FormExclGroup || this.mFormNode instanceof FormSubform) {
                    if (eventType == 10) {
                        this.mFormNode.setPermsLock(true);
                    } else {
                        this.mFormNode.setPermsLock(false);
                    }
                }
            } else if (peerNode == this.mFormNode && (this.mFormNode instanceof FormField || this.mFormNode instanceof FormExclGroup || this.mFormNode instanceof FormSubform)) {
                if (eventType == 10) {
                    this.mDataNode.setPermsLock(true);
                } else {
                    this.mDataNode.setPermsLock(false);
                }
            }
            this.unDeafen();
        }
    }

    @Override
    public void peerRemoved(Peer peer) {
        if (peer == this.mDataNode) {
            if (!FormDataListener.isMapped(this.mDataNode)) {
                this.mDataNode.setMapped(false);
                Element parent = this.mDataNode.getXFAParent();
                if (parent != null && this.mDataNode.isDefault(false)) {
                    this.mDataNode.remove();
                }
            }
            this.mDataNode = null;
        } else if (peer == this.mFormNode) {
            this.mFormNode.setMapped(false);
            this.mFormNode = null;
        }
    }

    @Override
    public String getClassName() {
        return "formDataListener";
    }

    @Override
    public String getClassAtom() {
        return "formDataListener";
    }
}

