/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.Obj;
import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.ut.StringUtils;

final class BuiltinMisc {
    private BuiltinMisc() {
    }

    static void Eval(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block5: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                String sVal = oParser.getString(oArgSym[0]);
                if (StringUtils.isEmpty(sVal)) {
                    throw new CalcException();
                }
                CalcParser evalParser = (CalcParser)oParser.clone();
                if (evalParser != null) {
                    evalParser.putScript(sVal);
                    boolean bRet = evalParser.yyParse();
                    if (bRet) {
                        evalParser.execute();
                    }
                    CalcSymbol oResult = evalParser.getCalcResult();
                    oRetSym = new CalcSymbol(oResult);
                    CalcSymbol.delete(oResult, oParser);
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block5;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void MessageBox(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block5: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 3);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                int n = (int)oParser.getNumeric(oArgSym[0]);
                if (n < 0) {
                    n = 0;
                }
                if (n > 5) {
                    n = 0;
                }
                String message = oParser.getString(oArgSym[1]);
                String title = nArgs > 2 ? oParser.getString(oArgSym[2]) : "";
                int nRetVal = 0;
                if (oParser.moDisplayHost != null) {
                    nRetVal = oParser.moDisplayHost.messageBox(n, message, title);
                }
                oRetSym = new CalcSymbol(nRetVal);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block5;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Null(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.maxArgs(nArgs, 0);
                oRetSym = new CalcSymbol();
                oRetSym.setType(1);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Ref(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block9: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 1);
                Builtins.maxArgs(nArgs, 1);
                Builtins.limitExceptionArgs(oArgSym);
                int fType = oArgSym[0].getType();
                Obj oObj = null;
                switch (fType) {
                    case 9: {
                        oObj = oParser.moScriptHost.getItem(oArgSym[0].getName(), oArgSym[0].getObjValues());
                        oRetSym = new CalcSymbol(oObj, oArgSym[0].getName());
                        break;
                    }
                    case 1: {
                        oRetSym = new CalcSymbol();
                        oRetSym.setObjValue(oObj);
                        oRetSym.setType(6);
                        break;
                    }
                    case 0: 
                    case 6: 
                    case 10: {
                        oRetSym = new CalcSymbol(oArgSym[0]);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: {
                        oRetSym = new CalcSymbol(oParser.getString(oArgSym[0]));
                        break;
                    }
                    default: {
                        assert (fType != 0);
                        break;
                    }
                }
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block9;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }
}

