/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.service.canonicalize;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Chars;
import com.adobe.xfa.Comment;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Canonicalize {
    public static final int CANONICALWITH = 1;
    public static final int CANONICALWITHOUT = 2;
    public static final int EXCLUSIVEWITH = 3;
    public static final int EXCLUSIVEWITHOUT = 4;
    public static final int SAVEWITH = 5;
    public static final int SAVEWITHOUT = 6;
    private boolean mbDocumentSubSet = false;
    private boolean mbWithComments = false;
    private boolean mbExclusive = false;
    private boolean mbInPlace;
    private boolean mbLegacy_V32_Canonicalization;
    private Document mRootDoc = null;
    private final List<CanonNode> mNodeList = new ArrayList<CanonNode>();
    private XMLNameSpaceStack mNSStack;
    private List<String> mInclusiveNSPrefixList = null;
    private DOMSaveOptions mOptions;

    public Canonicalize() {
        this.mbInPlace = false;
        this.mbLegacy_V32_Canonicalization = true;
        this.mOptions = new DOMSaveOptions(0, true, false, true, 3, true, false, "", '\u0000', '\u0000', "&", false, false, true);
        this.mNSStack = new XMLNameSpaceStack();
    }

    public Canonicalize(boolean bLegacy_V32_Canonicalization) {
        this.mbInPlace = false;
        this.mbLegacy_V32_Canonicalization = bLegacy_V32_Canonicalization;
        this.mOptions = new DOMSaveOptions(0, true, false, true, 3, true, false, "", '\u0000', '\u0000', "&", false, false, true);
        this.mNSStack = new XMLNameSpaceStack();
    }

    public Canonicalize(Node node, boolean bInPlace, boolean bLegacy_V32_Canonicalization) {
        this.mbInPlace = bInPlace;
        this.mbLegacy_V32_Canonicalization = bLegacy_V32_Canonicalization;
        this.mOptions = new DOMSaveOptions(0, true, false, true, 3, true, false, "", '\u0000', '\u0000', "&", false, false, true);
        this.setData(node);
        this.mNSStack = new XMLNameSpaceStack();
    }

    public Canonicalize(List<? extends Node> store, boolean bWithDescendants, boolean bLegacy_V32_Canonicalization) {
        this.mbInPlace = false;
        this.mbLegacy_V32_Canonicalization = bLegacy_V32_Canonicalization;
        this.mOptions = new DOMSaveOptions(0, true, false, true, 3, true, false, "", '\u0000', '\u0000', "&", false, false, true);
        this.setData(store, bWithDescendants);
        this.mNSStack = new XMLNameSpaceStack();
    }

    private void addNSToList(AttrList map, Object node, Document doc, boolean bExclusive, List<String> inclusiveNSPrefixList) {
        boolean bAdd = true;
        String sPrefix = null;
        String sNS = null;
        if (node instanceof Element) {
            Element elementOrDocumentNode = (Element)node;
            sPrefix = elementOrDocumentNode.getPrefix();
            sNS = elementOrDocumentNode.getNS();
        } else if (node instanceof Attribute) {
            Attribute attributeNode = (Attribute)node;
            sPrefix = attributeNode.getPrefix();
            sNS = attributeNode.getNS();
        }
        String sQualifiedName = sPrefix;
        if (StringUtils.isEmpty(sPrefix) && node instanceof Attribute) {
            return;
        }
        if (bExclusive) {
            bAdd = false;
            if (inclusiveNSPrefixList != null) {
                for (int k = 0; k < inclusiveNSPrefixList.size(); ++k) {
                    if (!sQualifiedName.equals(inclusiveNSPrefixList.get(k))) continue;
                    bAdd = true;
                    break;
                }
            }
        }
        if (bAdd) {
            sQualifiedName = StringUtils.isEmpty(sQualifiedName) ? "xmlns" : "xmlns:" + sQualifiedName;
            Attribute oNewAttr = doc.setAttribute("", sQualifiedName, sQualifiedName, sNS);
            map.add(oNewAttr);
        }
    }

    public Document canonicalize(List<? super Node> retList, int eCanonicalType, List<String> inclusiveNSPrefixList) {
        int i;
        this.mbWithComments = false;
        this.mbExclusive = false;
        this.mInclusiveNSPrefixList = inclusiveNSPrefixList;
        if (eCanonicalType == 1 || eCanonicalType == 3 || eCanonicalType == 5) {
            this.mbWithComments = true;
        }
        if (eCanonicalType == 3 || eCanonicalType == 4) {
            this.mbExclusive = true;
        }
        for (i = 0; i < this.mNodeList.size(); ++i) {
            this.mNSStack.push("xml", "http://www.w3.org/XML/1998/namespace");
            this.mNSStack.push("", "");
            Object node = this.mNodeList.get((int)i).mClone;
            if (node instanceof Chars) {
                String sValue = StringUtils.toXML(((Chars)node).getText(), false);
                CanonNode oCanon = this.mNodeList.get(i);
                this.mNodeList.set(i, new CanonNode(new Chars(null, null, sValue), oCanon.mOriginal));
            } else if (node instanceof Comment) {
                if (!this.mbWithComments) {
                    this.mNodeList.remove(i);
                    --i;
                }
            } else if (node instanceof Document) {
                this.processTree(node);
            } else {
                if (node instanceof Element) {
                    this.processTree(node);
                    break;
                }
                this.processTree(node);
            }
            this.mNSStack.clear();
        }
        for (i = 0; i < this.mNodeList.size(); ++i) {
            Node currentNode = (Node)this.mNodeList.get((int)i).mClone;
            retList.add(currentNode);
        }
        return this.mRootDoc;
    }

    public byte[] canonicalize(int eCanonicalType, List<String> inclusiveNSPrefixList) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.canonicalize(stream, eCanonicalType, inclusiveNSPrefixList);
        return stream.toByteArray();
    }

    public void canonicalize(OutputStream out, int eCanonicalType, List<String> inclusiveNSPrefixList) {
        ArrayList retList = new ArrayList();
        Document doc = this.canonicalize(retList, eCanonicalType, inclusiveNSPrefixList);
        if (out == null) {
            throw new ExFull(ResId.InvalidInputObject);
        }
        int n = retList.size();
        for (int i = 0; i < n; ++i) {
            doc.saveAs(out, (Node)retList.get(i), this.mOptions);
        }
    }

    private void getElementAttrs(AttrList map, Element element) {
        Element original;
        Element parent = element.getXMLParent();
        if (parent instanceof Element.DualDomNode) {
            parent = (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer();
        }
        if ((original = this.getOriginal(element)) != null) {
            this.getInheritedAttrs(map, original, parent);
        }
        while (element.getNumAttrs() > 0) {
            Attribute attribute = element.getAttr(0);
            boolean bAdd = true;
            if (this.mbExclusive && attribute.isNameSpaceAttr()) {
                bAdd = false;
                if (this.mInclusiveNSPrefixList != null) {
                    for (int k = 0; k < this.mInclusiveNSPrefixList.size(); ++k) {
                        String sLocalName = attribute.getLocalName();
                        if (!sLocalName.equals(this.mInclusiveNSPrefixList.get(k))) continue;
                        bAdd = true;
                        break;
                    }
                }
            }
            if (bAdd) {
                String sValue = StringUtils.toXML(attribute.getAttrValue(), true);
                attribute = attribute.newAttribute(sValue);
                map.add(attribute);
            }
            element.removeAttr(attribute.getNS(), attribute.getName());
        }
    }

    private void getInheritedAttrs(AttrList map, Element original, Element target) {
        if (original == null || !this.mbDocumentSubSet) {
            return;
        }
        Element originalTarget = this.getOriginal(target);
        if (original == originalTarget) {
            if (!this.mbExclusive) {
                int nLen = target.getNumAttrs();
                for (int i = 0; i < nLen; ++i) {
                    Attribute attribute = target.getAttr(i);
                    if (attribute.getPrefix() != "xml") continue;
                    String sValue = StringUtils.toXML(attribute.getAttrValue(), true);
                    Attribute clone = attribute.newAttribute(sValue);
                    map.add(clone);
                }
            }
            return;
        }
        if (this.mbExclusive && (this.mInclusiveNSPrefixList == null || this.mInclusiveNSPrefixList.size() == 0)) {
            return;
        }
        Element parent = original.getXMLParent();
        if (parent instanceof Element.DualDomNode) {
            parent = (Element)((Element.DualDomNode)((Object)parent)).getXmlPeer();
        }
        this.getInheritedAttrs(map, parent, target);
        int nLen = original.getNumAttrs();
        for (int i = 0; i < nLen; ++i) {
            Attribute attribute = original.getAttr(i);
            boolean bAdd = false;
            if (!this.mbExclusive && (attribute.isNameSpaceAttr() || attribute.getPrefix() == "xml")) {
                bAdd = true;
            }
            if (!bAdd && this.mbExclusive && this.mInclusiveNSPrefixList != null && attribute.isNameSpaceAttr()) {
                for (int k = 0; k < this.mInclusiveNSPrefixList.size(); ++k) {
                    String sLocalName = attribute.getLocalName();
                    if (!sLocalName.equals(this.mInclusiveNSPrefixList.get(k))) continue;
                    bAdd = true;
                    break;
                }
            }
            if (bAdd) {
                String sValue = StringUtils.toXML(attribute.getAttrValue(), true);
                Attribute oClone = attribute.newAttribute(sValue);
                map.add(oClone);
                continue;
            }
            this.addNSToList(map, attribute, this.mRootDoc, this.mbExclusive, this.mInclusiveNSPrefixList);
        }
        this.addNSToList(map, original, this.mRootDoc, this.mbExclusive, this.mInclusiveNSPrefixList);
    }

    private Element getOriginal(Element element) {
        for (int i = 0; i < this.mNodeList.size(); ++i) {
            if (this.mNodeList.get((int)i).mClone != element) continue;
            return (Element)this.mNodeList.get((int)i).mOriginal;
        }
        return null;
    }

    public DOMSaveOptions getSaveOptions() {
        return this.mOptions;
    }

    private void processTree(Object node) {
        if (node == null) {
            return;
        }
        if (node instanceof TextNode) {
            String sValue = StringUtils.toXML(((TextNode)node).getValue(), false);
            ((TextNode)node).setValue(sValue, true, false);
        } else if (node instanceof Document) {
            Node child = ((Document)node).getFirstXMLChild();
            while (child != null) {
                Node nextSib = child.getNextXMLSibling();
                if (child instanceof TextNode) {
                    Node previousSib = child.getPreviousXMLSibling();
                    if (previousSib == null || previousSib instanceof TextNode) {
                        ((Document)node).removeChild(child);
                    } else if (((TextNode)child).getValue().indexOf(10) >= 0) {
                        ((TextNode)child).setValue("\n", true, false);
                    }
                } else {
                    this.processTree(child);
                }
                child = nextSib;
            }
            child = ((Document)node).getLastXMLChild();
            while (child instanceof TextNode) {
                ((Document)node).removeChild(child);
                child = ((Document)node).getLastXMLChild();
            }
        } else if (node instanceof Element) {
            Element element = (Element)node;
            TreeMap<String, String> neededNS = new TreeMap<String, String>(StringUtils.UCS_CODEPOINT_COMPARATOR);
            TreeMap<String, TreeMap<String, Attribute>> attList = new TreeMap<String, TreeMap<String, Attribute>>(StringUtils.UCS_CODEPOINT_COMPARATOR);
            String sElementPrefix = element.getPrefix();
            String sElementNSURI = element.getNS();
            if (sElementPrefix == null) {
                sElementPrefix = "";
            }
            if (sElementNSURI == null) {
                sElementNSURI = "";
            }
            if (this.mNSStack.push(sElementPrefix, sElementNSURI)) {
                neededNS.put(sElementPrefix, sElementNSURI);
            }
            AttrList attributes = new AttrList();
            this.getElementAttrs(attributes, element);
            int nAttributes = attributes.size();
            int n = nAttributes;
            for (int i = 0; i < n; ++i) {
                String sNSPrefix;
                String sNSURI;
                boolean bNSRequired = true;
                Attribute attribute = attributes.get(i);
                if (attribute.isNameSpaceAttr()) {
                    sNSURI = attribute.getAttrValue();
                    sNSPrefix = attribute.getPrefix() == "" ? "" : attribute.getName();
                    if (sNSURI == null) {
                        sNSURI = "";
                    }
                } else {
                    sNSPrefix = attribute.getPrefix();
                    if (StringUtils.isEmpty(sNSPrefix)) {
                        bNSRequired = false;
                        sNSURI = "";
                    } else {
                        sNSURI = attribute.getNS();
                        if (StringUtils.isEmpty(sNSURI)) {
                            sNSURI = "";
                        }
                    }
                    TreeMap<String, Attribute> storeAttList = (TreeMap<String, Attribute>)attList.get(sNSURI);
                    if (storeAttList == null) {
                        storeAttList = new TreeMap<String, Attribute>(StringUtils.UCS_CODEPOINT_COMPARATOR);
                        storeAttList.put(attribute.getName(), attribute);
                        attList.put(sNSURI, storeAttList);
                    } else {
                        storeAttList.put(attribute.getName(), attribute);
                    }
                }
                if (!bNSRequired || !this.mNSStack.push(sNSPrefix, sNSURI)) continue;
                neededNS.put(sNSPrefix, sNSURI);
            }
            for (Map.Entry entry : neededNS.entrySet()) {
                String sQualifiedName = (String)entry.getKey();
                String sNSValue = (String)entry.getValue();
                if (sQualifiedName.equals("xml") && StringUtils.isEmpty(sNSValue)) continue;
                if (StringUtils.isEmpty(sQualifiedName)) {
                    sQualifiedName = "xmlns";
                } else if (!sQualifiedName.startsWith("xmlns:")) {
                    sQualifiedName = ("xmlns:" + sQualifiedName).intern();
                }
                element.setAttribute("", sQualifiedName, sQualifiedName, sNSValue, false);
            }
            for (SortedMap storeAttList : attList.values()) {
                for (Attribute attr : storeAttList.values()) {
                    if (attr == null) continue;
                    element.setAttribute(attr.getNS(), attr.getQName(), attr.getName(), attr.getAttrValue(), false);
                }
                storeAttList.clear();
            }
            attList.clear();
            Node child = element.getFirstXMLChild();
            while (child != null) {
                Node nextSib = child.getNextXMLSibling();
                this.processTree(child);
                child = nextSib;
            }
            for (String sNS : neededNS.keySet()) {
                if (sNS == null) continue;
                this.mNSStack.pop(sNS);
            }
            neededNS.clear();
        } else if (node instanceof Chars) {
            String sValue = StringUtils.toXML(((Chars)node).getText(), false);
            Chars newText = new Chars(null, null, sValue);
            ((Chars)node).getXMLParent().replaceChild(newText, (Chars)node);
        } else if (node instanceof Comment && !this.mbWithComments && ((Comment)node).getXMLParent() != null) {
            ((Comment)node).getXMLParent().removeChild((Comment)node);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setData(Object node) {
        this.prepareSourceDocument(node);
        this.mNodeList.clear();
        if (node == null) {
            return;
        }
        this.mbDocumentSubSet = !(node instanceof Document);
        Object newNode = null;
        if (!this.mbInPlace) {
            AppModel app = new AppModel(null);
            this.mRootDoc = new Document(app);
            if (!this.mbDocumentSubSet) {
                newNode = ((Document)node).cloneNode(true);
                this.mRootDoc = (Document)newNode;
            } else if (node instanceof Attribute) {
                newNode = node;
            } else {
                if (!(node instanceof Node)) throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Canonicalize#setData");
                newNode = this.mRootDoc.importNode((Node)node, true);
            }
        } else {
            if (node instanceof Node) {
                this.mRootDoc = ((Node)node).getOwnerDocument();
            }
            newNode = node;
        }
        CanonNode canonNode = new CanonNode(newNode, node);
        this.mNodeList.add(canonNode);
    }

    private void setData(List<? extends Node> store, boolean bWithDescendants) {
        this.prepareSourceDocument(store);
        assert (!this.mbInPlace);
        this.mbDocumentSubSet = true;
        this.mNodeList.clear();
        ArrayList<CanonNode> workingList = new ArrayList<CanonNode>();
        AppModel appModel = new AppModel(null);
        this.mRootDoc = appModel.getDocument();
        for (int i = 0; i < store.size(); ++i) {
            CanonNode canonNode;
            Node node = store.get(i);
            if (node == null) continue;
            Node newNode = null;
            Node original = node;
            if (i == 0 && node instanceof Document) {
                newNode = ((Document)node).cloneNode(bWithDescendants);
                this.mRootDoc = (Document)newNode;
                canonNode = new CanonNode(newNode, original);
                if (bWithDescendants) {
                    this.mNodeList.add(canonNode);
                    continue;
                }
                workingList.add(canonNode);
                continue;
            }
            if (bWithDescendants) {
                newNode = this.mRootDoc.importNode(node, true);
                canonNode = new CanonNode(newNode, original);
                this.mNodeList.add(canonNode);
                continue;
            }
            if (node instanceof Element) {
                newNode = this.mRootDoc.createElementNS(((Element)node).getNS(), ((Element)node).getName(), null);
                if (!this.mbLegacy_V32_Canonicalization) {
                    ((Element)newNode).isTransient(newNode.isTransient(), false);
                    ((Element)newNode).setDefaultFlag(newNode.isDefault(false), false);
                }
            } else {
                newNode = this.mRootDoc.importNode(node, false);
            }
            canonNode = new CanonNode(newNode, original);
            workingList.add(canonNode);
        }
        while (workingList.size() > 0) {
            CanonNode currentNode = (CanonNode)workingList.get(workingList.size() - 1);
            Node original = (Node)currentNode.mOriginal;
            boolean appended = false;
            workingList.remove(workingList.size() - 1);
            block2: for (Element originalParent = original.getXMLParent(); originalParent != null && !appended; originalParent = originalParent.getXMLParent()) {
                for (int i = workingList.size(); i > 0; --i) {
                    Object listItem = workingList.get(i - 1);
                    Object originalListItem = ((CanonNode)listItem).mOriginal;
                    if (originalParent != originalListItem) continue;
                    Object target = ((CanonNode)workingList.get((int)(i - 1))).mClone;
                    if (!(target instanceof Element)) continue block2;
                    ((Element)target).insertChild((Node)currentNode.mClone, ((Node)target).getFirstXMLChild(), false);
                    appended = true;
                    continue block2;
                }
            }
            if (appended) continue;
            this.mNodeList.add(0, currentNode);
        }
    }

    private void prepareSourceDocument(Object node) {
        if (node instanceof Element) {
            ((Element)node).getModel().preSave(false);
        }
    }

    private void prepareSourceDocument(List<? extends Node> nodes) {
        int i;
        ArrayList<Model> modelsToPrepare = new ArrayList<Model>(nodes.size());
        for (i = 0; i < nodes.size(); ++i) {
            Model model;
            Node node = nodes.get(i);
            if (node instanceof Document) {
                ((Document)node).getAppModel().preSave(false);
                return;
            }
            if (node instanceof AppModel) {
                ((AppModel)node).preSave(false);
                return;
            }
            if (!(node instanceof Element) || (model = ((Element)node).getModel()) == null || modelsToPrepare.contains(model)) continue;
            modelsToPrepare.add(model);
        }
        for (i = 0; i < modelsToPrepare.size(); ++i) {
            ((Model)modelsToPrepare.get(i)).preSave(false);
        }
    }

    private static class XMLNameSpaceStack {
        private NameSpaceList mStack = new NameSpaceList("xmlns", "", null);

        XMLNameSpaceStack() {
        }

        boolean push(String sNameSpace, String sNamespaceURI) {
            NameSpaceList newNSList;
            if (this.mStack == null) {
                this.mStack = new NameSpaceList(sNameSpace, sNamespaceURI, null);
                return true;
            }
            NameSpaceList currentNS = this.mStack;
            while (currentNS != null) {
                if (currentNS.msNameSpace.equals(sNameSpace)) {
                    if (currentNS.mURIList.size() > 0 && currentNS.mURIList.get(currentNS.mURIList.size() - 1).equals(sNamespaceURI)) {
                        return false;
                    }
                    currentNS.mURIList.add(sNamespaceURI);
                    return true;
                }
                currentNS = currentNS.mNextNS;
            }
            this.mStack = newNSList = new NameSpaceList(sNameSpace, sNamespaceURI, this.mStack);
            return true;
        }

        void pop(String sNameSpace) {
            NameSpaceList currentNS = this.mStack;
            while (currentNS != null) {
                if (currentNS.msNameSpace.equals(sNameSpace)) {
                    if (currentNS.mURIList.size() <= 0) break;
                    currentNS.mURIList.remove(currentNS.mURIList.size() - 1);
                    break;
                }
                currentNS = currentNS.mNextNS;
            }
        }

        void clear() {
            while (this.mStack != null) {
                this.mStack = this.mStack.mNextNS;
            }
            this.mStack = null;
        }

        static class NameSpaceList {
            final String msNameSpace;
            final List<String> mURIList = new ArrayList<String>();
            final NameSpaceList mNextNS;

            NameSpaceList(String nameSpace, String aUri, NameSpaceList nextNS) {
                this.msNameSpace = nameSpace;
                this.mNextNS = nextNS;
                this.mURIList.add(aUri);
            }
        }
    }

    private static class CanonNode {
        final Object mClone;
        final Object mOriginal;

        CanonNode(Object clone, Object original) {
            this.mClone = clone;
            this.mOriginal = original;
        }
    }

    private static class AttrList {
        private final List<Attribute> mAttrs = new ArrayList<Attribute>();

        AttrList() {
        }

        void add(Attribute newAttr) {
            int nSize = this.size();
            for (int nIndex = 0; nIndex < nSize; ++nIndex) {
                Attribute attr = this.mAttrs.get(nIndex);
                if (attr.getLocalName() != newAttr.getLocalName()) continue;
                if (attr.getNS() == newAttr.getNS()) {
                    this.mAttrs.set(nIndex, newAttr);
                    return;
                }
                if (newAttr.getNS() != "" || attr.getPrefix() == null || attr.getPrefix() != "") continue;
                this.mAttrs.set(nIndex, newAttr);
                return;
            }
            this.mAttrs.add(newAttr);
        }

        Attribute get(int i) {
            return this.mAttrs.get(i);
        }

        int size() {
            return this.mAttrs.size();
        }
    }
}

