/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.analytics.sitecatalyst.util;

import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.analytics.sitecatalyst.util.AnalyticsConfig;
import com.day.cq.analytics.sitecatalyst.util.WebService;
import java.io.Closeable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.util.EntityUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public final class WebServiceImpl
implements WebService {
    private static final String CONTENT_TYPE = "application/json";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private int connectionTimeout = 60000;
    private int socketTimeout = 30000;
    @Reference
    private HttpClientBuilderFactory clientBuilderFactory;
    @Reference
    private CryptoSupport cryptoSupport;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    private void addHeaders(HttpUriRequest request, AnalyticsConfig analyticsConfig) throws Exception {
        if (analyticsConfig == null) {
            return;
        }
        String token = analyticsConfig.getAccessToken();
        if (this.cryptoSupport.isProtected(token)) {
            token = this.cryptoSupport.unprotect(token);
        }
        request.addHeader("Content-Type", String.format(CONTENT_TYPE, new Object[0]));
        request.addHeader("X-Api-Key", analyticsConfig.getApikey());
        request.addHeader("x-proxy-global-company-id", analyticsConfig.getCompanyId());
        request.addHeader("Authorization", "Bearer " + token);
    }

    @Override
    public String request(HttpRequestBase request, AnalyticsConfig analyticsConfig) throws Exception {
        String string;
        int responseStatusCode;
        HttpEntity entity;
        CloseableHttpResponse apiResponse;
        HttpRequestBase apiRequest;
        CloseableHttpClient httpClient;
        block7: {
            httpClient = null;
            apiRequest = null;
            apiResponse = null;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setConnectionRequestTimeout(this.connectionTimeout).setSocketTimeout(this.socketTimeout).build();
            httpClient = this.clientBuilderFactory.newBuilder().setDefaultRequestConfig(config).build();
            apiRequest = request;
            this.addHeaders(apiRequest, analyticsConfig);
            this.logRequest(apiRequest, "Analytics API Request");
            apiResponse = httpClient.execute(apiRequest);
            entity = apiResponse != null ? apiResponse.getEntity() : null;
            StatusLine responseStatusLine = apiResponse != null ? apiResponse.getStatusLine() : null;
            int n = responseStatusCode = responseStatusLine != null ? responseStatusLine.getStatusCode() : -1;
            if (responseStatusCode != 200 && responseStatusCode != 201) break block7;
            if (entity == null) {
                throw new Exception("Invalid response! Empty payload.");
            }
            String string2 = EntityUtils.toString(entity);
            IOUtils.closeQuietly((Closeable)apiResponse);
            IOUtils.closeQuietly((Closeable)httpClient);
            return string2;
        }
        try {
            String apiResponseJson = entity != null ? EntityUtils.toString(entity) : "";
            String error = String.format("Unexpected response status code [%d] for request [%s].\n%s", responseStatusCode, apiRequest.getURI(), apiResponseJson);
            if (this.log.isDebugEnabled()) {
                this.log.debug(error);
            }
            string = null;
        }
        catch (Exception e) {
            try {
                throw new Exception("API request failed", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(apiResponse);
                IOUtils.closeQuietly(httpClient);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)apiResponse);
        IOUtils.closeQuietly((Closeable)httpClient);
        return string;
    }

    private void logRequest(HttpUriRequest request, String message) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("{}: {} {} {}", message, request.getMethod(), request.getURI().toString(), request instanceof HttpEntityEnclosingRequestBase ? EntityUtils.toString(((HttpEntityEnclosingRequestBase)request).getEntity()) : "");
        }
    }
}

