/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.Language;
import com.ibm.icu.lang.UScript;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageUtil {
    private static final Logger log;
    public static final Set<String> ISO_LANGUAGES;
    private static final Set<String> NON_STANDARD_LANGUAGE_CODES;
    public static final Set<String> ISO_COUNTRIES;
    static final String SCRIPT_TOGGLE = "FT_CQ-4332753";
    public static final String PSEUDO_LANGUAGE = "zz";
    private static final Pattern SINGLE_CODE;
    private static final Pattern LANGUAGE_AND_COUNTRY;
    private static final Pattern LANGUAGE_SCRIPT_COUNTRY;
    private static ToggleRouter toggleRouter;

    public static Locale getLocale(String code) {
        Language l = LanguageUtil.getLanguage(code);
        return l == null ? null : l.getLocale();
    }

    public static Language getLanguage(String code) {
        if (code == null) {
            return null;
        }
        code = code.replaceAll("-", "_");
        if (toggleRouter != null && !toggleRouter.isEnabled(SCRIPT_TOGGLE)) {
            String lang = null;
            String country = "";
            if (code.length() == 2) {
                lang = code.toLowerCase();
            } else if (code.length() == 5 && code.charAt(2) == '_') {
                lang = code.substring(0, 2);
                country = code.substring(3);
            }
            if (lang == null) {
                return null;
            }
            if (!(PSEUDO_LANGUAGE.equalsIgnoreCase(lang) || ISO_LANGUAGES.contains(lang.toLowerCase()) || NON_STANDARD_LANGUAGE_CODES.contains(lang.toLowerCase()))) {
                return null;
            }
            if (!(country.length() <= 0 || ISO_COUNTRIES.contains(country.toUpperCase()) || NON_STANDARD_LANGUAGE_CODES.contains(country.toUpperCase()) || PSEUDO_LANGUAGE.equalsIgnoreCase(lang))) {
                return null;
            }
            return new Language(lang, country);
        }
        String lang = null;
        String country = "";
        String script = "";
        if (code.length() == 2) {
            lang = code.toLowerCase();
        } else if (code.length() == 5 && code.charAt(2) == '_') {
            lang = code.substring(0, 2);
            country = code.substring(3);
        } else if (code.length() == 7 && code.charAt(2) == '_') {
            lang = code.substring(0, 2);
            script = code.substring(3);
        } else if (code.length() == 10 && code.charAt(2) == '_' && code.charAt(7) == '_') {
            lang = code.substring(0, 2);
            script = code.substring(3, 7);
            country = code.substring(8);
        }
        if (lang == null) {
            return null;
        }
        if (!(PSEUDO_LANGUAGE.equalsIgnoreCase(lang) || ISO_LANGUAGES.contains(lang.toLowerCase()) || NON_STANDARD_LANGUAGE_CODES.contains(lang.toLowerCase()))) {
            return null;
        }
        if (!(country.length() <= 0 || ISO_COUNTRIES.contains(country.toUpperCase()) || NON_STANDARD_LANGUAGE_CODES.contains(country.toUpperCase()) || PSEUDO_LANGUAGE.equalsIgnoreCase(lang))) {
            return null;
        }
        if (script.length() == 0) {
            return new Language(lang, country);
        }
        if (!LanguageUtil.isScriptTag(script)) {
            return null;
        }
        try {
            Locale locale = new Locale.Builder().setLanguage(lang).setRegion(country).setScript(script).build();
            return new Language(locale);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String getLanguageRoot(String path) {
        String strTempPrefix;
        String code;
        if (path == null || path.length() == 0 || path.equals("/")) {
            return null;
        }
        String root = null;
        String strPrefix = "";
        String strTempPath = path;
        if (toggleRouter != null && toggleRouter.isEnabled(SCRIPT_TOGGLE)) {
            Matcher tm = LANGUAGE_SCRIPT_COUNTRY.matcher(path);
            while (tm.find() && root == null) {
                code = tm.group(1);
                if (LanguageUtil.getLocale(code) != null) {
                    root = strPrefix + strTempPath.substring(0, tm.end(1));
                }
                strTempPrefix = strTempPath.substring(0, tm.end(1));
                strPrefix = strPrefix + strTempPrefix;
                strTempPath = strTempPath.substring(strTempPrefix.length());
                tm = LANGUAGE_SCRIPT_COUNTRY.matcher(strTempPath);
            }
        }
        if (root == null) {
            strPrefix = "";
            strTempPath = path;
            Matcher m = LANGUAGE_AND_COUNTRY.matcher(path);
            while (m.find() && root == null) {
                code = m.group(1);
                if (LanguageUtil.getLocale(code) != null) {
                    root = strPrefix + strTempPath.substring(0, m.end(1));
                }
                strTempPrefix = strTempPath.substring(0, m.end(1));
                strPrefix = strPrefix + strTempPrefix;
                strTempPath = strTempPath.substring(strTempPrefix.length());
                m = LANGUAGE_AND_COUNTRY.matcher(strTempPath);
            }
        }
        if (root == null) {
            int pos = -1;
            String last = null;
            Matcher sm = SINGLE_CODE.matcher(path);
            while (sm.find()) {
                String code2 = sm.group(1);
                if (last == null && LanguageUtil.getLocale(code2) != null) {
                    last = code2;
                    pos = sm.end(1);
                } else if (last != null && LanguageUtil.getLocale(code2 + "_" + last) != null) {
                    pos = sm.end(1);
                    break;
                }
                sm.region(sm.end(1), path.length());
            }
            if (pos > 0) {
                root = path.substring(0, pos);
            }
        }
        return root;
    }

    static boolean isScriptTag(String code) {
        return code != null && code.length() == 4 && ISO_SCRIPTS_HOLDER.SCRIPTS.contains(code.toLowerCase());
    }

    static boolean isLanguageCode(String code) {
        return ISO_LANGUAGES.contains(code.toLowerCase());
    }

    static boolean isCountryCode(String code) {
        return ISO_COUNTRIES.contains(code.toUpperCase());
    }

    static boolean isClassPresent(String className) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(LanguageUtil.class);
            if (bundle != null) {
                return bundle.loadClass(className) != null;
            }
            return Class.forName(className, false, Thread.currentThread().getContextClassLoader()) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Set<String> initialiseISO_SCRIPTS() {
        Set<String> ISO_SCRIPTS = Collections.emptySet();
        if (LanguageUtil.isClassPresent("com.ibm.icu.lang.UScript")) {
            ISO_SCRIPTS = Collections.unmodifiableSet(IntStream.range(0, 200).mapToObj(i -> UScript.getShortName((int)i)).filter(script -> script != null).map(String::toLowerCase).collect(Collectors.toSet()));
            log.info("UScript class found, hence ISO_SCRIPTS initialized with ICU data");
        } else {
            ISO_SCRIPTS = LanguageUtil.getDefault_ISO_SCRIPTS();
            log.warn("UScript class not found, using default config for ISO_SCRIPTS");
        }
        return ISO_SCRIPTS;
    }

    private static HashSet<String> getDefault_ISO_SCRIPTS() {
        return new HashSet<String>(Arrays.asList("bhks", "toto", "yiii", "bamu", "pauc", "sogd", "java", "kthi", "orya", "laoo", "medf", "phag", "ogam", "zsym", "zsye", "hebr", "tagb", "arab", "hang", "hani", "inds", "samr", "soyo", "hano", "osma", "hans", "wara", "hant", "vith", "brai", "brah", "bugi", "hanb", "sylo", "mymr", "dupl", "loma", "wole", "visp", "gran", "ahom", "nkoo", "cakm", "kits", "sogo", "ugar", "mroo", "mand", "khar", "mani", "tnsa", "talu", "lyci", "gujr", "zxxx", "cans", "jurc", "tale", "gong", "latf", "hluw", "gonm", "dogr", "latg", "nand", "kawi", "latn", "buhd", "takr", "sinh", "kore", "zyyy", "ital", "lisu", "orkh", "mtei", "zzzz", "sind", "hira", "mlym", "deva", "perm", "sara", "adlm", "sarb", "tang", "nbat", "batk", "blis", "zmth", "lydi", "cpmn", "grek", "wcho", "xsux", "mong", "bass", "newa", "marc", "taml", "kpel", "egyd", "mult", "yezi", "cirt", "palm", "hatr", "elba", "geok", "roro", "zinh", "narb", "beng", "knda", "syrn", "egyp", "tglg", "cyrs", "plrd", "cyrl", "egyh", "lepc", "syrc", "bopo", "afak", "zanb", "syrj", "sgnw", "jamo", "syre", "olck", "moon", "cari", "vaii", "dsrt", "diak", "cprt", "phli", "phlp", "chrs", "hmng", "tirh", "copt", "saur", "kali", "sidd", "ougr", "nkgb", "goth", "geor", "runr", "shrd", "avst", "mend", "shaw", "cham", "guru", "telu", "aghb", "modi", "xpeo", "tfng", "armi", "nshu", "thaa", "mahj", "thai", "sund", "maya", "tibt", "phlv", "hung", "hmnp", "kana", "sora", "armn", "lina", "jpan", "linb", "hrkt", "prti", "rjng", "rohg", "khoj", "bali", "elym", "maka", "lana", "teng", "tavt", "ethi", "limb", "mero", "nagm", "khmr", "phnx", "osge", "merc", "glag", "cher"));
    }

    static /* synthetic */ Set access$000() {
        return LanguageUtil.initialiseISO_SCRIPTS();
    }

    static {
        ServiceReference serviceReference;
        BundleContext bundleContext;
        log = LoggerFactory.getLogger(LanguageUtil.class);
        ISO_LANGUAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOLanguages())));
        NON_STANDARD_LANGUAGE_CODES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("tc")));
        ISO_COUNTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOCountries())));
        SINGLE_CODE = Pattern.compile("/([a-zA-Z]{2})(/|$)");
        LANGUAGE_AND_COUNTRY = Pattern.compile("/([a-zA-Z]{2,3}[_-][a-zA-Z]{2,3})(/|$)");
        LANGUAGE_SCRIPT_COUNTRY = Pattern.compile("/([a-zA-Z]{2}[_-][a-zA-Z]{4}([_-][a-zA-Z]{2}){0,1})(/|$)");
        Bundle bundle = FrameworkUtil.getBundle(LanguageUtil.class);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null && (serviceReference = bundleContext.getServiceReference(ToggleRouter.class.getName())) != null) {
            toggleRouter = (ToggleRouter)bundleContext.getService(serviceReference);
        }
    }

    private static class ISO_SCRIPTS_HOLDER {
        static final Set<String> SCRIPTS = LanguageUtil.access$000();

        private ISO_SCRIPTS_HOLDER() {
        }
    }
}

