/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.AbstractFFMpegProcess;
import com.day.cq.dam.video.StoryBoard;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Day CQ DAM FFmpeg Storyboard Process", description="Workflow process that creates storyboards from video files")
@Service
@Properties(value={@Property(name="process.label", value={"Create Video Storyboard"}, propertyPrivate=true)})
public class FFMpegStoryBoardProcess
extends AbstractFFMpegProcess {
    private static final Logger log = LoggerFactory.getLogger(FFMpegStoryBoardProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processVideo(MetaDataMap metaData, Asset asset, File tmpFile, WorkflowSession wfSession) throws IOException, RepositoryException {
        String[] args = this.buildArguments(metaData);
        FFMpegWrapper wrapper = null;
        File tmpWorkingDir = null;
        try {
            tmpWorkingDir = this.createTempDir(this.getWorkingDir());
            wrapper = new FFMpegWrapper(tmpFile, tmpWorkingDir);
            wrapper.setExecutableLocator(this.locator);
            StoryBoard board = new StoryBoard(wrapper, asset);
            for (String arg : args) {
                String frameConfig;
                String value = this.getValue(arg);
                if (arg.startsWith("frames:")) {
                    board.setFrames(NumberUtils.toInt(value, 10));
                    continue;
                }
                if (arg.startsWith("start:")) {
                    board.setStart(NumberUtils.toInt(value, 0));
                    continue;
                }
                if (arg.startsWith("maxWidth:")) {
                    board.setMaxWidth(NumberUtils.toInt(value, 0));
                    continue;
                }
                if (arg.startsWith("maxHeight:")) {
                    board.setMaxHeight(NumberUtils.toInt(value, 0));
                    continue;
                }
                if (arg.startsWith("upScale:")) {
                    if (null == value) continue;
                    board.setUpscale(BooleanUtils.toBoolean(value));
                    continue;
                }
                if (!arg.startsWith("[") || !arg.endsWith("]") || !StringUtils.isNotBlank(frameConfig = StringUtils.replaceEach(arg, new String[]{"[", "]"}, new String[]{"", ""}))) continue;
                board.addFrame(frameConfig);
            }
            board.create();
            log.info("created storyboard for video [{}]", (Object)asset.getPath());
        }
        finally {
            try {
                if (tmpWorkingDir != null) {
                    FileUtils.deleteDirectory(tmpWorkingDir);
                }
            }
            catch (IOException e) {
                log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
            }
        }
    }

    private String getValue(String arg) {
        String[] strings = StringUtils.split(arg, ":");
        return strings.length == 2 ? strings[1] : null;
    }

    @Override
    public String[] buildArguments(MetaDataMap metaData) {
        String[] frames;
        Boolean upScale;
        Integer maxHeight;
        Integer maxWidth;
        Integer start;
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        Integer frameCount = (Integer)((Object)metaData.get(Arguments.FRAME_COUNT.name(), Integer.class));
        if (frameCount != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.FRAME_COUNT.getArgumentPrefix()).append(frameCount);
            arguments.add(builder.toString());
        }
        if ((start = (Integer)((Object)metaData.get(Arguments.START.name(), Integer.class))) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.START.getArgumentPrefix()).append(start);
            arguments.add(builder.toString());
        }
        if ((maxWidth = (Integer)((Object)metaData.get(Arguments.MAX_WIDTH.name(), Integer.class))) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.MAX_WIDTH.getArgumentPrefix()).append(maxWidth);
            arguments.add(builder.toString());
        }
        if ((maxHeight = (Integer)((Object)metaData.get(Arguments.MAX_HEIGHT.name(), Integer.class))) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.MAX_HEIGHT.getArgumentPrefix()).append(maxHeight);
            arguments.add(builder.toString());
        }
        if ((upScale = (Boolean)((Object)metaData.get(Arguments.UPSCALE.name(), Boolean.class))) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.UPSCALE.getArgumentPrefix()).append(upScale);
            arguments.add(builder.toString());
        }
        if ((frames = (String[])metaData.get(Arguments.FRAMES.name(), String[].class)) != null) {
            for (String frame : frames) {
                if (!frame.startsWith("[")) {
                    frame = "[" + frame;
                }
                if (!frame.endsWith("]")) {
                    frame = frame + "]";
                }
                arguments.add(frame);
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        FRAME_COUNT("frames"),
        START("start"),
        MAX_WIDTH("maxWidth"),
        MAX_HEIGHT("maxHeight"),
        UPSCALE("upScale"),
        FRAMES("");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

