/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.replication;

import com.day.cq.replication.AgentConfig;
import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationLog;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationAction
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationAction.class);
    private static final long serialVersionUID = -151606943486007293L;
    public static final String EVENT_TOPIC = "com/day/cq/replication";
    public static final String PROPERTY_MODIFICATION_DATE = "modificationDate";
    public static final String PROPERTY_USER_ID = "userId";
    public static final String PROPERTY_PATH = "path";
    public static final String PROPERTY_PATHS = "paths";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_REVISION = "revision";
    public static final String PN_PATH = "cq:repPath";
    public static final String PN_ACTION_TYPE = "cq:repActionType";
    private final ReplicationActionType type;
    private final String[] paths;
    private final long time;
    private final String userId;
    private String revision;
    private transient AgentConfig config;
    private transient ReplicationLog log;

    public ReplicationAction(ReplicationActionType type, String path, long time, String userId, String revision) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        if (userId == null) {
            throw new IllegalArgumentException("Userid must not be null.");
        }
        this.type = type;
        this.paths = new String[]{path};
        this.time = time == 0L ? System.currentTimeMillis() : time;
        this.userId = userId;
        this.revision = revision;
    }

    public ReplicationAction(ReplicationActionType type, String[] paths, long time, String userId, String revision) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null.");
        }
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Paths must not be null or empty.");
        }
        if (userId == null) {
            throw new IllegalArgumentException("Userid must not be null.");
        }
        this.type = type;
        this.paths = paths;
        this.time = time == 0L ? System.currentTimeMillis() : time;
        this.userId = userId;
        this.revision = revision;
    }

    public ReplicationAction(ReplicationActionType type, String path) {
        this(type, path, 0L, "", null);
    }

    public ReplicationActionType getType() {
        return this.type;
    }

    public String getPath() {
        if (this.paths.length > 1) {
            LOG.warn("Using getPath() while {} paths available", (Object)this.paths.length);
        }
        return this.paths[0];
    }

    public String[] getPaths() {
        return this.paths;
    }

    public String getRevision() {
        return this.revision;
    }

    public long getTime() {
        return this.time;
    }

    public String getUserId() {
        return this.userId;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public void setConfig(AgentConfig config) {
        this.config = config;
    }

    public ReplicationLog getLog() {
        return this.log;
    }

    public void setLog(ReplicationLog log) {
        this.log = log;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicationAction");
        sb.append("{type=").append((Object)this.type);
        sb.append(", path[0]='").append(this.paths[0]).append('\'');
        sb.append(", time=").append(this.time);
        sb.append(", userId='").append(this.userId).append('\'');
        sb.append(", revision='").append(this.revision).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static ReplicationAction fromEvent(Event evt) {
        if (!evt.getTopic().equals(EVENT_TOPIC)) {
            return null;
        }
        Object lastMod = evt.getProperty(PROPERTY_MODIFICATION_DATE);
        long time = 0L;
        if (lastMod instanceof Date) {
            time = ((Date)lastMod).getTime();
        } else if (lastMod instanceof Calendar) {
            time = ((Calendar)lastMod).getTimeInMillis();
        } else if (lastMod instanceof Long) {
            time = (Long)lastMod;
        }
        String[] paths = (String[])evt.getProperty(PROPERTY_PATHS);
        if (paths == null) {
            paths = new String[]{(String)evt.getProperty(PROPERTY_PATH)};
        }
        return new ReplicationAction(ReplicationActionType.fromName((String)evt.getProperty(PROPERTY_TYPE)), paths, time, (String)evt.getProperty(PROPERTY_USER_ID), (String)evt.getProperty(PROPERTY_REVISION));
    }

    public Map<String, Object> createEventProperties(boolean distribute) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(PROPERTY_TYPE, this.type.toString());
        properties.put(PROPERTY_PATHS, this.paths);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.time);
        properties.put(PROPERTY_MODIFICATION_DATE, c);
        properties.put(PROPERTY_USER_ID, this.userId);
        if (this.revision != null) {
            properties.put(PROPERTY_REVISION, this.revision);
        }
        if (distribute) {
            properties.put("event.distribute", "");
        }
        return new EventProperties(properties);
    }

    public Event toEvent() {
        return this.toEvent(false);
    }

    public Event toEvent(boolean distribute) {
        return new Event(EVENT_TOPIC, this.createEventProperties(distribute));
    }
}

