/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import java.io.EOFException;
import java.io.IOException;

@Deprecated(since="2024-11-20")
public class SequentialByteArrayReader
extends SequentialReader {
    @NotNull
    private final byte[] _bytes;
    private int _index;

    @Override
    public long getPosition() {
        return this._index;
    }

    public SequentialByteArrayReader(@NotNull byte[] bytes) {
        this(bytes, 0);
    }

    public SequentialByteArrayReader(@NotNull byte[] bytes, int baseIndex) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        this._bytes = bytes;
        this._index = baseIndex;
    }

    @Override
    public byte getByte() throws IOException {
        if (this._index >= this._bytes.length) {
            throw new EOFException("End of data reached.");
        }
        return this._bytes[this._index++];
    }

    @Override
    @NotNull
    public byte[] getBytes(int count) throws IOException {
        if ((long)this._index + (long)count > (long)this._bytes.length) {
            throw new EOFException("End of data reached.");
        }
        byte[] bytes = new byte[count];
        System.arraycopy(this._bytes, this._index, bytes, 0, count);
        this._index += count;
        return bytes;
    }

    @Override
    public void getBytes(@NotNull byte[] buffer, int offset, int count) throws IOException {
        if ((long)this._index + (long)count > (long)this._bytes.length) {
            throw new EOFException("End of data reached.");
        }
        System.arraycopy(this._bytes, this._index, buffer, offset, count);
        this._index += count;
    }

    @Override
    public void skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        if ((long)this._index + n > (long)this._bytes.length) {
            throw new EOFException("End of data reached.");
        }
        this._index = (int)((long)this._index + n);
    }

    @Override
    public boolean trySkip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be zero or greater.");
        }
        if ((long)this._index + n > (long)this._bytes.length) {
            this._index = this._bytes.length;
            return false;
        }
        this._index = (int)((long)this._index + n);
        return true;
    }

    @Override
    public int available() {
        return this._bytes.length - this._index;
    }
}

