/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.InputStreamPumper;
import org.apache.commons.exec.StreamPumper;
import org.apache.commons.exec.ThreadUtil;
import org.apache.commons.exec.util.DebugUtils;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private static final Duration STOP_TIMEOUT_ADDITION = Duration.ofSeconds(2L);
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private final OutputStream outputStream;
    private final OutputStream errorOutputStream;
    private final InputStream inputStream;
    private InputStreamPumper inputStreamPumper;
    private Duration stopTimeout = Duration.ZERO;
    private IOException caught;
    private final ThreadFactory threadFactory;

    public PumpStreamHandler() {
        this(System.out, System.err);
    }

    public PumpStreamHandler(OutputStream allOutputStream) {
        this(allOutputStream, allOutputStream);
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream errorOutputStream) {
        this(outputStream, errorOutputStream, null);
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream errorOutputStream, InputStream inputStream) {
        this(Executors.defaultThreadFactory(), outputStream, errorOutputStream, inputStream);
    }

    private PumpStreamHandler(ThreadFactory threadFactory, OutputStream outputStream, OutputStream errorOutputStream, InputStream inputStream) {
        this.threadFactory = threadFactory;
        this.outputStream = outputStream;
        this.errorOutputStream = errorOutputStream;
        this.inputStream = inputStream;
    }

    protected void createProcessErrorPump(InputStream is, OutputStream os) {
        this.errorThread = this.createPump(is, os);
    }

    protected void createProcessOutputPump(InputStream is, OutputStream os) {
        this.outputThread = this.createPump(is, os);
    }

    protected Thread createPump(InputStream is, OutputStream os) {
        return this.createPump(is, os, os instanceof PipedOutputStream);
    }

    protected Thread createPump(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        return ThreadUtil.newThread(this.threadFactory, new StreamPumper(is, os, closeWhenExhausted), "CommonsExecStreamPumper-", true);
    }

    private Thread createSystemInPump(InputStream is, OutputStream os) {
        this.inputStreamPumper = new InputStreamPumper(is, os);
        return ThreadUtil.newThread(this.threadFactory, this.inputStreamPumper, "CommonsExecStreamPumper-", true);
    }

    protected OutputStream getErr() {
        return this.errorOutputStream;
    }

    protected OutputStream getOut() {
        return this.outputStream;
    }

    Duration getStopTimeout() {
        return this.stopTimeout;
    }

    @Override
    public void setProcessErrorStream(InputStream is) {
        if (this.errorOutputStream != null) {
            this.createProcessErrorPump(is, this.errorOutputStream);
        }
    }

    @Override
    public void setProcessInputStream(OutputStream os) {
        if (this.inputStream != null) {
            this.inputThread = this.inputStream == System.in ? this.createSystemInPump(this.inputStream, os) : this.createPump(this.inputStream, os, true);
        } else {
            try {
                os.close();
            }
            catch (IOException e) {
                String msg = "Got exception while closing output stream";
                DebugUtils.handleException((String)"Got exception while closing output stream", (Exception)e);
            }
        }
    }

    @Override
    public void setProcessOutputStream(InputStream is) {
        if (this.outputStream != null) {
            this.createProcessOutputPump(is, this.outputStream);
        }
    }

    public void setStopTimeout(Duration timeout) {
        this.stopTimeout = timeout != null ? timeout : Duration.ZERO;
    }

    @Deprecated
    public void setStopTimeout(long timeout) {
        this.stopTimeout = Duration.ofMillis(timeout);
    }

    @Override
    public void start() {
        this.start(this.outputThread);
        this.start(this.errorThread);
        this.start(this.inputThread);
    }

    private void start(Thread thread) {
        if (thread != null) {
            thread.start();
        }
    }

    @Override
    public void stop() throws IOException {
        String msg;
        if (this.inputStreamPumper != null) {
            this.inputStreamPumper.stopProcessing();
        }
        this.stop(this.outputThread, this.stopTimeout);
        this.stop(this.errorThread, this.stopTimeout);
        this.stop(this.inputThread, this.stopTimeout);
        if (this.errorOutputStream != null && this.errorOutputStream != this.outputStream) {
            try {
                this.errorOutputStream.flush();
            }
            catch (IOException e) {
                msg = "Got exception while flushing the error stream : " + e.getMessage();
                DebugUtils.handleException((String)msg, (Exception)e);
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException e) {
                msg = "Got exception while flushing the output stream";
                DebugUtils.handleException((String)"Got exception while flushing the output stream", (Exception)e);
            }
        }
        if (this.caught != null) {
            throw this.caught;
        }
    }

    private void stop(Thread thread, Duration timeout) {
        if (thread != null) {
            try {
                if (timeout.equals(Duration.ZERO)) {
                    thread.join();
                } else {
                    Duration timeToWait = timeout.plus(STOP_TIMEOUT_ADDITION);
                    Instant startTime = Instant.now();
                    thread.join(timeToWait.toMillis());
                    if (Instant.now().isAfter(startTime.plus(timeToWait))) {
                        this.caught = new ExecuteException("The stop timeout of " + timeout + " ms was exceeded", -559038737);
                    }
                }
            }
            catch (InterruptedException e) {
                thread.interrupt();
            }
        }
    }

    protected void stopThread(Thread thread, long timeoutMillis) {
        this.stop(thread, Duration.ofMillis(timeoutMillis));
    }
}

