/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.LongUtils;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.json.BlobDeserializer;
import org.apache.jackrabbit.oak.json.TypeCodes;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class JsonDeserializer {
    private static final Set<String> NAME_PROPS = Set.of("jcr:primaryType", "jcr:mixinTypes");
    private static final String ORDERABLE_TYPE = "nt:unstructured";
    private static final String OAK_CHILD_ORDER = ":childOrder";
    private final BlobDeserializer blobHandler;

    private static Type<?> inferPropertyType(String propertyName, String jsonString) {
        if (NAME_PROPS.contains(propertyName) && JsonDeserializer.hasSingleColon(jsonString)) {
            return Type.NAME;
        }
        return Type.UNDEFINED;
    }

    private static boolean hasOrderableChildren(NodeBuilder builder) {
        PropertyState primaryType = builder.getProperty("jcr:primaryType");
        return primaryType != null && ORDERABLE_TYPE.equals(primaryType.getValue(Type.NAME));
    }

    private static boolean hasSingleColon(String jsonString) {
        int colonCount = 0;
        for (int i = 0; i < jsonString.length() && colonCount < 2; ++i) {
            if (jsonString.charAt(i) != ':') continue;
            ++colonCount;
        }
        return colonCount == 1;
    }

    public JsonDeserializer(BlobDeserializer blobHandler) {
        this.blobHandler = blobHandler;
    }

    public NodeState deserialize(String json) {
        return this.deserialize(json, 0);
    }

    public NodeState deserialize(String line, int pos) {
        JsopTokenizer reader = new JsopTokenizer(line, pos);
        reader.read(123);
        NodeState state = this.deserialize(reader);
        reader.read(0);
        return state;
    }

    public NodeState deserialize(JsopReader reader) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        this.readNode(reader, builder);
        return builder.getNodeState();
    }

    private void readNode(JsopReader reader, NodeBuilder builder) {
        ArrayList<String> childNames = new ArrayList<String>();
        if (!reader.matches(125)) {
            do {
                String key = reader.readString();
                reader.read(58);
                if (reader.matches(123)) {
                    childNames.add(key);
                    this.readNode(reader, builder.child(key));
                    continue;
                }
                if (reader.matches(91)) {
                    builder.setProperty(this.readArrayProperty(key, reader));
                    continue;
                }
                builder.setProperty(this.readProperty(key, reader));
            } while (reader.matches(44));
            reader.read(125);
        }
        if (JsonDeserializer.hasOrderableChildren(builder) && !builder.hasProperty(OAK_CHILD_ORDER)) {
            builder.setProperty(OAK_CHILD_ORDER, childNames, Type.NAMES);
        }
    }

    private PropertyState readProperty(String name, JsopReader reader) {
        if (reader.matches(1)) {
            String jsonString = reader.getToken();
            Type<?> inferredType = JsonDeserializer.inferPropertyType(name, jsonString);
            if (jsonString.startsWith("[0]:")) {
                int type = PropertyType.valueFromName(jsonString.substring("[0]:".length()));
                return PropertyStates.createProperty(name, List.of(), Type.fromTag(type, true));
            }
            int split = TypeCodes.split(jsonString);
            if (split != -1) {
                int type = TypeCodes.decodeType(split, jsonString);
                String value = TypeCodes.decodeName(split, jsonString);
                if (type == 2) {
                    return BinaryPropertyState.binaryProperty(name, this.blobHandler.deserialize(value));
                }
                if (type == 0) {
                    Type<Object> oakType = inferredType != Type.UNDEFINED ? inferredType : Type.STRING;
                    return PropertyStates.createProperty(name, (Object)jsonString, oakType);
                }
                return PropertyStates.createProperty(name, value, type);
            }
            Type<Object> oakType = inferredType != Type.UNDEFINED ? inferredType : Type.STRING;
            return PropertyStates.createProperty(name, (Object)jsonString, oakType);
        }
        if (reader.matches(2)) {
            String number = reader.getToken();
            Long maybeLong = LongUtils.tryParse(number);
            if (maybeLong == null) {
                return new DoublePropertyState(name, Double.parseDouble(number));
            }
            return new LongPropertyState(name, maybeLong);
        }
        if (reader.matches(3)) {
            return BooleanPropertyState.booleanProperty(name, true);
        }
        if (reader.matches(4)) {
            return BooleanPropertyState.booleanProperty(name, false);
        }
        throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
    }

    private PropertyState readArrayProperty(String name, JsopReader reader) {
        int type = 1;
        ArrayList<Object> values = new ArrayList<Object>();
        while (!reader.matches(93)) {
            if (reader.matches(1)) {
                String jsonString = reader.getToken();
                Type<?> inferredType = JsonDeserializer.inferPropertyType(name, jsonString);
                int split = TypeCodes.split(jsonString);
                if (split != -1) {
                    type = TypeCodes.decodeType(split, jsonString);
                    String value = TypeCodes.decodeName(split, jsonString);
                    if (type == 2) {
                        values.add(this.blobHandler.deserialize(value));
                    } else if (type == 4) {
                        values.add(Conversions.convert(value).toDouble());
                    } else if (type == 12) {
                        values.add(Conversions.convert(value).toDecimal());
                    } else if (type == 0) {
                        type = inferredType != Type.UNDEFINED ? inferredType.tag() : 1;
                        values.add(jsonString);
                    } else {
                        values.add(value);
                    }
                } else {
                    type = inferredType != Type.UNDEFINED ? inferredType.tag() : 1;
                    values.add(jsonString);
                }
            } else if (reader.matches(2)) {
                String number = reader.getToken();
                Long maybeLong = LongUtils.tryParse(number);
                if (maybeLong == null) {
                    type = 4;
                    values.add(Double.parseDouble(number));
                } else {
                    type = 3;
                    values.add(maybeLong);
                }
            } else if (reader.matches(3)) {
                type = 6;
                values.add(Boolean.TRUE);
            } else if (reader.matches(4)) {
                type = 6;
                values.add(Boolean.FALSE);
            } else {
                throw new IllegalArgumentException("Unexpected token: " + reader.getToken());
            }
            reader.matches(44);
        }
        return PropertyStates.createProperty(name, values, Type.fromTag(type, true));
    }
}

