/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.name.Namespaces;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalNameMapper
implements NameMapper {
    private final Root root;
    private Tree namespaces;
    private Tree nsdata;

    protected static boolean isHiddenName(String name) {
        return name.startsWith(":");
    }

    private static boolean isValidNamespaceName(String namespace) {
        return namespace.isEmpty() || namespace.equals("internal") || namespace.contains(":");
    }

    protected static boolean isExpandedName(String name) {
        int brace;
        if (name.startsWith("{") && (brace = name.indexOf(125, 1)) != -1) {
            return GlobalNameMapper.isValidNamespaceName(name.substring(1, brace));
        }
        return false;
    }

    public GlobalNameMapper(Root root) {
        this.root = root;
        this.init();
    }

    public GlobalNameMapper(NodeState root) {
        this(RootFactory.createReadOnlyRoot(root));
    }

    private void init() {
        if (this.root != null) {
            this.namespaces = this.root.getTree("/jcr:system/rep:namespaces");
            this.nsdata = this.namespaces.getChild("rep:nsdata");
        }
    }

    public GlobalNameMapper(Map<String, String> mappings) {
        NodeBuilder forward = EmptyNodeState.EMPTY_NODE.builder();
        NodeBuilder reverse = EmptyNodeState.EMPTY_NODE.builder();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            String prefix = entry.getKey();
            if (prefix.isEmpty()) continue;
            String uri = entry.getValue();
            forward.setProperty(prefix, uri);
            reverse.setProperty(Namespaces.encodeUri(uri), prefix);
        }
        reverse.setProperty("rep:prefixes", mappings.keySet(), Type.STRINGS);
        reverse.setProperty("rep:uris", mappings.values(), Type.STRINGS);
        this.root = null;
        this.namespaces = TreeFactory.createReadOnlyTree(forward.getNodeState());
        this.nsdata = TreeFactory.createReadOnlyTree(reverse.getNodeState());
    }

    @Override
    @NotNull
    public String getJcrName(@NotNull String oakName) {
        Objects.requireNonNull(oakName);
        Validate.checkArgument((!GlobalNameMapper.isHiddenName(oakName) ? 1 : 0) != 0, (String)oakName);
        Validate.checkArgument((!GlobalNameMapper.isExpandedName(oakName) ? 1 : 0) != 0, (String)oakName);
        return oakName;
    }

    @Override
    @NotNull
    public String getExpandedJcrName(@NotNull String oakName) {
        String localName;
        String uri;
        Objects.requireNonNull(oakName);
        Validate.checkArgument((!GlobalNameMapper.isHiddenName(oakName) ? 1 : 0) != 0, (String)oakName);
        Validate.checkArgument((!GlobalNameMapper.isExpandedName(oakName) ? 1 : 0) != 0, (String)oakName);
        int colon = oakName.indexOf(58);
        if (colon > 0) {
            String oakPrefix = oakName.substring(0, colon);
            uri = this.getNamespacesProperty(oakPrefix);
            if (uri == null) {
                uri = this.getSessionLocalMappings().get(oakPrefix);
            }
            if (uri == null) {
                throw new IllegalStateException(new NamespaceException("No namespace mapping found for " + oakName));
            }
            localName = oakName.substring(colon + 1);
            if (!GlobalNameMapper.isValidNamespaceName(uri)) {
                throw new IllegalStateException(new NamespaceException("Cannot determine expanded name for '" + oakName + "' as registered namespace name '" + uri + "' is invalid"));
            }
        } else {
            uri = "";
            localName = oakName;
        }
        return "{" + uri + "}" + localName;
    }

    @Override
    @Nullable
    public String getOakNameOrNull(@NotNull String jcrName) {
        if (jcrName.startsWith("{")) {
            return this.getOakNameFromExpanded(jcrName);
        }
        return jcrName;
    }

    @Override
    @NotNull
    public String getOakName(@NotNull String jcrName) throws RepositoryException {
        String oakName = this.getOakNameOrNull(jcrName);
        if (oakName == null) {
            throw new RepositoryException("Invalid jcr name " + jcrName);
        }
        return oakName;
    }

    @Override
    @NotNull
    public Map<String, String> getSessionLocalMappings() {
        return Collections.emptyMap();
    }

    @Nullable
    protected String getOakNameFromExpanded(String expandedName) {
        Validate.checkArgument((boolean)expandedName.startsWith("{"));
        int brace = expandedName.indexOf(125, 1);
        if (brace > 0) {
            String uri = expandedName.substring(1, brace);
            if (uri.isEmpty()) {
                return expandedName.substring(2);
            }
            if (uri.equals("internal")) {
                return "rep:" + expandedName.substring(brace + 1);
            }
            if (uri.indexOf(58) != -1) {
                String oakPrefix = this.getOakPrefixOrNull(uri);
                if (oakPrefix != null) {
                    return oakPrefix + ":" + expandedName.substring(brace + 1);
                }
                return null;
            }
        }
        return expandedName;
    }

    @Nullable
    protected synchronized String getOakPrefixOrNull(String uri) {
        if (uri.isEmpty()) {
            return uri;
        }
        return this.getNsData(Namespaces.encodeUri(uri));
    }

    @Nullable
    protected synchronized String getOakURIOrNull(String prefix) {
        if (prefix.isEmpty()) {
            return prefix;
        }
        return this.getNamespacesProperty(prefix);
    }

    protected String getNamespacesProperty(String prefix) {
        return TreeUtil.getString(this.namespaces, prefix);
    }

    private String getNsData(String uri) {
        return TreeUtil.getString(this.nsdata, uri);
    }

    protected Iterable<String> getPrefixes() {
        Iterable<String> prefs = TreeUtil.getStrings(this.nsdata, "rep:prefixes");
        if (prefs != null) {
            return prefs;
        }
        return Collections.emptyList();
    }

    public void onSessionRefresh() {
        this.init();
    }
}

