/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.pio.Closer;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexMBeanRegistration;
import org.apache.jackrabbit.oak.plugins.index.TrackingCorruptIndexHandler;
import org.apache.jackrabbit.oak.plugins.index.WhiteboardIndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindex;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
@Designate(ocd=Configuration.class)
public class AsyncIndexerService {
    private static final char CONFIG_SEP = ':';
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WhiteboardIndexEditorProvider indexEditorProvider = new WhiteboardIndexEditorProvider();
    @Reference
    private NodeStore nodeStore;
    @Reference(target="(type=changeCollectorProvider)")
    private ValidatorProvider validatorProvider;
    @Reference
    private StatisticsProvider statisticsProvider;
    private IndexMBeanRegistration indexRegistration;
    private final Closer closer = Closer.create();
    private WhiteboardExecutor executor;

    @Activate
    public void activate(BundleContext bundleContext, Configuration config) {
        List<AsyncConfig> asyncIndexerConfig = AsyncIndexerService.getAsyncConfig(config.asyncConfigs());
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(bundleContext);
        this.indexRegistration = new IndexMBeanRegistration(whiteboard);
        this.indexEditorProvider.start(whiteboard);
        this.executor = new WhiteboardExecutor();
        this.executor.start(whiteboard);
        TrackingCorruptIndexHandler corruptIndexHandler = this.createCorruptIndexHandler(config);
        for (AsyncConfig c : asyncIndexerConfig) {
            AsyncIndexUpdate task = new AsyncIndexUpdate(c.name, this.nodeStore, this.indexEditorProvider, this.statisticsProvider, false);
            task.setCorruptIndexHandler(corruptIndexHandler);
            task.setValidatorProviders(Collections.singletonList(this.validatorProvider));
            long leaseTimeOutMin = config.leaseTimeOutMinutes();
            if (!(this.nodeStore instanceof Clusterable)) {
                leaseTimeOutMin = 0L;
                this.log.info("Detected non clusterable setup. Lease checking would be disabled for async indexing");
            } else if (c.leaseTimeOutInMin != null) {
                leaseTimeOutMin = c.leaseTimeOutInMin;
                this.log.info("Lease time out for {} configured as {} mins.", (Object)c.name, (Object)leaseTimeOutMin);
            } else {
                this.log.info("Lease time out for {} not configured explicitly. Using value {} mins configured via Lease Time out property.", (Object)c.name, (Object)leaseTimeOutMin);
            }
            task.setLeaseTimeOut(TimeUnit.MINUTES.toMillis(leaseTimeOutMin));
            this.indexRegistration.registerAsyncIndexer(task, c.timeIntervalInSecs);
            this.closer.register((Closeable)task);
        }
        this.registerAsyncReindexSupport(whiteboard);
        this.log.info("Configured async indexers {} ", (Object)asyncIndexerConfig);
    }

    private void registerAsyncReindexSupport(Whiteboard whiteboard) {
        String name = "async-reindex";
        AsyncIndexUpdate task = new AsyncIndexUpdate(name, this.nodeStore, this.indexEditorProvider, this.statisticsProvider, true);
        PropertyIndexAsyncReindex asyncPI = new PropertyIndexAsyncReindex(task, (Executor)this.executor);
        CompositeRegistration reg = new CompositeRegistration(WhiteboardUtils.registerMBean(whiteboard, PropertyIndexAsyncReindexMBean.class, asyncPI, "PropertyIndexAsyncReindex", "async"), WhiteboardUtils.registerMBean(whiteboard, IndexStatsMBean.class, task.getIndexStats(), "IndexStats", name));
        this.closer.register(reg::unregister);
    }

    @Deactivate
    public void deactivate() throws IOException {
        if (this.indexRegistration != null) {
            this.indexRegistration.unregister();
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
        this.closer.close();
    }

    private TrackingCorruptIndexHandler createCorruptIndexHandler(Configuration config) {
        long failingIndexTimeoutSeconds = config.failingIndexTimeoutSeconds();
        long errorWarnIntervalSeconds = config.errorWarnIntervalSeconds();
        TrackingCorruptIndexHandler corruptIndexHandler = new TrackingCorruptIndexHandler();
        corruptIndexHandler.setCorruptInterval(failingIndexTimeoutSeconds, TimeUnit.SECONDS);
        corruptIndexHandler.setErrorWarnInterval(errorWarnIntervalSeconds, TimeUnit.SECONDS);
        corruptIndexHandler.setMeterStats(this.statisticsProvider.getMeter("corrupt-index", StatsOptions.METRICS_ONLY));
        if (failingIndexTimeoutSeconds <= 0L) {
            this.log.info("[failingIndexTimeoutSeconds] is set to {}. Auto corrupt index isolation handling is disabled, warning log would be logged every {} s", (Object)failingIndexTimeoutSeconds, (Object)errorWarnIntervalSeconds);
        } else {
            this.log.info("Auto corrupt index isolation handling is enabled. Any async index which fails for {}s would be marked as corrupted and would be skipped from further indexing. A warning log would be logged every {} s", (Object)failingIndexTimeoutSeconds, (Object)errorWarnIntervalSeconds);
        }
        return corruptIndexHandler;
    }

    static List<AsyncConfig> getAsyncConfig(String[] configs) {
        ArrayList<AsyncConfig> result = new ArrayList<AsyncConfig>();
        for (String config : configs) {
            int idOfEq = config.indexOf(58);
            Validate.checkArgument((idOfEq > 0 ? 1 : 0) != 0, (String)"Invalid config provided [%s]", (Object[])new Object[]{Arrays.toString(configs)});
            String[] configElements = config.split(String.valueOf(':'));
            String name = configElements[0].trim();
            Long interval = configElements.length > 1 ? Long.valueOf(Long.parseLong(configElements[1].trim())) : null;
            Long leaseTimeOut = configElements.length > 2 ? Long.valueOf(Long.parseLong(configElements[2].trim())) : null;
            result.add(new AsyncConfig(name, interval, leaseTimeOut));
        }
        return result;
    }

    static class AsyncConfig {
        final String name;
        final Long timeIntervalInSecs;
        final Long leaseTimeOutInMin;

        private AsyncConfig(String name, Long timeIntervalInSecs, Long leaseTimeOutInMin) {
            this.name = AsyncIndexUpdate.checkValidName(name);
            this.timeIntervalInSecs = timeIntervalInSecs;
            this.leaseTimeOutInMin = leaseTimeOutInMin;
        }

        public String toString() {
            return "AsyncConfig{name='" + this.name + "', timeIntervalInSecs=" + this.timeIntervalInSecs + ", leaseTimeOutInMin=" + this.leaseTimeOutInMin + "}";
        }
    }

    @ObjectClassDefinition(name="Apache Jackrabbit Oak Async Indexer Service", description="Configures the async indexer services which performs periodic indexing of repository content")
    static @interface Configuration {
        @AttributeDefinition(cardinality=1024, name="Async Indexer Configs", description="Async indexer configs in the form of <name>:<interval in secs>:<lease time out in minutes> e.g. \"async:5:15\"")
        public String[] asyncConfigs() default {"async:5:15"};

        @AttributeDefinition(name="Lease time out", description="Lease timeout in minutes. AsyncIndexer would wait for this timeout period before breaking async indexer lease")
        public long leaseTimeOutMinutes() default 15L;

        @AttributeDefinition(name="Failing Index Timeout (s)", description="Time interval in seconds after which a failing index is considered as corrupted and ignored from further indexing until reindex. The default is 7 days (7 * 24 * 60 * 60 = 604800). To disable this set it to 0.")
        public long failingIndexTimeoutSeconds() default 604800L;

        @AttributeDefinition(name="Error warn interval (s)", description="Time interval in seconds after which a warning log would be logged for skipped indexes. This is done to avoid flooding the log in case of corrupted index.")
        public long errorWarnIntervalSeconds() default 900L;
    }
}

