/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.json.Base64BlobSerializer;
import org.apache.jackrabbit.oak.json.JsonDeserializer;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.index.importer.NodeStoreUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDefinitionUpdater {
    public static final String INDEX_DEFINITIONS_JSON = "index-definitions.json";
    private static final Logger LOG = LoggerFactory.getLogger(IndexDefinitionUpdater.class);
    private final Map<String, NodeState> indexNodeStates;

    public IndexDefinitionUpdater(File file) throws IOException {
        Validate.checkArgument((file.exists() && file.canRead() ? 1 : 0) != 0, (String)"File [%s] cannot be read", (Object[])new Object[]{file});
        this.indexNodeStates = IndexDefinitionUpdater.getIndexDefnStates(FileUtils.readFileToString(file, StandardCharsets.UTF_8));
    }

    public IndexDefinitionUpdater(String json) throws IOException {
        this.indexNodeStates = IndexDefinitionUpdater.getIndexDefnStates(json);
    }

    public void apply(NodeBuilder rootBuilder) throws IOException, CommitFailedException {
        for (Map.Entry<String, NodeState> cne : this.indexNodeStates.entrySet()) {
            String indexPath = cne.getKey();
            this.apply(rootBuilder, indexPath);
        }
    }

    public NodeBuilder apply(NodeBuilder rootBuilder, String indexPath) {
        String indexNodeName = PathUtils.getName(indexPath);
        NodeState newDefinition = this.indexNodeStates.get(indexPath);
        newDefinition = IndexDefinitionUpdater.addOrModifyJcrUUID(newDefinition);
        String parentPath = PathUtils.getParentPath(indexPath);
        NodeState parent = NodeStateUtils.getNode(rootBuilder.getBaseState(), parentPath);
        Validate.checkState((boolean)parent.exists(), (String)"Parent node at path [%s] not found while adding new index definition for [%s]. Intermediate paths node must exist for new index nodes to be created", (Object[])new Object[]{parentPath, indexPath});
        NodeState indexDefinitionNode = parent.getChildNode(indexNodeName);
        if (indexDefinitionNode.exists()) {
            LOG.info("Updating index definition at path [{}]. Changes are ", (Object)indexPath);
            String diff = JsopDiff.diffToJsop(IndexDefinitionUpdater.cloneVisibleState(indexDefinitionNode), IndexDefinitionUpdater.cloneVisibleState(newDefinition));
            LOG.info(diff);
        } else {
            LOG.info("Adding new index definition at path [{}]", (Object)indexPath);
        }
        NodeBuilder indexBuilderParent = NodeStoreUtils.childBuilder(rootBuilder, parentPath);
        Tree t = TreeFactory.createTree(indexBuilderParent);
        t.addChild(indexNodeName);
        indexBuilderParent.setChildNode(indexNodeName, newDefinition);
        return indexBuilderParent.getChildNode(indexNodeName);
    }

    public Set<String> getIndexPaths() {
        return this.indexNodeStates.keySet();
    }

    public NodeState getIndexState(String indexPath) {
        return this.indexNodeStates.getOrDefault(indexPath, EmptyNodeState.EMPTY_NODE);
    }

    private static Map<String, NodeState> getIndexDefnStates(String json) {
        Base64BlobSerializer blobHandler = new Base64BlobSerializer();
        HashMap<String, NodeState> indexDefns = new HashMap<String, NodeState>();
        JsopTokenizer reader = new JsopTokenizer(json);
        reader.read(123);
        if (!reader.matches(125)) {
            do {
                String indexPath;
                if (!(indexPath = reader.readString()).startsWith("/")) {
                    String msg = String.format("Invalid format of index definitions. The key name [%s] should be index path ", indexPath);
                    throw new IllegalArgumentException(msg);
                }
                reader.read(58);
                if (!reader.matches(123)) continue;
                JsonDeserializer deserializer = new JsonDeserializer(blobHandler);
                NodeState idxState = deserializer.deserialize(reader);
                indexDefns.put(indexPath, idxState);
            } while (reader.matches(44));
            reader.read(125);
        }
        return indexDefns;
    }

    private static NodeState cloneVisibleState(NodeState state) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        new ApplyVisibleDiff(builder).apply(state);
        return builder.getNodeState();
    }

    private static NodeState addOrModifyJcrUUID(NodeState state) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        new AddOrUpdateJCRUuid(builder).apply(state);
        return builder.getNodeState();
    }

    private static class AddOrUpdateJCRUuid
    extends ApplyDiff {
        public AddOrUpdateJCRUuid(NodeBuilder builder) {
            super(builder);
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            if (after.getName().equals("jcr:uuid")) {
                AddOrUpdateJCRUuid.addNewJcrUUIDProperty(this.builder);
            } else {
                this.builder.setProperty(after);
            }
            return true;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            NodeBuilder newChild = this.builder.setChildNode(name, after);
            String primaryType = after.getName("jcr:primaryType");
            if (primaryType != null && primaryType.equals("nt:resource") && !newChild.hasProperty("jcr:uuid")) {
                AddOrUpdateJCRUuid.addNewJcrUUIDProperty(newChild);
            }
            return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new AddOrUpdateJCRUuid(this.builder.child(name)));
        }

        private static void addNewJcrUUIDProperty(NodeBuilder builder) {
            String uuid = UUID.randomUUID().toString().toLowerCase(Locale.ROOT);
            builder.setProperty("jcr:uuid", uuid, Type.STRING);
        }
    }

    private static class ApplyVisibleDiff
    extends ApplyDiff {
        public ApplyVisibleDiff(NodeBuilder builder) {
            super(builder);
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            if (NodeStateUtils.isHidden(name)) {
                return true;
            }
            return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new ApplyVisibleDiff(this.builder.child(name)));
        }
    }
}

