/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.log.LogSilencer;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FacetsConfigProvider;
import org.apache.jackrabbit.oak.plugins.index.search.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.search.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.spi.binary.FulltextBinaryTextExtractor;
import org.apache.jackrabbit.oak.plugins.index.search.spi.editor.FulltextDocumentMaker;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneDocumentMaker
extends FulltextDocumentMaker<Document> {
    public static final int STRING_PROPERTY_MAX_LENGTH = 32766;
    private static final Logger LOG = LoggerFactory.getLogger(LuceneDocumentMaker.class);
    private static final String DYNAMIC_BOOST_SPLIT_REGEX = "[:/]";
    private final FacetsConfigProvider facetsConfigProvider;
    private final IndexAugmentorFactory augmentorFactory;
    private static final LogSilencer LOG_SILENCER = new LogSilencer(Duration.ofSeconds(10L).toMillis(), 10);
    private static final String LOG_KEY_DUPLICATE = "Duplicate value";
    private static final String LOG_KEY_NOT_A_DATE_STRING = "Not a date string";
    private static final String LOG_KEY_UNABLE_TO_PARSE = "Unable to parse the provided date field";
    private static final String LOG_KEY_FOR_INPUT_STRING = "For input string";
    private static final String LOG_KEY_IGNORING_FACET_PROPERTY = "Ignoring facet property";
    private static final String LOG_KEY_UNKNOWN = "Unknown";

    public LuceneDocumentMaker(IndexDefinition definition, IndexDefinition.IndexingRule indexingRule, String path) {
        this(null, null, null, definition, indexingRule, path);
    }

    public LuceneDocumentMaker(@Nullable FulltextBinaryTextExtractor textExtractor, @Nullable FacetsConfigProvider facetsConfigProvider, @Nullable IndexAugmentorFactory augmentorFactory, IndexDefinition definition, IndexDefinition.IndexingRule indexingRule, String path) {
        super(textExtractor, definition, indexingRule, path);
        this.facetsConfigProvider = facetsConfigProvider;
        this.augmentorFactory = augmentorFactory;
    }

    protected void indexAnalyzedProperty(Document doc, String pname, String value, PropertyDefinition pd) {
        String analyzedPropName = this.constructAnalyzedPropertyName(pname);
        doc.add(FieldFactory.newPropertyField(analyzedPropName, value, !pd.skipTokenization(pname), pd.stored));
    }

    protected void indexSuggestValue(Document doc, String value) {
        doc.add(FieldFactory.newSuggestField(value));
    }

    protected void indexSpellcheckValue(Document doc, String value) {
        doc.add(FieldFactory.newPropertyField(":spellcheck", value, true, false));
    }

    protected void indexFulltextValue(Document doc, String value) {
        doc.add(FieldFactory.newFulltextField(value));
    }

    protected void indexAncestors(Document doc, String path) {
        doc.add(FieldFactory.newAncestorsField(PathUtils.getParentPath(path)));
        doc.add(FieldFactory.newDepthField(path));
    }

    protected void indexTypedProperty(Document doc, PropertyState property, String pname, PropertyDefinition pd, int i) {
        Field f;
        int tag = property.getType().tag();
        if (tag == Type.LONG.tag()) {
            f = new LongField(pname, (long)property.getValue(Type.LONG, i), Field.Store.NO);
        } else if (tag == Type.DATE.tag()) {
            String date = property.getValue(Type.DATE, i);
            f = new LongField(pname, (long)FieldFactory.dateToLong(date), Field.Store.NO);
        } else {
            f = tag == Type.DOUBLE.tag() ? new DoubleField(pname, (double)property.getValue(Type.DOUBLE, i), Field.Store.NO) : (tag == Type.BOOLEAN.tag() ? new StringField(pname, property.getValue(Type.BOOLEAN, i).toString(), Field.Store.NO) : new StringField(pname, property.getValue(Type.STRING, i), Field.Store.NO));
        }
        doc.add(f);
    }

    protected void indexNotNullProperty(Document doc, PropertyDefinition pd) {
        doc.add(new StringField(":notNullProps", pd.name, Field.Store.NO));
    }

    protected void indexNullProperty(Document doc, PropertyDefinition pd) {
        doc.add(new StringField(":nullProps", pd.name, Field.Store.NO));
    }

    private String constructAnalyzedPropertyName(String pname) {
        if (this.definition.getVersion().isAtLeast(IndexFormatVersion.V2)) {
            return FieldNames.createAnalyzedFieldName((String)pname);
        }
        return pname;
    }

    protected boolean addBinary(Document doc, String path, List<String> binaryValues) {
        boolean added = false;
        for (String binaryValue : binaryValues) {
            if (path != null) {
                doc.add(FieldFactory.newFulltextField(path, binaryValue, true));
            } else {
                doc.add(FieldFactory.newFulltextField(binaryValue, true));
            }
            added = true;
        }
        return added;
    }

    protected boolean indexFacetProperty(Document doc, int tag, PropertyState property, String pname) {
        boolean fieldAdded;
        block6: {
            String facetFieldName = FieldNames.createFacetFieldName((String)pname);
            this.getFacetsConfig().setIndexFieldName(pname, facetFieldName);
            fieldAdded = false;
            try {
                String value;
                if (tag == Type.STRINGS.tag() && property.isArray()) {
                    this.getFacetsConfig().setMultiValued(pname, true);
                    Iterable<String> values = property.getValue(Type.STRINGS);
                    for (String value2 : values) {
                        if (value2 == null || value2.isEmpty()) continue;
                        doc.add(new SortedSetDocValuesFacetField(pname, value2));
                    }
                    fieldAdded = true;
                } else if (tag == Type.STRING.tag() && !(value = property.getValue(Type.STRING)).isEmpty()) {
                    doc.add(new SortedSetDocValuesFacetField(pname, value));
                    fieldAdded = true;
                }
            }
            catch (Throwable e) {
                if (LOG_SILENCER.silence(LOG_KEY_IGNORING_FACET_PROPERTY)) break block6;
                LOG.warn("[{}] Ignoring facet property. Could not convert property {} of type {} to type {} for path {}", this.getIndexName(), pname, Type.fromTag(property.getType().tag(), false), Type.fromTag(tag, false), this.path, e);
            }
        }
        return fieldAdded;
    }

    protected void indexAggregateValue(Document doc, Aggregate.NodeIncludeResult result, String value, PropertyDefinition pd) {
        Field field;
        Field field2 = field = result.isRelativeNode() ? FieldFactory.newFulltextField(result.rootIncludePath, value) : FieldFactory.newFulltextField(value);
        if (pd != null) {
            field.setBoost(pd.boost);
        }
        doc.add(field);
    }

    protected Document initDoc() {
        Document doc = new Document();
        doc.add(FieldFactory.newPathField(this.path));
        return doc;
    }

    protected boolean augmentCustomFields(String path, Document doc, NodeState document) {
        boolean dirty = false;
        if (this.augmentorFactory != null) {
            Iterable<Field> augmentedFields = this.augmentorFactory.getIndexFieldProvider(this.indexingRule.getNodeTypeName()).getAugmentedFields(path, document, this.definition.getDefinitionNodeState());
            for (Field field : augmentedFields) {
                doc.add(field);
                dirty = true;
            }
        }
        return dirty;
    }

    protected Document finalizeDoc(Document doc, boolean dirty, boolean facet) throws IOException {
        if (facet && this.isFacetingEnabled()) {
            doc = this.getFacetsConfig().build(doc);
        }
        List<IndexableField> fields = doc.getFields();
        Field suggestField = null;
        for (IndexableField f : fields) {
            if (!":suggest".equals(f.name())) continue;
            if (suggestField == null) {
                suggestField = FieldFactory.newSuggestField(f.stringValue());
                continue;
            }
            suggestField = FieldFactory.newSuggestField(suggestField.stringValue(), f.stringValue());
        }
        doc.removeFields(":suggest");
        if (suggestField != null) {
            doc.add(suggestField);
        }
        return doc;
    }

    protected boolean isFacetingEnabled() {
        return this.facetsConfigProvider != null;
    }

    protected boolean indexTypeOrderedFields(Document doc, String pname, int tag, PropertyState property, PropertyDefinition pd) {
        boolean fieldAdded;
        block16: {
            String name = FieldNames.createDocValFieldName((String)pname);
            fieldAdded = false;
            Field f = null;
            try {
                if (tag == Type.LONG.tag()) {
                    f = new NumericDocValuesField(name, property.getValue(Type.LONG));
                } else if (tag == Type.DATE.tag()) {
                    String date = property.getValue(Type.DATE);
                    f = new NumericDocValuesField(name, FieldFactory.dateToLong(date));
                } else if (tag == Type.DOUBLE.tag()) {
                    f = new DoubleDocValuesField(name, property.getValue(Type.DOUBLE));
                } else if (tag == Type.BOOLEAN.tag()) {
                    f = new SortedDocValuesField(name, new BytesRef(property.getValue(Type.BOOLEAN).toString()));
                } else if (tag == Type.STRING.tag()) {
                    String stringValue = property.getValue(Type.STRING);
                    f = new SortedDocValuesField(name, LuceneDocumentMaker.getTruncatedBytesRef(name, stringValue, this.path, 32766));
                }
                if (f != null && this.includePropertyValue(property, 0, pd)) {
                    if (doc.getField(f.name()) == null) {
                        doc.add(f);
                        fieldAdded = true;
                    } else if (!LOG_SILENCER.silence(LOG_KEY_DUPLICATE)) {
                        LOG.warn("Duplicate value for ordered field {}; ignoring. Possibly duplicate index definition.", (Object)f.name());
                    }
                }
            }
            catch (Exception e) {
                String message = e.getMessage();
                String key = message.startsWith(LOG_KEY_NOT_A_DATE_STRING) ? LOG_KEY_NOT_A_DATE_STRING : (message.startsWith(LOG_KEY_UNABLE_TO_PARSE) ? LOG_KEY_UNABLE_TO_PARSE : (message.startsWith(LOG_KEY_FOR_INPUT_STRING) ? LOG_KEY_FOR_INPUT_STRING : LOG_KEY_UNKNOWN));
                if (LOG_SILENCER.silence(key)) break block16;
                if (key.equals(LOG_KEY_UNKNOWN)) {
                    LOG.warn("[{}] Ignoring ordered property. Could not convert property {} of type {} to type {} for path {}", this.getIndexName(), pname, Type.fromTag(property.getType().tag(), false), Type.fromTag(tag, false), this.path, e);
                }
                LOG.warn("[{}] Ignoring ordered property. Could not convert property {} of type {} to type {} for path {}, message {}", this.getIndexName(), pname, Type.fromTag(property.getType().tag(), false), Type.fromTag(tag, false), this.path, e.getMessage());
            }
        }
        return fieldAdded;
    }

    protected static BytesRef getTruncatedBytesRef(String prop, String value, String path, int maxLength) {
        BytesRef ref = new BytesRef(value);
        if (ref.length <= maxLength) {
            return ref;
        }
        LOG.trace("Property {} at path:[{}] has value {}", prop, path, value);
        LOG.info("Truncating property {} at path:[{}] as length after encoding {} is > {} ", prop, path, ref.length, maxLength);
        int end = maxLength - 1;
        while ((ref.bytes[end] & 0xC0) == 128) {
            --end;
        }
        if ((ref.bytes[end] & 0xC0) == 192) {
            --end;
        }
        byte[] truncatedBytes = Arrays.copyOf(ref.bytes, end + 1);
        String truncated = new String(truncatedBytes, StandardCharsets.UTF_8);
        ref = new BytesRef(truncated);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Truncated property {} at path:[{}] to {}", prop, path, ref.utf8ToString());
        }
        while (ref.length > maxLength) {
            LOG.error("Truncation did not work: still {} bytes", (Object)ref.length);
            truncated = truncated.substring(0, truncated.length() - 10);
            ref = new BytesRef(truncated);
        }
        return ref;
    }

    private FacetsConfig getFacetsConfig() {
        return this.facetsConfigProvider.getFacetsConfig();
    }

    protected void indexNodeName(Document doc, String value) {
        doc.add(new StringField(":nodeName", value, Field.Store.NO));
    }

    protected boolean indexSimilarityTag(Document doc, PropertyState property) {
        doc.add(new TextField("simtags", property.getValue(Type.STRING), Field.Store.YES));
        return true;
    }

    protected void indexSimilarityStrings(Document doc, PropertyDefinition pd, String value) {
        for (Field f : FieldFactory.newSimilarityFields(pd.name, value)) {
            doc.add(f);
        }
        if (pd.similarityRerank) {
            for (Field f : FieldFactory.newBinSimilarityFields(pd.name, value)) {
                doc.add(f);
            }
        }
    }

    protected void indexSimilarityBinaries(Document doc, PropertyDefinition pd, Blob blob) throws IOException {
        for (Field f : FieldFactory.newSimilarityFields(pd.name, blob)) {
            doc.add(f);
        }
        if (pd.similarityRerank) {
            for (Field f : FieldFactory.newBinSimilarityFields(pd.name, blob)) {
                doc.add(f);
            }
        }
    }

    protected boolean indexDynamicBoost(Document doc, String parent, String nodeName, String value, double confidence) {
        ArrayList<String> tokens = new ArrayList<String>(LuceneDocumentMaker.splitForIndexing(value));
        if (tokens.size() > 1) {
            tokens.add(value);
        }
        boolean added = false;
        for (String token : tokens) {
            AugmentedField f;
            if (token.isEmpty() || doc.getField((f = new AugmentedField(parent + "/" + token.toLowerCase(), confidence)).name()) != null) continue;
            doc.add(f);
            added = true;
        }
        if (added && LOG.isTraceEnabled()) {
            LOG.trace("Added augmented fields: {}[{}], {}", parent + "/", String.join((CharSequence)", ", tokens), confidence);
        }
        return added;
    }

    private static List<String> splitForIndexing(String tagName) {
        return Arrays.asList(LuceneDocumentMaker.removeBackSlashes(tagName).split(DYNAMIC_BOOST_SPLIT_REGEX));
    }

    private static String removeBackSlashes(String text) {
        return text.replaceAll("\\\\", "");
    }

    private static class AugmentedField
    extends Field {
        private static final FieldType ft = new FieldType();

        AugmentedField(String name, double weight) {
            super(name, "1", ft);
            this.setBoost((float)weight);
        }

        static {
            ft.setIndexed(true);
            ft.setStored(false);
            ft.setTokenized(false);
            ft.setOmitNorms(false);
            ft.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            ft.freeze();
        }
    }
}

