/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.apache.commons.io.FileUtils;

@Deprecated
public class SHA1 {
    public static final SHA1 NULL = new SHA1(0, 0, 0, 0, 0);
    private final int w0;
    private final int w1;
    private final int w2;
    private final int w3;
    private final int w4;

    public SHA1(int w0, int w1, int w2, int w3, int w4) {
        this.w0 = w0;
        this.w1 = w1;
        this.w2 = w2;
        this.w3 = w3;
        this.w4 = w4;
    }

    public SHA1(String str) {
        if (str.length() != 40) {
            throw new IllegalArgumentException("invalid string length " + str.length());
        }
        this.w0 = (int)Long.parseLong(str.substring(0, 8), 16);
        this.w1 = (int)Long.parseLong(str.substring(8, 16), 16);
        this.w2 = (int)Long.parseLong(str.substring(16, 24), 16);
        this.w3 = (int)Long.parseLong(str.substring(24, 32), 16);
        this.w4 = (int)Long.parseLong(str.substring(32, 40), 16);
    }

    public SHA1(byte[] bytes) {
        if (bytes.length != 20) {
            throw new IllegalArgumentException("invalid bytes length " + bytes.length);
        }
        this.w0 = SHA1.getInt(bytes, 0);
        this.w1 = SHA1.getInt(bytes, 4);
        this.w2 = SHA1.getInt(bytes, 8);
        this.w3 = SHA1.getInt(bytes, 12);
        this.w4 = SHA1.getInt(bytes, 16);
    }

    public int[] getInts() {
        return new int[]{this.w0, this.w1, this.w2, this.w3, this.w4};
    }

    public byte[] getBytes() {
        byte[] buf = new byte[20];
        SHA1.setInt(buf, 0, this.w0);
        SHA1.setInt(buf, 4, this.w1);
        SHA1.setInt(buf, 8, this.w2);
        SHA1.setInt(buf, 12, this.w3);
        SHA1.setInt(buf, 16, this.w4);
        return buf;
    }

    public static SHA1 digest(InputStream in) throws IOException {
        int read;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) > 0) {
            md.update(buffer, 0, read);
        }
        return new SHA1(md.digest());
    }

    public static SHA1 digest(File file) throws IOException {
        try (FileInputStream input = FileUtils.openInputStream(file);){
            SHA1 sHA1 = SHA1.digest(input);
            return sHA1;
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "%08x%08x%08x%08x%08x", this.w0, this.w1, this.w2, this.w3, this.w4);
    }

    public int hashCode() {
        return this.w2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SHA1 sha1 = (SHA1)o;
        return this.w0 == sha1.w0 && this.w1 == sha1.w1 && this.w2 == sha1.w2 && this.w3 == sha1.w3 && this.w4 == sha1.w4;
    }

    private static int getInt(byte[] b, int offs) {
        return ((b[offs] & 0xFF) << 24) + ((b[1 + offs] & 0xFF) << 16) + ((b[2 + offs] & 0xFF) << 8) + (b[3 + offs] & 0xFF);
    }

    private static void setInt(byte[] b, int offs, int v) {
        b[offs] = (byte)(v >>> 24 & 0xFF);
        b[offs + 1] = (byte)(v >>> 16 & 0xFF);
        b[offs + 2] = (byte)(v >>> 8 & 0xFF);
        b[offs + 3] = (byte)(v & 0xFF);
    }
}

