/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.utils;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.tika.io.IOUtils;
import org.apache.tika.utils.RereadableInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipSalvager {
    private static final Logger LOG = LoggerFactory.getLogger(ZipSalvager.class);

    public static void salvageCopy(InputStream brokenZip, File salvagedZip, boolean allowStoredEntries) throws IOException {
        block34: {
            if (!(brokenZip instanceof RereadableInputStream)) {
                brokenZip = new RereadableInputStream(brokenZip, 50000, true, false);
            }
            try {
                try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(salvagedZip);
                     ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(brokenZip, "UTF8", false, allowStoredEntries);){
                    ZipArchiveEntry zae = zipArchiveInputStream.getNextZipEntry();
                    try {
                        ZipSalvager.processZAE(zae, zipArchiveInputStream, outputStream);
                    }
                    catch (UnsupportedZipFeatureException uzfe) {
                        if (uzfe.getFeature() == UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR) {
                            throw uzfe;
                        }
                    }
                    catch (EOFException | ZipException iOException) {
                        // empty catch block
                    }
                    outputStream.flush();
                    outputStream.finish();
                }
                catch (UnsupportedZipFeatureException e) {
                    throw e;
                }
                catch (IOException e) {
                    LOG.warn("problem fixing zip", e);
                }
            }
            catch (UnsupportedZipFeatureException e) {
                if (allowStoredEntries) break block34;
                ((RereadableInputStream)brokenZip).rewind();
                ZipSalvager.salvageCopy(brokenZip, salvagedZip, true);
            }
        }
    }

    private static void processZAE(ZipArchiveEntry zae, ZipArchiveInputStream zipArchiveInputStream, ZipArchiveOutputStream outputStream) throws IOException {
        while (zae != null) {
            if (!zae.isDirectory() && zipArchiveInputStream.canReadEntryData(zae)) {
                outputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(zae.getName()));
                boolean successfullyCopied = false;
                try {
                    IOUtils.copy((InputStream)zipArchiveInputStream, (OutputStream)outputStream);
                    successfullyCopied = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                outputStream.flush();
                outputStream.closeArchiveEntry();
                if (!successfullyCopied) break;
            }
            zae = zipArchiveInputStream.getNextZipEntry();
        }
    }

    public static void salvageCopy(File brokenZip, File salvagedZip) throws IOException {
        try (InputStream is = Files.newInputStream(brokenZip.toPath(), new OpenOption[0]);){
            ZipSalvager.salvageCopy(is, salvagedZip, false);
        }
    }
}

