/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.function;

import java.util.Objects;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.util.function.Exceptions;

@FunctionalInterface
@ConsumerType
public interface Supplier<T> {
    public T get() throws Exception;

    public static <T> java.util.function.Supplier<T> asJavaSupplier(Supplier<T> wrapped) {
        Objects.requireNonNull(wrapped);
        return () -> {
            try {
                return wrapped.get();
            }
            catch (Exception e) {
                throw Exceptions.throwUnchecked(e);
            }
        };
    }

    public static <T> java.util.function.Supplier<T> asJavaSupplierOrElse(Supplier<T> wrapped, T orElse) {
        Objects.requireNonNull(wrapped);
        return () -> {
            try {
                return wrapped.get();
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    public static <T> java.util.function.Supplier<T> asJavaSupplierOrElseGet(Supplier<T> wrapped, java.util.function.Supplier<? extends T> orElseGet) {
        Objects.requireNonNull(wrapped);
        return () -> {
            try {
                return wrapped.get();
            }
            catch (Exception e) {
                return orElseGet.get();
            }
        };
    }

    public static <T> Supplier<T> asSupplier(java.util.function.Supplier<T> wrapped) {
        Objects.requireNonNull(wrapped);
        return wrapped::get;
    }
}

