/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2021 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.adobe.cq.dam.cfm.extensions;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

import java.util.List;

/**
 * Reference resolver that extracts the content fragments created based on a given content fragment model
 */
@ProviderType
public interface ModelReferenceResolver {

    /**
     * Find the content fragments created based on a given content fragment model
     *
     * @param model    - content fragment model
     * @param resolver - resource resolver
     * @return the list of paths associated to matched content fragments
     */
    List<String> getReferences(@NotNull Resource model, @NotNull ResourceResolver resolver);

    /**
     * Find the content fragments created based on a given content fragment model
     *
     * @param model-   content fragment model
     * @param resolver - resource resolver
     * @param maxRef   - the maximum number of results to be extracted
     * @return the list of paths associated to matched content fragments
     */
    List<String> getReferences(@NotNull Resource model, @NotNull ResourceResolver resolver, String maxRef);

    /**
     * Find the content fragments created based on a given content fragment model path.
     * It can be used when the model does not exist anymore.
     *
     * @param modelPath - content fragment model path
     * @param resolver  - resource resolver
     * @param maxRef    - the maximum number of results to be extracted
     * @return the list of paths associated to matched content fragments
     */
    List<String> getReferences(@NotNull String modelPath, @NotNull ResourceResolver resolver, String maxRef);
}
