/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.dam.print.ids;

public enum PrintFormat {
    
    PDF("pdf"),
    JPG("jpg"),
    INDD("indd"),
    XML("xml");
    
    String format;
    PrintFormat(String form) {
        format = form;
    }
    public String getFormat(){
        return format;
    }
    
    public static PrintFormat fromString(String format){
        for (PrintFormat pf: PrintFormat.values()){
            if(format.equalsIgnoreCase(pf.format)){
                return pf;
            }
        }
        return null;
    }
    
}
