/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2016 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.adobe.granite.ui.components;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Component(configurationPid = FormConfig.PID,
    service = Servlet.class
)
@SlingServletPaths("/libs/granite/ui/components/formconfig")
@Designate(ocd=FormConfig.class)
@ServiceDescription("Form Restriction Configuration")
public class FormRestrict extends SlingAllMethodsServlet {

    String[] allowedPaths;
    String restrictBehavior;

    private static final Logger log = LoggerFactory.getLogger(FormRestrict.class);

    protected void setup(FormConfig config) {
        this.allowedPaths = config.allowed_paths();
        this.restrictBehavior = config.restrict_behavior();
    }

    @Activate
    protected void activate(FormConfig config) {
        this.setup(config);
    }

    @Modified
    protected void modified(FormConfig config) {
        this.setup(config);
    }

    @Override
    protected void doGet(final SlingHttpServletRequest request, final SlingHttpServletResponse response)
        throws ServletException, IOException {

        if (!"json".equals(request.getRequestPathInfo().getExtension())) {
            response.sendError(HttpServletResponse.SC_NOT_FOUND);
            return;
        }

        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");

        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for(String path : allowedPaths) {
            jsonArray.add(path);
        }

        jsonObject.add("allowedpaths", jsonArray);
        jsonObject.addProperty("restrictbehavior", this.restrictBehavior);

        new Gson().toJson(jsonObject, response.getWriter());
    }

}
