/*
 * Copyright 1997-2012 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.servlets;

import com.day.cq.replication.ReplicationStatus;
import org.apache.felix.scr.annotations.Component;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.Collator;
import java.util.*;

/**
 * The <code>AbstractReplicableListServlet</code> provides base functionality
 * such as sorting and paging for servlets that feed Ext grids (like in the
 * SiteAdmin) with JSON. In contrast to <code>AbstractListServlet</code>
 * sorting by <code>ReplicationStatus</code> is supported.
 * Normally, the list of children of the addressed resource are returned.
 * Alternatively, the paging index of an item can be requested.
 * @deprecated use {@link com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet} instead
 */
@Deprecated
@Component(metatype = false, componentAbstract = true)
public class AbstractReplicableListServlet extends AbstractListServlet {

    /**
     * Value of the sort paramter to indicate to sort the results by
     * replication date.
     */
    public static final String SORT_REPLICATION = "replication";

    private final Logger log = LoggerFactory.getLogger(AbstractReplicableListServlet.class);

    /**
     * {@inheritDoc}
     * @deprecated
     */
    @Deprecated
    protected List<AbstractListServlet.ListItem> applySorting(SlingHttpServletRequest request,
                                          List<AbstractListServlet.ListItem> items) {
        log.warn("AbstractReplicableListServlet.applySorting has been deprecated. Please use com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet.applySorting instead.");
        String sortKey = request.getParameter(SORT_KEY) != null ?
                request.getParameter(SORT_KEY) : DEFAULT_SORT_KEY;
        String sortDir = request.getParameter(SORT_DIR) != null ?
                request.getParameter(SORT_DIR) : DEFAULT_SORT_DIR;

        /* set collator strength */
        getCollator().setStrength(Collator.PRIMARY);

        // apply sorting
        if (!(DEFAULT_SORT_KEY.equals(sortKey) && DEFAULT_SORT_DIR.equals(sortDir))) {
            Collections.sort(items, new ListItemComparator(sortKey));
            if (SORT_DESCENDING.equals(sortDir)) {
                Collections.reverse(items);
            }
        }
        return items;
    }

    /**
     * {@inheritDoc}
     * @deprecated use {@link com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet.ListItem} instead
     */
    @SuppressWarnings({"UnusedDeclaration"})
    @Deprecated
    public interface ListItem extends AbstractListServlet.ListItem {

        /**
         * Get the replication status of the item
         * @return ReplicationStatus replication status
         * @deprecated use {@link com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet.ListItem#getReplicationStatus()} instead
         */
        @Deprecated
        ReplicationStatus getReplicationStatus();
    }

    /**
     * {@inheritDoc}
     * @deprecated use {@link com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet.ListItemComparator} instead
     */
    @Deprecated
    public class ListItemComparator implements Comparator<AbstractListServlet.ListItem> {

        private String compareField;

        /**
         * {@inheritDoc}
         * @deprecated use {@link com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet.ListItemComparator#ListItemComparator(String)} instead
         */
        @Deprecated
        public ListItemComparator(String compareField) {
            this.compareField = compareField;
        }

        /**
         * {@inheritDoc}
         * @deprecated use {@link com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet.ListItemComparator#compare(com.day.cq.commons.predicates.servlets.AbstractListServlet.ListItem,
         * com.day.cq.commons.predicates.servlets.AbstractListServlet.ListItem)} instead
         */
        @Deprecated
        public int compare(AbstractListServlet.ListItem li1, AbstractListServlet.ListItem li2) {
            log.warn("AbstractReplicableListServlet.ListItemComparator.compare has been deprecated. Please use com.day.cq.commons.predicates.servlets.AbstractReplicableListServlet.ListItemComparator.compare instead.");
            Object v1, v2;
            try {
                ListItem o1 = (ListItem) li1;
                ListItem o2 = (ListItem) li2;

                if (SORT_REPLICATION.equals(compareField)) {
                    Calendar c1 = o1.getReplicationStatus().getLastPublished();
                    Calendar c2 = o2.getReplicationStatus().getLastPublished();
                    v1 = c1 == null ? 0 : c1.getTimeInMillis();
                    v2 = c2 == null ? 0 : c2.getTimeInMillis();
                } else {
                    v1 = o1.getClass().getField(compareField).get(o1);
                    v2 = o2.getClass().getField(compareField).get(o2);
                }
                if (v1 == null && v2 == null) {
                    return 0;
                } else if (v1 == null) {
                    return -1;
                } else if (v2 == null) {
                    return 1;
                } else if (v1 instanceof String && v2 instanceof String) {
                    Collator collator = getCollator();
                    return (collator != null) ? collator.compare((String)v1, (String)v2) : ((String)v1).compareTo((String)v2);
                } else if (v1 instanceof Integer && v2 instanceof Integer) {
                    int int1 = (Integer)v1;
                    int int2 = (Integer)v2;
                    return (int1 > int2 ? 1 : int1 != int2 ? -1 : 0);
                } else if (v1 instanceof Long && v2 instanceof Long) {
                    long long1 = (Long)v1;
                    long long2 = (Long)v2;
                    return (long1 > long2 ? 1 : long1 != long2 ? -1 : 0);
                }
            } catch (Exception ignored) {
            }
            return 0;
        }

    }

}
