/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/
package com.day.cq.security;

import org.apache.sling.api.request.RequestParameter;

import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import java.net.URL;
import java.util.Map;

/**
 * Simple Utility for User-Account self services.
 * Provides basics for creation and password handling.
 * The Profile can be read and stored via its API
 *
 * @deprecated since CQ 6.2 Use com.adobe.cq.account.api.AccountManagementService instead.
 */
public interface AccountManager {

    /**
     * <p>findAccount.</p>
     *
     * @param fragment of the id / name
     * @return User or null if no User is related to the fragment
     */
    User findAccount(String fragment);

    /**
     * Convenience to create a new {@link com.day.cq.security.User User} together
     * with setting properties in one method call.
     * Where the keys are the property names and the value the
     *
     * @param uid to create account for
     * @param pwd to set on the new user account
     * @param group to assign membership to the new group
     * @param properties to set
     * @return User or <code>null</code> if no User is related to the fragment
     * @throws javax.jcr.RepositoryException in case of error creating the user
     * @throws javax.jcr.AccessDeniedException in case of missing privileges to create accounts
     * @see UserManager#createUser(String, String, String, String)
     */
    User createAccount(String uid, String pwd, String group,  Map<String, RequestParameter[]> properties)
            throws AccessDeniedException, RepositoryException;

    /**
     * Convenience update an Account with a set of properties
     * with setting properties in one method call.
     *
     * @param user to update
     * @param properties to set
     * @throws javax.jcr.RepositoryException in case of error updating the account
     */
    void updateAccount(User user,  Map<String, RequestParameter[]> properties) throws RepositoryException;

    /**
     * Convenience to either search and update an existing account or create it
     *
     * @param id of the account to update or to use for creation
     * @param pwd   in case the account should be created
     * @param group to assign to a newly created user
     * @param properties to set to the user
     * @return account modified
     * @throws javax.jcr.RepositoryException in case of error creating the user
     * @throws javax.jcr.AccessDeniedException in case of missing privileges to create accounts
     * @see #findAccount(String)
     * @see #createAccount(String, String, String, Map)
     * @see #updateAccount(User, Map)
     * @see #findAccount(String)
     * @see #createAccount(String, String, String, Map)
     * @see #updateAccount(User, Map)
     * @see #findAccount(String)
     * @see #createAccount(String, String, String, Map)
     * @see #updateAccount(User, Map)
     */
    User getOrCreateAccount(String id, String pwd, String group, Map<String, RequestParameter[]> properties)
            throws AccessDeniedException, RepositoryException;

    /**
     * Reset the Password of the Account to a randomly generated
     *
     * @param user to reset the password for
     * @return the newly generated password
     * @throws javax.jcr.RepositoryException in case of error creating the user
     * @throws javax.jcr.AccessDeniedException in case of missing privileges to create accounts
     */
    String resetPassword(User user) throws AccessDeniedException, RepositoryException;

    /**
     * Reset the Password of the Account to a randomly generated, requires a key
     * in order to verify, that the reset has been requested by the key owner.
     * The key is the result of the call to request o password reset
     * {@link #requestPasswordReset(User, URL)}
     *
     * @param user to reset the password for
     * @param key required to reset the password
     * @return the newly generated password or null on failure
     * @throws javax.jcr.RepositoryException in case of error creating the user
     * @throws javax.jcr.AccessDeniedException in case of missing privileges to create accounts
     * @see #requestPasswordReset(User, URL)
     */
    String resetPassword(User user, String key) throws AccessDeniedException, RepositoryException;

    /**
     * Set the Password of the Account to a given password. Requires a key
     * in order to verify, that the reset has been requested by the key owner.
     * The key is the result of the call to request o password reset
     * {@link #requestPasswordReset(User, URL)}
     *
     * @param user to reset the password for
     * @param key required to set the password
     * @param pwd new password
     * @return true on success, false on failure
     * @throws javax.jcr.RepositoryException in case of error creating the user
     * @throws javax.jcr.AccessDeniedException in case of missing privileges to create accounts
     * @see #requestPasswordReset(User, URL)
     */
    boolean setPassword(User user, String key, String pwd) throws AccessDeniedException, RepositoryException;

    /**
     * Request a password rest. Results in a key that has to be presented in order
     * to finally set the Password to some new {@link #resetPassword(User, String) value}.
     *
     * @param user to reset the password for
     * @param requestUrl the url called to request the reset
     * @throws javax.jcr.RepositoryException in case of error creating the user
     * @throws javax.jcr.AccessDeniedException in case of missing privileges to create accounts
     * @see #resetPassword(User, String)
     * @return a key that allows to reset the password
     */
    boolean requestPasswordReset(User user, URL requestUrl) throws RepositoryException;

    /**
     * Request for creating a new account. Results in a mail being sent to the requester which
     * contains further information how to complete account generation.
     *
     * @param email  email address of requester
     * @param requestUrl the url called to request the reset
     * @return  true if account request succeeded, false otherwise
     * @throws javax.jcr.RepositoryException if any.
     */
    boolean requestAccount(String email, URL requestUrl) throws RepositoryException;

    /**
     * Simple utility to send a mail to a given user account.
     * Adds the ability to replace variables within the mail body with properties
     * from the User.
     * This Properties can be addressed by using their name as variable name.
     *
     * @param user to receive the mail
     * @param from the from e-mail address
     * @param subject of the mail to send
     * @param body of the mail to send
     * @param replace map of replacements for variables, with variable name as key
     *        and value as value
     * @return true if the mail could be send
     * @throws javax.jcr.RepositoryException in case of error accessing the repository
     */
    boolean sendMail(User user, String from, String subject, String body, Map<String, String> replace)
            throws RepositoryException;
}
