/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2015 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.cq.spellchecker.spi;

import aQute.bnd.annotation.ConsumerType;
import com.day.cq.spellchecker.SpellCheckException;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * The <code>SpellCheckerProvider</code> is a service providing instances of
 * {@link SpellChecker}
 * <p>
 * This interface can be implemented by implementors of the {@link SpellChecker}
 * interface to generate instances for different languages.
 * <p>
 * Services of this type are not intended for general consumption. These
 * services are for use as the backend for the {@link com.day.cq.spellchecker.SpellCheckService}.
 */
@ConsumerType
public interface SpellCheckerProvider {

    /**
     * Creates a new spellchecker.
     *
     * @param language Language/country to create spellchecker for
     * @param dictionaryPaths Locations to look for dictionaries. If this is
     *            {@code null} an internal default is being used.
     * @param resolver
     * @return The spellchecker instance
     * @throws com.day.cq.spellchecker.SpellCheckException if a spellchecker could not be created for
     *             the desired language
     */
    SpellChecker createSpellChecker(String language, String[] dictionaryPaths, ResourceResolver resolver) throws SpellCheckException;

}
