/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.launcher;

import javax.jcr.RepositoryException;
import java.util.List;

/**
 * The <code>WorkflowLauncher</code> starts workflow depending on:
 * <ul>
 *  <li>jcr event
 *  <li>path (regular expression)
 *  <li>nodetype
 * </ul>
 */
public interface WorkflowLauncher {

    /**
     * Add new launcher configuration entry
     * @param entry  launcher config entry
     * @throws RepositoryException
     */
    void addConfigEntry(ConfigEntry entry) throws RepositoryException;

    /**
     * Remove launcher config entry
     * @param id config entry id
     * @throws RepositoryException
     */
    void removeConfigEntry(String id) throws RepositoryException;

    /**
     * Get list of all config entries
     * @return list of all config entries
     */
    List<ConfigEntry> getConfigEntries();

    /**
     * Edit existing config entry
     * @param id id if existing config entry
     * @param configEntry modified config entry
     */
    void editConfigEntry(String id, ConfigEntry configEntry) throws RepositoryException;
}
